/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project;

import io.fabric8.forge.camel.commands.project.AbstractCamelProjectCommand;
import io.fabric8.forge.camel.commands.project.CamelEndpointDetails;
import io.fabric8.forge.camel.commands.project.ConfigureEndpointPropertiesStep;
import io.fabric8.forge.camel.commands.project.completer.RouteBuilderCompleter;
import io.fabric8.forge.camel.commands.project.completer.XmlResourcesCamelEndpointsVisitor;
import io.fabric8.forge.camel.commands.project.helper.CamelCommandsHelper;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.jboss.forge.addon.dependencies.DependencyResolver;
import org.jboss.forge.addon.facets.constraints.FacetConstraint;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.dependencies.DependencyInstaller;
import org.jboss.forge.addon.projects.facets.ClassLoaderFacet;
import org.jboss.forge.addon.projects.facets.ResourcesFacet;
import org.jboss.forge.addon.resource.visit.ResourceVisitor;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UINavigationContext;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.addon.ui.wizard.UIWizard;

@FacetConstraint(value={JavaSourceFacet.class, ResourcesFacet.class, ClassLoaderFacet.class})
public class CamelAddEndpointRouteBuilderCommand
extends AbstractCamelProjectCommand
implements UIWizard {
    @Inject
    @WithAttributes(label="componentNameFilter", required=false, description="To filter components")
    private UISelectOne<String> componentNameFilter;
    @Inject
    @WithAttributes(label="componentName", required=true, description="Name of component type to add")
    private UISelectOne<String> componentName;
    @Inject
    @WithAttributes(label="instanceName", required=true, description="Name of endpoint instance to add")
    private UIInput<String> instanceName;
    @Inject
    @WithAttributes(label="routeBuilder", required=true, description="The RouteBuilder class to use")
    private UISelectOne<String> routeBuilder;
    @Inject
    private DependencyInstaller dependencyInstaller;
    @Inject
    private DependencyResolver dependencyResolver;

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(CamelAddEndpointRouteBuilderCommand.class).name("Camel: Add Endpoint RouteBuilder").category(Categories.create((String[])new String[]{CATEGORY})).description("Adds a Camel endpoint to an existing RouteBuilder");
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        Project project = this.getSelectedProject(builder.getUIContext());
        final JavaSourceFacet facet = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
        this.componentNameFilter.setValueChoices(CamelCommandsHelper.createComponentNameValues(project));
        this.componentNameFilter.setDefaultValue((Object)"<all>");
        this.componentName.setValueChoices(CamelCommandsHelper.createComponentNameValues(project, this.componentNameFilter, false));
        this.instanceName.setDefaultValue((Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                String value = (String)CamelAddEndpointRouteBuilderCommand.this.componentName.getValue();
                if (value != null) {
                    value = value.replaceAll("-", "");
                }
                ArrayList<CamelEndpointDetails> endpoints = new ArrayList<CamelEndpointDetails>();
                XmlResourcesCamelEndpointsVisitor visitor = new XmlResourcesCamelEndpointsVisitor((ResourcesFacet)facet, endpoints);
                ((ResourcesFacet)facet).visitResources((ResourceVisitor)visitor);
                for (CamelEndpointDetails det : endpoints) {
                    if (det.getEndpointInstance() == null || !det.getEndpointInstance().equals(CamelAddEndpointRouteBuilderCommand.this.instanceName)) continue;
                    return null;
                }
                return value;
            }
        });
        this.routeBuilder.setValueChoices(new RouteBuilderCompleter(facet).getRouteBuilders());
        builder.add(this.componentNameFilter).add(this.componentName).add(this.instanceName).add(this.routeBuilder);
    }

    public NavigationResult next(UINavigationContext context) throws Exception {
        Map attributeMap = context.getUIContext().getAttributeMap();
        attributeMap.put("componentName", this.componentName.getValue());
        attributeMap.put("instanceName", this.instanceName.getValue());
        attributeMap.put("routeBuilder", this.routeBuilder.getValue());
        attributeMap.put("kind", "java");
        return Results.navigateTo(ConfigureEndpointPropertiesStep.class);
    }

    public Result execute(UIExecutionContext context) throws Exception {
        return Results.success();
    }
}

