/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project;

import io.fabric8.forge.addon.utils.Indenter;
import io.fabric8.forge.addon.utils.OutputFormatHelper;
import io.fabric8.forge.addon.utils.dto.OutputFormat;
import io.fabric8.forge.camel.commands.project.AbstractCamelProjectCommand;
import io.fabric8.forge.camel.commands.project.dto.ContextDto;
import io.fabric8.forge.camel.commands.project.dto.NodeDtos;
import io.fabric8.forge.camel.commands.project.helper.CamelXmlHelper;
import java.util.List;
import javax.inject.Inject;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;

public class CamelGetRoutesXmlCommand
extends AbstractCamelProjectCommand {
    @Inject
    @WithAttributes(label="XML File", required=true, description="The XML file to use (either Spring or Blueprint)")
    private UISelectOne<String> xml;
    @Inject
    @WithAttributes(label="Format", defaultValue="Text", description="Format output as text or json")
    private UISelectOne<OutputFormat> format;

    @Override
    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(CamelGetRoutesXmlCommand.class).name("Camel: Get Routes XML").category(Categories.create((String[])new String[]{CATEGORY})).description("Gets the overview of the routes in a project for a given XML file");
    }

    @Override
    public boolean isEnabled(UIContext context) {
        boolean answer = super.isEnabled(context);
        if (answer) {
            boolean gui = this.isRunningInGui(context);
            answer = !gui;
        }
        return answer;
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        Project project = this.getSelectedProject(builder.getUIContext());
        String currentFile = this.getSelectedFile(builder.getUIContext());
        String selected = this.configureXml(project, this.xml, currentFile);
        builder.add(this.xml).add(this.format);
    }

    public Result execute(UIExecutionContext context) throws Exception {
        Project project = this.getSelectedProject((UIContextProvider)context);
        String xmlResourceName = (String)this.xml.getValue();
        List<ContextDto> camelContexts = CamelXmlHelper.loadCamelContext(this.getCamelCatalog(), context.getUIContext(), project, xmlResourceName);
        if (camelContexts == null) {
            return Results.fail((String)("No file found for: " + xmlResourceName));
        }
        String result = this.formatResult(camelContexts);
        return Results.success((String)result);
    }

    protected String formatResult(List<ContextDto> result) throws Exception {
        OutputFormat outputFormat = (OutputFormat)this.format.getValue();
        switch (outputFormat) {
            case JSON: {
                return OutputFormatHelper.toJson(result);
            }
        }
        return this.textResult(result);
    }

    protected String textResult(List<ContextDto> camelContexts) throws Exception {
        StringBuilder buffer = new StringBuilder("\n\n");
        Indenter out = new Indenter((Appendable)buffer);
        for (ContextDto camelContext : camelContexts) {
            NodeDtos.printNode(out, camelContext);
        }
        return buffer.toString();
    }
}

