/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project;

import io.fabric8.forge.addon.utils.CamelProjectHelper;
import io.fabric8.forge.addon.utils.LineNumberHelper;
import io.fabric8.forge.addon.utils.XmlLineNumberParser;
import io.fabric8.forge.camel.commands.project.AbstractCamelProjectCommand;
import io.fabric8.forge.camel.commands.project.helper.CamelCatalogHelper;
import io.fabric8.forge.camel.commands.project.helper.CamelCommandsHelper;
import io.fabric8.forge.camel.commands.project.helper.CamelJavaParserHelper;
import io.fabric8.forge.camel.commands.project.helper.PoorMansLogger;
import io.fabric8.forge.camel.commands.project.helper.StringHelper;
import io.fabric8.forge.camel.commands.project.model.CamelComponentDetails;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.camel.catalog.CamelCatalog;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.parser.java.resources.JavaResource;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.projects.dependencies.DependencyInstaller;
import org.jboss.forge.addon.projects.facets.ResourcesFacet;
import org.jboss.forge.addon.projects.facets.WebResourcesFacet;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UINavigationContext;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.addon.ui.wizard.UIWizardStep;
import org.jboss.forge.roaster.model.source.AnnotationSource;
import org.jboss.forge.roaster.model.source.FieldSource;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.JavaSource;
import org.jboss.forge.roaster.model.source.MethodSource;
import org.jboss.forge.roaster.model.util.Strings;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConfigureEndpointPropertiesStep
extends AbstractCamelProjectCommand
implements UIWizardStep {
    private static final PoorMansLogger LOG = new PoorMansLogger(false);
    private final DependencyInstaller dependencyInstaller;
    private final CamelCatalog camelCatalog;
    private final String componentName;
    private final String group;
    private final List<InputComponent> allInputs;
    private final List<InputComponent> inputs;
    private final boolean last;
    private final int index;
    private final int total;

    public ConfigureEndpointPropertiesStep(ProjectFactory projectFactory, DependencyInstaller dependencyInstaller, CamelCatalog camelCatalog, String componentName, String group, List<InputComponent> allInputs, List<InputComponent> inputs, boolean last, int index, int total) {
        this.projectFactory = projectFactory;
        this.dependencyInstaller = dependencyInstaller;
        this.camelCatalog = camelCatalog;
        this.componentName = componentName;
        this.group = group;
        this.allInputs = allInputs;
        this.inputs = inputs;
        this.last = last;
        this.index = index + 1;
        this.total = total;
    }

    public String getGroup() {
        return this.group;
    }

    public int getIndex() {
        return this.index;
    }

    public int getTotal() {
        return this.total;
    }

    @Override
    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(ConfigureEndpointPropertiesStep.class).name("Camel: Endpoint options").category(Categories.create((String[])new String[]{CATEGORY})).description(String.format("Configure %s options (%s of %s)", this.group, this.index, this.total));
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        if (this.inputs != null) {
            for (InputComponent input : this.inputs) {
                builder.add(input);
            }
        }
    }

    public NavigationResult next(UINavigationContext context) throws Exception {
        return null;
    }

    public Result execute(UIExecutionContext context) throws Exception {
        Map attributeMap = context.getUIContext().getAttributeMap();
        if (this.last) {
            String kind = ConfigureEndpointPropertiesStep.mandatoryAttributeValue(attributeMap, "kind");
            if ("xml".equals(kind)) {
                return this.executeXml(context, attributeMap);
            }
            return this.executeJava(context, attributeMap);
        }
        return null;
    }

    protected Result executeXml(UIExecutionContext context, Map<Object, Object> attributeMap) throws Exception {
        FileResource file;
        Dependency core;
        String camelComponentName = ConfigureEndpointPropertiesStep.optionalAttributeValue(attributeMap, "componentName");
        String endpointInstanceName = ConfigureEndpointPropertiesStep.optionalAttributeValue(attributeMap, "instanceName");
        String mode = ConfigureEndpointPropertiesStep.mandatoryAttributeValue(attributeMap, "mode");
        String xml = ConfigureEndpointPropertiesStep.mandatoryAttributeValue(attributeMap, "xml");
        String lineNumber = null;
        String lineNumberEnd = null;
        String endpointUrl = null;
        if ("edit".equals(mode)) {
            lineNumber = ConfigureEndpointPropertiesStep.mandatoryAttributeValue(attributeMap, "lineNumber");
            lineNumberEnd = ConfigureEndpointPropertiesStep.optionalAttributeValue(attributeMap, "lineNumberEnd");
            endpointUrl = ConfigureEndpointPropertiesStep.mandatoryAttributeValue(attributeMap, "endpointUri");
            endpointUrl = StringHelper.replaceAll(endpointUrl, "&amp;", "&");
            endpointUrl = StringHelper.replaceAll(endpointUrl, "&", "&amp;");
            endpointUrl = StringHelper.replaceAll(endpointUrl, "<", "&lt;");
            endpointUrl = StringHelper.replaceAll(endpointUrl, ">", "&gt;");
        }
        Project project = this.getSelectedProject((UIContextProvider)context);
        ResourcesFacet facet = (ResourcesFacet)project.getFacet(ResourcesFacet.class);
        WebResourcesFacet webResourcesFacet = null;
        if (project.hasFacet(WebResourcesFacet.class)) {
            webResourcesFacet = (WebResourcesFacet)project.getFacet(WebResourcesFacet.class);
        }
        if ((core = CamelProjectHelper.findCamelCoreDependency((Project)project)) == null) {
            return Results.fail((String)"The project does not include camel-core");
        }
        CamelComponentDetails details = new CamelComponentDetails();
        Result result = CamelCommandsHelper.loadCamelComponentDetails(this.camelCatalog, camelComponentName, details);
        if (result != null) {
            return result;
        }
        result = CamelCommandsHelper.ensureCamelArtifactIdAdded(project, details, this.dependencyInstaller);
        if (result != null) {
            return result;
        }
        HashMap<String, String> options = new HashMap<String, String>();
        for (InputComponent input : this.allInputs) {
            String value;
            String key = input.getName();
            if (input.hasValue()) {
                value = input.getValue().toString();
                if (value == null) continue;
                boolean isMultiValue = CamelCatalogHelper.isMultiValue(this.camelCatalog, camelComponentName, key);
                if (isMultiValue) {
                    String prefix = CamelCatalogHelper.getPrefix(this.camelCatalog, camelComponentName, key);
                    value = StringHelper.replaceAll(value, "&amp;", "&");
                    value = StringHelper.replaceAll(value, "&", "&amp;");
                    StringBuilder sb = new StringBuilder();
                    String[] parts = value.split("&amp;");
                    for (int i = 0; i < parts.length; ++i) {
                        String part = parts[i];
                        if (!part.startsWith(prefix)) {
                            part = prefix + part;
                        }
                        sb.append(part);
                        if (i >= parts.length - 1) continue;
                        sb.append("&amp;");
                    }
                    value = sb.toString();
                }
                boolean matchDefault = CamelCatalogHelper.isDefaultValue(this.camelCatalog, camelComponentName, key, value);
                if ("none".equals(value)) {
                    boolean nonePlaceholder = CamelCatalogHelper.isNonePlaceholderEnumValue(this.camelCatalog, camelComponentName, key);
                    if (matchDefault || nonePlaceholder) continue;
                    options.put(key, value);
                    continue;
                }
                if (matchDefault) continue;
                options.put(key, value);
                continue;
            }
            if (!input.isRequired() || !input.hasDefaultValue() || (value = input.getValue().toString()) == null) continue;
            options.put(key, value);
        }
        String uri = this.camelCatalog.asEndpointUriXml(camelComponentName, options, false);
        LOG.info("Uri created: " + uri);
        if (uri == null) {
            return Results.fail((String)"Cannot create endpoint uri");
        }
        FileResource fileResource = file = facet != null ? facet.getResource(xml) : null;
        if (file == null || !file.exists()) {
            FileResource fileResource2 = file = webResourcesFacet != null ? webResourcesFacet.getWebResource(xml) : null;
        }
        if (file == null || !file.exists()) {
            return Results.fail((String)("Cannot find XML file " + xml));
        }
        String cursorPosition = ConfigureEndpointPropertiesStep.optionalAttributeValue(attributeMap, "cursorPosition");
        if (cursorPosition != null) {
            return this.addEndpointXml(file, uri, endpointInstanceName, xml, cursorPosition);
        }
        return this.addOrEditEndpointXml(file, uri, endpointUrl, endpointInstanceName, xml, lineNumber, lineNumberEnd);
    }

    protected Result addOrEditEndpointXml(FileResource file, String uri, String endpointUrl, String endpointInstanceName, String xml, String lineNumber, String lineNumberEnd) throws Exception {
        if (lineNumber != null) {
            List lines = LineNumberHelper.readLines((InputStream)file.getResourceInputStream());
            return this.editEndpointXml(lines, lineNumber, endpointUrl, uri, file, xml);
        }
        Document root = XmlLineNumberParser.parseXml((InputStream)file.getResourceInputStream());
        return this.addEndpointXml(root, endpointInstanceName, uri, file, xml);
    }

    private Result editEndpointXml(List<String> lines, String lineNumber, String endpointUrl, String uri, FileResource file, String xml) {
        int idx = Integer.valueOf(lineNumber) - 1;
        String line = lines.get(idx);
        line = StringHelper.replaceAll(line, endpointUrl, uri);
        lines.set(idx, line);
        LOG.info("Updating " + endpointUrl + " to " + uri + " at line " + lineNumber + " in file " + xml);
        String content = LineNumberHelper.linesToString(lines);
        file.setContents(content);
        return Results.success((String)("Update endpoint uri: " + uri + " in file " + xml));
    }

    private Result addEndpointXml(Document root, String endpointInstanceName, String uri, FileResource file, String xml) throws Exception {
        NodeList camels;
        if (root != null && (camels = root.getElementsByTagName("camelContext")) != null && camels.getLength() == 1) {
            Node camel = camels.item(0);
            Node camelContext = null;
            boolean created = false;
            Node found = null;
            for (int i = 0; i < camel.getChildNodes().getLength(); ++i) {
                String id;
                Node child;
                if ("camelContext".equals(camel.getNodeName())) {
                    camelContext = camel;
                }
                if ("camelContext".equals((child = camel.getChildNodes().item(i)).getNodeName())) {
                    camelContext = child;
                }
                if (!"endpoint".equals(child.getNodeName()) || !endpointInstanceName.equals(id = child.getAttributes().getNamedItem("id").getNodeValue())) continue;
                found = child;
                break;
            }
            int extraSpaces = 0;
            int extraLines = 0;
            if (found == null) {
                created = true;
                found = this.insertEndpointBefore(camel);
                if (found == null) {
                    found = camelContext;
                    extraSpaces = 2;
                    extraLines = 1;
                }
            }
            if (found == null) {
                return Results.fail((String)("Cannot find <camelContext> in XML file " + xml));
            }
            String lineNumber = (String)found.getUserData("lineNumber");
            List lines = LineNumberHelper.readLines((InputStream)file.getResourceInputStream());
            String line = String.format("<endpoint id=\"%s\" uri=\"%s\"/>", endpointInstanceName, uri);
            int idx = lineNumber != null ? Integer.valueOf(lineNumber) - 1 : 0;
            int spaces = LineNumberHelper.leadingSpaces((List)lines, (int)(idx += extraLines)) + extraSpaces;
            line = LineNumberHelper.padString((String)line, (int)spaces);
            if (created) {
                lines.add(idx, line);
            } else {
                lines.set(idx, line);
            }
            String content = LineNumberHelper.linesToString((List)lines);
            file.setContents(content);
        }
        return Results.success((String)("Added endpoint uri: " + uri + " in XML file " + xml));
    }

    private Result addEndpointXml(FileResource file, String uri, String endpointInstanceName, String xml, String cursorPosition) throws Exception {
        LOG.info("Adding uri " + uri + " at position " + cursorPosition + " in file " + xml);
        StringBuilder sb = new StringBuilder(file.getContents());
        int pos = Integer.valueOf(cursorPosition);
        int prev = pos - 1;
        int next = pos + 1;
        char ch = sb.charAt(prev);
        char ch2 = sb.charAt(next);
        if (ch != '\"' && ch2 != '\"') {
            uri = "\"" + uri + "\"";
        }
        sb.insert(pos, uri);
        String text = sb.toString();
        file.setContents(text);
        return Results.success((String)("Added endpoint " + uri + " in " + xml));
    }

    protected Result executeJava(UIExecutionContext context, Map<Object, Object> attributeMap) throws Exception {
        String camelComponentName = ConfigureEndpointPropertiesStep.mandatoryAttributeValue(attributeMap, "componentName");
        String endpointInstanceName = ConfigureEndpointPropertiesStep.optionalAttributeValue(attributeMap, "instanceName");
        String mode = ConfigureEndpointPropertiesStep.mandatoryAttributeValue(attributeMap, "mode");
        String routeBuilder = ConfigureEndpointPropertiesStep.mandatoryAttributeValue(attributeMap, "routeBuilder");
        String lineNumber = null;
        String lineNumberEnd = null;
        String endpointUrl = null;
        if ("edit".equals(mode)) {
            lineNumber = ConfigureEndpointPropertiesStep.mandatoryAttributeValue(attributeMap, "lineNumber");
            lineNumberEnd = ConfigureEndpointPropertiesStep.optionalAttributeValue(attributeMap, "lineNumberEnd");
            endpointUrl = ConfigureEndpointPropertiesStep.mandatoryAttributeValue(attributeMap, "endpointUri");
        }
        Project project = this.getSelectedProject((UIContextProvider)context);
        JavaSourceFacet facet = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
        Dependency core = CamelProjectHelper.findCamelCoreDependency((Project)project);
        if (core == null) {
            return Results.fail((String)"The project does not include camel-core");
        }
        CamelComponentDetails details = new CamelComponentDetails();
        Result result = CamelCommandsHelper.loadCamelComponentDetails(this.camelCatalog, camelComponentName, details);
        if (result != null) {
            return result;
        }
        result = CamelCommandsHelper.ensureCamelArtifactIdAdded(project, details, this.dependencyInstaller);
        if (result != null) {
            return result;
        }
        HashMap<String, String> options = new HashMap<String, String>();
        for (InputComponent input : this.allInputs) {
            String value;
            String key = input.getName();
            if (input.hasValue()) {
                value = input.getValue().toString();
                if (value == null) continue;
                boolean isMultiValue = CamelCatalogHelper.isMultiValue(this.camelCatalog, camelComponentName, key);
                if (isMultiValue) {
                    String prefix = CamelCatalogHelper.getPrefix(this.camelCatalog, camelComponentName, key);
                    value = StringHelper.replaceAll(value, "&amp;", "&");
                    value = StringHelper.replaceAll(value, "&", "&amp;");
                    StringBuilder sb = new StringBuilder();
                    String[] parts = value.split("&amp;");
                    for (int i = 0; i < parts.length; ++i) {
                        String part = parts[i];
                        if (!part.startsWith(prefix)) {
                            part = prefix + part;
                        }
                        sb.append(part);
                        if (i >= parts.length - 1) continue;
                        sb.append("&");
                    }
                    value = sb.toString();
                }
                boolean matchDefault = CamelCatalogHelper.isDefaultValue(this.camelCatalog, camelComponentName, key, value);
                if ("none".equals(value)) {
                    boolean nonePlaceholder = CamelCatalogHelper.isNonePlaceholderEnumValue(this.camelCatalog, camelComponentName, key);
                    if (matchDefault || nonePlaceholder) continue;
                    options.put(key, value);
                    continue;
                }
                if (matchDefault) continue;
                options.put(key, value);
                continue;
            }
            if (!input.isRequired() || !input.hasDefaultValue() || (value = input.getValue().toString()) == null) continue;
            options.put(key, value);
        }
        String uri = this.camelCatalog.asEndpointUri(camelComponentName, options, false);
        if (uri == null) {
            return Results.fail((String)"Cannot create endpoint uri");
        }
        JavaResource file = facet.getJavaResource(routeBuilder);
        if (file == null || !file.exists()) {
            return Results.fail((String)("RouteBuilder " + routeBuilder + " does not exist"));
        }
        String cursorPosition = ConfigureEndpointPropertiesStep.optionalAttributeValue(attributeMap, "cursorPosition");
        if (cursorPosition != null) {
            return this.addEndpointJava(project, facet, file, uri, endpointInstanceName, routeBuilder, cursorPosition);
        }
        return this.addOrEditEndpointJava(project, facet, file, uri, endpointUrl, endpointInstanceName, routeBuilder, lineNumber, lineNumberEnd);
    }

    protected Result addOrEditEndpointJava(Project project, JavaSourceFacet facet, JavaResource file, String uri, String endpointUrl, String endpointInstanceName, String routeBuilder, String lineNumber, String lineNumberEnd) throws Exception {
        JavaClassSource clazz = (JavaClassSource)file.getJavaType();
        boolean updated = true;
        boolean newCode = false;
        if (endpointInstanceName != null) {
            boolean cdi;
            FieldSource field = clazz.getField(endpointInstanceName);
            if (field == null) {
                field = clazz.addField();
                field.setName(endpointInstanceName);
                field.setType("org.apache.camel.Endpoint");
                field.setPrivate();
                updated = false;
                newCode = true;
            }
            boolean bl = cdi = CamelProjectHelper.findCamelArtifactDependency((Project)project, (String)"camel-cdi") != null;
            if (cdi) {
                if (!field.hasAnnotation("javax.inject.Inject")) {
                    field.addAnnotation("javax.inject.Inject");
                    newCode = true;
                }
                if (!field.hasAnnotation("org.apache.camel.cdi.Uri")) {
                    field.addAnnotation("org.apache.camel.cdi.Uri");
                    newCode = true;
                }
                AnnotationSource annotation = field.getAnnotation("org.apache.camel.cdi.Uri");
                annotation.setStringValue(uri);
            } else {
                if (!field.hasAnnotation("org.apache.camel.EndpointInject")) {
                    field.addAnnotation("org.apache.camel.EndpointInject");
                    newCode = true;
                }
                AnnotationSource annotation = field.getAnnotation("org.apache.camel.EndpointInject");
                annotation.setStringValue("uri", uri);
            }
            if (!clazz.hasImport("org.apache.camel.Endpoint")) {
                clazz.addImport("org.apache.camel.Endpoint");
                newCode = true;
            }
            if (cdi) {
                if (!clazz.hasImport("javax.inject.Inject")) {
                    clazz.addImport("javax.inject.Inject");
                    newCode = true;
                }
                if (!clazz.hasImport("org.apache.camel.cdi.Uri")) {
                    clazz.addImport("org.apache.camel.cdi.Uri");
                    newCode = true;
                }
            } else if (!clazz.hasImport("org.apache.camel.EndpointInject")) {
                clazz.addImport("org.apache.camel.EndpointInject");
                newCode = true;
            }
            if (!newCode && lineNumber != null) {
                List lines = LineNumberHelper.readLines((InputStream)file.getResourceInputStream());
                int idx = Integer.valueOf(lineNumber) - 1;
                if (idx <= lines.size()) {
                    String line = (String)lines.get(idx);
                    String find = Pattern.quote(endpointUrl);
                    line = line.replaceFirst(find, uri);
                    lines.set(idx, line);
                    String content = LineNumberHelper.linesToString((List)lines);
                    file.setContents(content);
                } else {
                    newCode = true;
                }
            }
            if (newCode) {
                facet.saveJavaSource((JavaSource)clazz);
            }
            if (updated) {
                return Results.success((String)("Updated endpoint " + endpointInstanceName + " in " + routeBuilder));
            }
            return Results.success((String)("Added endpoint " + endpointInstanceName + " in " + routeBuilder));
        }
        MethodSource<JavaClassSource> method = CamelJavaParserHelper.findConfigureMethod(clazz);
        if (method != null) {
            String code = clazz.toUnformattedString();
            String find = Pattern.quote(endpointUrl);
            code = code.replaceFirst(find, uri);
            file.setContents((InputStream)new ByteArrayInputStream(code.getBytes()), null);
            return Results.success((String)("Updated endpoint " + endpointUrl + " -> " + uri + " in " + routeBuilder));
        }
        return Results.fail((String)"Cannot update endpoint");
    }

    protected Result addEndpointJava(Project project, JavaSourceFacet facet, JavaResource file, String uri, String endpointInstanceName, String routeBuilder, String cursorPosition) throws Exception {
        JavaClassSource clazz = (JavaClassSource)file.getJavaType();
        StringBuilder sb = new StringBuilder(clazz.toUnformattedString());
        int pos = Integer.valueOf(cursorPosition);
        int prev = pos - 1;
        int next = pos + 1;
        char ch = sb.charAt(prev);
        char ch2 = sb.charAt(next);
        if (ch != '\"' && ch2 != '\"') {
            uri = "\"" + uri + "\"";
        }
        sb.insert(pos, uri);
        file.setContents(sb.toString());
        return Results.success((String)("Added endpoint " + uri + " in " + routeBuilder));
    }

    private Node insertEndpointBefore(Node camel) {
        Node endpoint = null;
        for (int i = 0; i < camel.getChildNodes().getLength(); ++i) {
            Node found = camel.getChildNodes().item(i);
            String name = found.getNodeName();
            if (!"endpoint".equals(name)) continue;
            endpoint = found;
        }
        if (endpoint != null) {
            return endpoint;
        }
        Node last = null;
        for (int i = 0; i < camel.getChildNodes().getLength(); ++i) {
            Node found = camel.getChildNodes().item(i);
            String name = found.getNodeName();
            if ("dataFormats".equals(name) || "redeliveryPolicyProfile".equals(name) || "onException".equals(name) || "onCompletion".equals(name) || "intercept".equals(name) || "interceptFrom".equals(name) || "interceptSendToEndpoint".equals(name) || "restConfiguration".equals(name) || "rest".equals(name) || "route".equals(name)) {
                return found;
            }
            if (found.getNodeType() != 1) continue;
            last = found;
        }
        return last;
    }

    public static String mandatoryAttributeValue(Map<Object, Object> attributeMap, String name) {
        String text;
        Object value = attributeMap.get(name);
        if (value != null && !Strings.isBlank((String)(text = value.toString()))) {
            return text;
        }
        throw new IllegalArgumentException("The attribute value '" + name + "' did not get passed on from the previous wizard page");
    }

    public static String optionalAttributeValue(Map<Object, Object> attributeMap, String name) {
        String text;
        Object value = attributeMap.get(name);
        if (value != null && !Strings.isBlank((String)(text = value.toString()))) {
            return text;
        }
        return null;
    }
}

