/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project;

import io.fabric8.forge.camel.commands.project.AbstractCamelProjectCommand;
import io.fabric8.forge.camel.commands.project.EditNodeXmlStep;
import io.fabric8.forge.camel.commands.project.dto.NodeDto;
import io.fabric8.forge.camel.commands.project.helper.CamelCommandsHelper;
import io.fabric8.forge.camel.commands.project.helper.CamelXmlHelper;
import io.fabric8.forge.camel.commands.project.model.InputOptionByGroup;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.util.IntrospectionSupport;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.ui.command.UICommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UINavigationContext;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.InputComponentFactory;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.result.navigation.NavigationResultBuilder;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.addon.ui.wizard.UIWizard;
import org.w3c.dom.Element;

public class CamelEditNodeXmlCommand
extends AbstractCamelProjectCommand
implements UIWizard {
    @Inject
    @WithAttributes(label="XML File", required=true, description="The XML file to use (either Spring or Blueprint)")
    private UISelectOne<String> xml;
    @Inject
    @WithAttributes(label="Node", required=true, description="Node to edit")
    private UISelectOne<NodeDto> node;
    @Inject
    private InputComponentFactory componentFactory;

    @Override
    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(CamelEditNodeXmlCommand.class).name("Camel: Edit Node XML").category(Categories.create((String[])new String[]{CATEGORY})).description("Edits a node in a Camel XML file");
    }

    @Override
    public boolean isEnabled(UIContext context) {
        boolean enabled = super.isEnabled(context);
        if (enabled) {
            boolean spring = CamelCommandsHelper.isSpringProject(this.getSelectedProject(context));
            boolean blueprint = CamelCommandsHelper.isBlueprintProject(this.getSelectedProject(context));
            return spring || blueprint;
        }
        return false;
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        UIContext context = builder.getUIContext();
        Map attributeMap = context.getAttributeMap();
        attributeMap.remove("navigationResult");
        Project project = this.getSelectedProject(context);
        String first = this.configureXml(project, this.xml);
        CamelEditNodeXmlCommand.configureNode(context, project, first, this.xml, this.node);
        builder.add(this.xml).add(this.node);
    }

    public NavigationResult next(UINavigationContext context) throws Exception {
        NavigationResult navigationResult;
        Project project = this.getSelectedProject((UIContextProvider)context);
        Map attributeMap = context.getUIContext().getAttributeMap();
        String xmlResourceName = (String)this.xml.getValue();
        attributeMap.put("xml", xmlResourceName);
        attributeMap.put("mode", "edit");
        attributeMap.put("kind", "xml");
        NodeDto editNode = (NodeDto)this.node.getValue();
        String key = editNode.getKey();
        String previous = this.getNodeKey(attributeMap.get("node"));
        if (previous != null && previous.equals(key) && (navigationResult = (NavigationResult)attributeMap.get("navigationResult")) != null) {
            return navigationResult;
        }
        attributeMap.put("node", key);
        String nodeName = editNode.getPattern();
        attributeMap.put("nodeName", nodeName);
        attributeMap.put("pattern", editNode.getPattern());
        Element selectedElement = this.getSelectedCamelElementNode(project, xmlResourceName, key);
        if (selectedElement == null) {
            throw new IllegalArgumentException("Cannot find xml for node " + editNode);
        }
        String lineNumber = (String)selectedElement.getUserData("lineNumber");
        String lineNumberEnd = (String)selectedElement.getUserData("lineNumberEnd");
        attributeMap.put("lineNumber", lineNumber);
        attributeMap.put("lineNumberEnd", lineNumberEnd);
        LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
        try {
            ClassLoader cl = CamelCatalog.class.getClassLoader();
            Object model = CamelXmlHelper.xmlAsModel(selectedElement, cl);
            LinkedHashMap temp = new LinkedHashMap();
            IntrospectionSupport.getProperties((Object)model, temp, null);
            for (Map.Entry entry : temp.entrySet()) {
                String k = (String)entry.getKey();
                Object v = entry.getValue();
                if (v instanceof ExpressionDefinition) {
                    ExpressionDefinition exp = (ExpressionDefinition)v;
                    String text = exp.getExpression();
                    String lan = exp.getLanguage();
                    options.put(k, lan);
                    options.put(k + "_value", text);
                    continue;
                }
                String text = v != null ? v.toString() : null;
                if (text == null) continue;
                options.put(k, text);
            }
        }
        catch (Exception cl) {
            // empty catch block
        }
        UIContext ui = context.getUIContext();
        List<InputOptionByGroup> groups = CamelCommandsHelper.createUIInputsForCamelEIP(nodeName, 20, options, this.getCamelCatalog(), this.componentFactory, this.converterFactory, ui);
        ArrayList<InputComponent> allInputs = new ArrayList<InputComponent>();
        for (InputOptionByGroup group : groups) {
            allInputs.addAll(group.getInputs());
        }
        NavigationResultBuilder builder = Results.navigationBuilder();
        int pages = groups.size();
        for (int i = 0; i < pages; ++i) {
            boolean last = i == pages - 1;
            InputOptionByGroup current = groups.get(i);
            EditNodeXmlStep step = new EditNodeXmlStep(this.projectFactory, this.getCamelCatalog(), nodeName, current.getGroup(), allInputs, current.getInputs(), last, i, pages);
            builder.add((UICommand)step);
        }
        NavigationResult navigationResult2 = builder.build();
        attributeMap.put("navigationResult", navigationResult2);
        return navigationResult2;
    }

    private String getNodeKey(Object value) {
        if (value instanceof NodeDto) {
            NodeDto nodeDto = (NodeDto)value;
            return nodeDto.getKey();
        }
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }

    public Result execute(UIExecutionContext context) throws Exception {
        return Results.success();
    }
}

