/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.forge.camel.commands.project.dto.NodeDto;
import io.fabric8.forge.camel.commands.project.dto.NodeDtos;
import io.fabric8.utils.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public abstract class NodeDtoSupport {
    private String key;
    private String id;
    private String pattern;
    private String label;
    private String description;

    public NodeDtoSupport() {
    }

    public NodeDtoSupport(String key, String id, String label, String pattern, String description) {
        this.key = key;
        this.id = id;
        this.label = label;
        this.pattern = pattern;
        this.description = description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeDtoSupport that = (NodeDtoSupport)o;
        if (!this.key.equals(that.key)) {
            return false;
        }
        return this.pattern != null ? this.pattern.equals(that.pattern) : that.pattern == null;
    }

    public int hashCode() {
        int result = this.key.hashCode();
        result = 31 * result + (this.pattern != null ? this.pattern.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.pattern + "{" + "id='" + this.id + '\'' + ", label='" + this.label + '\'' + '}';
    }

    public abstract List<NodeDto> getChildren();

    public abstract void addChild(NodeDto var1);

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void defaultKey(NodeDto owner, Map<String, Integer> nodeCounts) {
        String elementName = this.getPattern();
        Integer countObject = nodeCounts.get(elementName);
        int count = countObject != null ? countObject : 0;
        nodeCounts.put(elementName, ++count);
        if (Strings.isNullOrBlank((String)this.key)) {
            this.key = owner.getKey();
            this.key = Strings.isNullOrBlank((String)this.key) ? "" : this.key + "/";
            this.key = Strings.isNotBlank((String)this.id) ? this.key + this.id : this.key + "_" + elementName + count;
        }
    }

    public List<NodeDto> toNodeList(String indentation) {
        ArrayList<NodeDto> answer = new ArrayList<NodeDto>();
        this.addToNodeList(answer, "", indentation);
        return answer;
    }

    protected void addToNodeList(List<NodeDto> answer, String indent, String indentation) {
        NodeDto copy = this.copy();
        copy.setLabel(indent + NodeDtos.getNodeText(copy));
        answer.add(copy);
        indent = indent + indentation;
        for (NodeDto child : this.getChildren()) {
            child.addToNodeList(answer, indent, indentation);
        }
    }

    protected abstract NodeDto copy();
}

