/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project.helper;

import io.fabric8.camel.tooling.util.CamelModelHelper;
import io.fabric8.camel.tooling.util.RouteXml;
import io.fabric8.camel.tooling.util.XmlModel;
import io.fabric8.forge.addon.utils.CommandHelpers;
import io.fabric8.forge.addon.utils.JaxbNoNamespaceWriter;
import io.fabric8.forge.camel.commands.project.dto.ContextDto;
import io.fabric8.forge.camel.commands.project.dto.NodeDto;
import io.fabric8.forge.camel.commands.project.dto.RouteDto;
import io.fabric8.utils.Files;
import io.fabric8.utils.Objects;
import io.fabric8.utils.Strings;
import java.io.File;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.OptionalIdentifiedDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.ToDefinition;
import org.apache.camel.spring.CamelContextFactoryBean;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.input.UIInput;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class CamelXmlHelper {
    public static final String JAXB_CONTEXT_PACKAGES = "org.apache.camel:org.apache.camel.model:org.apache.camel.model.config:org.apache.camel.model.dataformat:org.apache.camel.model.language:org.apache.camel.model.loadbalancer:org.apache.camel.model.rest";

    public static Node findEndpointById(Document dom, String endpointId) {
        NodeList list = dom.getElementsByTagName("endpoint");
        for (int i = 0; i < list.getLength(); ++i) {
            String id;
            Node child = list.item(i);
            if (!"endpoint".equals(child.getNodeName()) || !endpointId.equals(id = child.getAttributes().getNamedItem("id").getNodeValue())) continue;
            return child;
        }
        return null;
    }

    public static List<Element> findAllContexts(Document dom) {
        ArrayList<Element> nodes = new ArrayList<Element>();
        NodeList list = dom.getElementsByTagName("camelContext");
        for (int i = 0; i < list.getLength(); ++i) {
            Node node;
            NamedNodeMap attrs;
            Node child = list.item(i);
            String ns = child.getNamespaceURI();
            if (ns == null && (attrs = child.getAttributes()) != null && (node = attrs.getNamedItem("xmlns")) != null) {
                ns = node.getNodeValue();
            }
            if (ns != null && !ns.contains("camel") || !(child instanceof Element)) continue;
            nodes.add((Element)child);
        }
        return nodes;
    }

    public static List<Node> findAllEndpoints(Document dom) {
        Node child;
        int i;
        ArrayList<Node> nodes = new ArrayList<Node>();
        NodeList list = dom.getElementsByTagName("endpoint");
        for (i = 0; i < list.getLength(); ++i) {
            Node node;
            NamedNodeMap attrs;
            child = list.item(i);
            if (!"endpoint".equals(child.getNodeName())) continue;
            String ns = child.getNamespaceURI();
            if (ns == null && (attrs = child.getAttributes()) != null && (node = attrs.getNamedItem("xmlns")) != null) {
                ns = node.getNodeValue();
            }
            if (ns != null && !ns.contains("camel")) continue;
            nodes.add(child);
        }
        list = dom.getElementsByTagName("onException");
        for (i = 0; i < list.getLength(); ++i) {
            child = list.item(i);
            CamelXmlHelper.findAllUrisRecursive(child, nodes);
        }
        list = dom.getElementsByTagName("onCompletion");
        for (i = 0; i < list.getLength(); ++i) {
            child = list.item(i);
            CamelXmlHelper.findAllUrisRecursive(child, nodes);
        }
        list = dom.getElementsByTagName("intercept");
        for (i = 0; i < list.getLength(); ++i) {
            child = list.item(i);
            CamelXmlHelper.findAllUrisRecursive(child, nodes);
        }
        list = dom.getElementsByTagName("interceptFrom");
        for (i = 0; i < list.getLength(); ++i) {
            child = list.item(i);
            CamelXmlHelper.findAllUrisRecursive(child, nodes);
        }
        list = dom.getElementsByTagName("interceptSendToEndpoint");
        for (i = 0; i < list.getLength(); ++i) {
            child = list.item(i);
            CamelXmlHelper.findAllUrisRecursive(child, nodes);
        }
        list = dom.getElementsByTagName("rest");
        for (i = 0; i < list.getLength(); ++i) {
            child = list.item(i);
            if (!"route".equals(child.getNodeName()) && !"to".equals(child.getNodeName())) continue;
            CamelXmlHelper.findAllUrisRecursive(child, nodes);
        }
        list = dom.getElementsByTagName("route");
        for (i = 0; i < list.getLength(); ++i) {
            child = list.item(i);
            if (!"route".equals(child.getNodeName())) continue;
            CamelXmlHelper.findAllUrisRecursive(child, nodes);
        }
        return nodes;
    }

    private static void findAllUrisRecursive(Node node, List<Node> nodes) {
        NodeList children;
        String url = CamelXmlHelper.getSafeAttribute(node, "uri");
        if (url != null) {
            nodes.add(node);
        }
        if ((children = node.getChildNodes()) != null) {
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (child.getNodeType() != 1) continue;
                CamelXmlHelper.findAllUrisRecursive(child, nodes);
            }
        }
    }

    public static List<Node> findAllSimpleExpressions(Document dom) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        NodeList list = dom.getElementsByTagName("route");
        for (int i = 0; i < list.getLength(); ++i) {
            Node child = list.item(i);
            if (!"route".equals(child.getNodeName())) continue;
            CamelXmlHelper.findAllSimpleExpressionsRecursive(child, nodes);
        }
        return nodes;
    }

    private static void findAllSimpleExpressionsRecursive(Node node, List<Node> nodes) {
        NodeList children;
        if ("simple".equals(node.getNodeName())) {
            nodes.add(node);
        }
        if ((children = node.getChildNodes()) != null) {
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (child.getNodeType() != 1) continue;
                CamelXmlHelper.findAllSimpleExpressionsRecursive(child, nodes);
            }
        }
    }

    public static String getSafeAttribute(Node node, String key) {
        Node attr;
        if (node != null && (attr = node.getAttributes().getNamedItem(key)) != null) {
            return attr.getNodeValue();
        }
        return null;
    }

    public static String trimEndpointUri(String uri) {
        uri = uri.trim();
        uri = uri.replaceAll("(\\s+)(\\&)", "$2");
        uri = uri.replaceAll("(\\&)(\\s+)", "$1");
        uri = uri.replaceAll("(\\?)(\\s+)", "$1");
        return uri;
    }

    public static String createFileName(UIInput<String> directory, UIInput<String> name) {
        return directory.getValue() != null ? (String)directory.getValue() + File.separator + (String)name.getValue() : (String)name.getValue();
    }

    public static List<ContextDto> loadCamelContext(UIContext context, Project project, String xmlResourceName) throws Exception {
        List<ContextDto> camelContexts = null;
        String xmlFileName = io.fabric8.forge.addon.utils.Files.joinPaths((String)"src/main/resources", (String)xmlResourceName);
        File xmlFile = CommandHelpers.getProjectContextFile((UIContext)context, (Project)project, (String)xmlFileName);
        if (!Files.isFile((File)xmlFile)) {
            xmlFileName = io.fabric8.forge.addon.utils.Files.joinPaths((String)"src/main/webapp/", (String)xmlResourceName);
            xmlFile = CommandHelpers.getProjectContextFile((UIContext)context, (Project)project, (String)xmlFileName);
        }
        if (Files.isFile((File)xmlFile)) {
            camelContexts = CamelXmlHelper.parseCamelContexts(xmlFile);
        }
        return camelContexts;
    }

    protected static List<ContextDto> parseCamelContexts(File xmlFile) throws Exception {
        ArrayList<ContextDto> camelContexts = new ArrayList<ContextDto>();
        RouteXml routeXml = new RouteXml();
        XmlModel xmlModel = routeXml.unmarshal(xmlFile);
        CamelContextFactoryBean contextElement = xmlModel.getContextElement();
        String name = contextElement.getId();
        List routeDefs = contextElement.getRoutes();
        ContextDto context = new ContextDto(name);
        camelContexts.add(context);
        String key = name;
        if (Strings.isNullOrBlank((String)key)) {
            key = "_camelContext" + camelContexts.size();
        }
        context.setKey(key);
        List<NodeDto> routes = CamelXmlHelper.createRouteDtos(routeDefs, context);
        context.setChildren(routes);
        return camelContexts;
    }

    protected static List<NodeDto> createRouteDtos(List<RouteDefinition> routeDefs, ContextDto context) {
        ArrayList<NodeDto> answer = new ArrayList<NodeDto>();
        HashMap<String, Integer> nodeCounts = new HashMap<String, Integer>();
        for (RouteDefinition def : routeDefs) {
            RouteDto route = new RouteDto();
            route.setId(def.getId());
            route.setLabel(CamelModelHelper.getDisplayText((OptionalIdentifiedDefinition)def));
            route.setDescription(CamelModelHelper.getDescription((OptionalIdentifiedDefinition)def));
            answer.add(route);
            route.defaultKey(context, nodeCounts);
            CamelXmlHelper.addInputs(route, def.getInputs());
            CamelXmlHelper.addOutputs(route, def.getOutputs());
        }
        return answer;
    }

    protected static void addInputs(NodeDto owner, List<FromDefinition> inputs) {
        HashMap<String, Integer> nodeCounts = new HashMap<String, Integer>();
        for (FromDefinition input : inputs) {
            CamelXmlHelper.addChild(owner, (OptionalIdentifiedDefinition)input, nodeCounts);
        }
    }

    protected static void addOutputs(NodeDto owner, List<ProcessorDefinition<?>> outputs) {
        HashMap<String, Integer> nodeCounts = new HashMap<String, Integer>();
        for (ProcessorDefinition<?> output : outputs) {
            CamelXmlHelper.addChild(owner, output, nodeCounts);
        }
    }

    private static NodeDto addChild(NodeDto owner, OptionalIdentifiedDefinition definition, Map<String, Integer> nodeCounts) {
        FromDefinition endpointDef;
        NodeDto node = new NodeDto();
        node.setId(definition.getId());
        node.setLabel(CamelModelHelper.getDisplayText((OptionalIdentifiedDefinition)definition));
        node.setDescription(CamelModelHelper.getDescription((OptionalIdentifiedDefinition)definition));
        node.setPattern(CamelModelHelper.getPatternName((OptionalIdentifiedDefinition)definition));
        owner.addChild(node);
        node.defaultKey(owner, nodeCounts);
        if (definition instanceof FromDefinition) {
            endpointDef = (FromDefinition)definition;
            node.setProperty("uri", endpointDef.getUri());
        }
        if (definition instanceof ToDefinition) {
            endpointDef = (ToDefinition)definition;
            node.setProperty("uri", endpointDef.getUri());
        }
        if (definition instanceof ProcessorDefinition) {
            ProcessorDefinition processorDefinition = (ProcessorDefinition)definition;
            CamelXmlHelper.addOutputs(node, processorDefinition.getOutputs());
        }
        return node;
    }

    public static Node findCamelNodeInDocument(Document root, String key) {
        Node selectedNode = null;
        if (root != null && Strings.isNotBlank((String)key)) {
            String[] paths = key.split("/");
            NodeList camels = root.getElementsByTagName("camelContext");
            if (camels != null) {
                HashMap<String, Integer> rootNodeCounts = new HashMap<String, Integer>();
                int size = camels.getLength();
                for (int i = 0; i < size; ++i) {
                    Node node = camels.item(i);
                    boolean first = true;
                    for (String path : paths) {
                        if (first) {
                            first = false;
                            String actual = CamelXmlHelper.getIdOrIndex(node, rootNodeCounts);
                            if (!Objects.equal((Object)actual, (Object)path)) {
                                node = null;
                            }
                        } else {
                            node = CamelXmlHelper.findCamelNodeForPath(node, path);
                        }
                        if (node == null) break;
                    }
                    if (node == null) continue;
                    return node;
                }
            }
        }
        return selectedNode;
    }

    protected static Node findCamelNodeForPath(Node node, String path) {
        NodeList childNodes = node.getChildNodes();
        if (childNodes != null) {
            HashMap<String, Integer> nodeCounts = new HashMap<String, Integer>();
            int size = childNodes.getLength();
            for (int i = 0; i < size; ++i) {
                String actual;
                Node child = childNodes.item(i);
                if (!(child instanceof Element) || !Objects.equal((Object)(actual = CamelXmlHelper.getIdOrIndex(child, nodeCounts)), (Object)path)) continue;
                return child;
            }
        }
        return null;
    }

    private static String getIdOrIndex(Node node, Map<String, Integer> nodeCounts) {
        String answer = null;
        if (node instanceof Element) {
            Element element = (Element)node;
            String elementName = element.getTagName();
            Integer countObject = nodeCounts.get(elementName);
            int count = countObject != null ? countObject : 0;
            nodeCounts.put(elementName, ++count);
            answer = element.getAttribute("id");
            if (Strings.isNullOrBlank((String)answer)) {
                answer = "_" + elementName + count;
            }
        }
        return answer;
    }

    public static String dumpModelAsXml(Object definition, ClassLoader classLoader) throws JAXBException, XMLStreamException {
        JAXBContext jaxbContext = JAXBContext.newInstance((String)JAXB_CONTEXT_PACKAGES, (ClassLoader)classLoader);
        StringWriter buffer = new StringWriter();
        XMLStreamWriter delegate = XMLOutputFactory.newInstance().createXMLStreamWriter(buffer);
        JaxbNoNamespaceWriter writer = new JaxbNoNamespaceWriter(delegate);
        writer.setSkipAttributes("customId");
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.schemaLocation", (Object)"");
        marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.marshal(definition, (XMLStreamWriter)writer);
        String answer = buffer.toString();
        if (writer.getElements() == 1) {
            String token = "></" + writer.getRootElementName() + ">";
            answer = answer.replaceFirst(token, "/>");
        }
        return answer;
    }

    public static Object xmlAsModel(Node node, ClassLoader classLoader) throws JAXBException {
        JAXBContext jaxbContext = JAXBContext.newInstance((String)JAXB_CONTEXT_PACKAGES, (ClassLoader)classLoader);
        Unmarshaller marshaller = jaxbContext.createUnmarshaller();
        Object answer = marshaller.unmarshal(node);
        return answer;
    }
}

