/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project.completer;

import io.fabric8.forge.addon.utils.CamelProjectHelper;
import io.fabric8.forge.camel.commands.project.dto.ComponentDto;
import io.fabric8.forge.camel.commands.project.helper.CamelCatalogHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.catalog.JSonSchemaHelper;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.UICompleter;
import org.jboss.forge.addon.ui.input.UIInput;

public class CamelComponentsCompleter
implements UICompleter<ComponentDto> {
    private final Project project;
    private final CamelCatalog camelCatalog;
    private final UIInput<String> filter;
    private final boolean excludeComponentsOnClasspath;
    private final boolean includeCatalogComponents;
    private final Dependency core;

    public CamelComponentsCompleter(Project project, CamelCatalog camelCatalog, UIInput<String> filter, boolean excludeComponentsOnClasspath, boolean includeCatalogComponents) {
        this.project = project;
        this.camelCatalog = camelCatalog;
        this.filter = filter;
        this.excludeComponentsOnClasspath = excludeComponentsOnClasspath;
        this.includeCatalogComponents = includeCatalogComponents;
        this.core = CamelProjectHelper.findCamelCoreDependency((Project)project);
    }

    public Iterable<ComponentDto> getCompletionProposals(UIContext context, InputComponent input, String value) {
        if (this.core == null) {
            return null;
        }
        List<String> names = this.getComponentNames();
        List<String> filtered = new ArrayList<String>();
        for (String name : names) {
            if (value != null && !name.startsWith(value)) continue;
            filtered.add(name);
        }
        filtered = this.filterByName(filtered);
        filtered = this.filterByLabel(filtered, (String)this.filter.getValue());
        ArrayList<ComponentDto> answer = new ArrayList<ComponentDto>();
        for (String filter : filtered) {
            ComponentDto dto = CamelCatalogHelper.createComponentDto(this.camelCatalog, filter);
            answer.add(dto);
        }
        return answer;
    }

    public Iterable<ComponentDto> getValueChoices(String label) {
        Dependency core = CamelProjectHelper.findCamelCoreDependency((Project)this.project);
        if (core == null) {
            return null;
        }
        List<String> names = this.getComponentNames();
        if (label != null && !"<all>".equals(label)) {
            names = this.filterByLabel(names, label);
        }
        ArrayList<ComponentDto> answer = new ArrayList<ComponentDto>();
        for (String filter : names) {
            ComponentDto dto = CamelCatalogHelper.createComponentDto(this.camelCatalog, filter);
            answer.add(dto);
        }
        return answer;
    }

    protected List<String> getComponentNames() {
        ArrayList names;
        if (this.includeCatalogComponents) {
            names = this.camelCatalog.findComponentNames();
            if (this.excludeComponentsOnClasspath) {
                Set artifacts = CamelProjectHelper.findCamelArtifacts((Project)this.project);
                for (Dependency dep : artifacts) {
                    Set<String> components = CamelCatalogHelper.componentsFromArtifact(this.camelCatalog, dep.getCoordinate().getArtifactId());
                    names.removeAll(components);
                }
            }
        } else {
            TreeSet<String> set = new TreeSet<String>();
            Set artifacts = CamelProjectHelper.findCamelArtifacts((Project)this.project);
            for (Dependency dep : artifacts) {
                Set<String> components = CamelCatalogHelper.componentsFromArtifact(this.camelCatalog, dep.getCoordinate().getArtifactId());
                set.addAll(components);
            }
            names = new ArrayList(set);
        }
        return names;
    }

    private List<String> filterByName(List<String> choices) {
        ArrayList<String> answer = new ArrayList<String>();
        for (String name : choices) {
            String json;
            String artifactId;
            boolean already = false;
            if (this.excludeComponentsOnClasspath && (artifactId = CamelComponentsCompleter.findArtifactId(json = this.camelCatalog.componentJSonSchema(name))) != null) {
                already = CamelProjectHelper.hasDependency((Project)this.project, (String)"org.apache.camel", (String)artifactId);
            }
            if (already) continue;
            answer.add(name);
        }
        return answer;
    }

    private List<String> filterByLabel(List<String> choices, String label) {
        if (label == null || label.isEmpty()) {
            return choices;
        }
        ArrayList<String> answer = new ArrayList<String>();
        block0: for (String name : choices) {
            String json = this.camelCatalog.componentJSonSchema(name);
            String labels = CamelComponentsCompleter.findLabel(json);
            if (labels != null) {
                for (String target : labels.split(",")) {
                    if (!target.startsWith(label)) continue;
                    answer.add(name);
                    continue block0;
                }
                continue;
            }
            answer.addAll(choices);
        }
        return answer;
    }

    private static String findArtifactId(String json) {
        List data = JSonSchemaHelper.parseJsonSchema((String)"component", (String)json, (boolean)false);
        for (Map row : data) {
            if (row.get("artifactId") == null) continue;
            return (String)row.get("artifactId");
        }
        return null;
    }

    private static String findLabel(String json) {
        List data = JSonSchemaHelper.parseJsonSchema((String)"component", (String)json, (boolean)false);
        for (Map row : data) {
            if (row.get("label") == null) continue;
            return (String)row.get("label");
        }
        return null;
    }
}

