/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project;

import io.fabric8.forge.addon.utils.XmlLineNumberParser;
import io.fabric8.forge.camel.commands.project.ConfigureEndpointPropertiesStep;
import io.fabric8.utils.DomHelper;
import io.fabric8.utils.Strings;
import java.io.InputStream;
import java.util.List;
import org.apache.camel.catalog.CamelCatalog;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.projects.dependencies.DependencyInstaller;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AddRouteFromEndpointXmlStep
extends ConfigureEndpointPropertiesStep {
    private final String routeId;
    private final String routeDescription;

    public AddRouteFromEndpointXmlStep(ProjectFactory projectFactory, DependencyInstaller dependencyInstaller, CamelCatalog camelCatalog, String componentName, String group, List<InputComponent> allInputs, List<InputComponent> inputs, boolean last, int index, int total, String routeId, String routeDescription) {
        super(projectFactory, dependencyInstaller, camelCatalog, componentName, group, allInputs, inputs, last, index, total);
        this.routeId = routeId;
        this.routeDescription = routeDescription;
    }

    @Override
    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(ConfigureEndpointPropertiesStep.class).name("Camel: Add Route").category(Categories.create((String[])new String[]{CATEGORY})).description(String.format("Configure %s options (%s of %s)", this.getGroup(), this.getIndex(), this.getTotal()));
    }

    @Override
    protected Result addOrEditEndpointXml(FileResource file, String uri, String endpointUrl, String endpointInstanceName, String xml, String lineNumber) throws Exception {
        Document root = XmlLineNumberParser.parseXml((InputStream)file.getResourceInputStream());
        if (root != null) {
            NodeList camels = root.getElementsByTagName("camelContext");
            if (camels != null && camels.getLength() == 1) {
                Node camel = camels.item(0);
                Node camelContext = null;
                for (int i = 0; i < camel.getChildNodes().getLength(); ++i) {
                    Node child;
                    if ("camelContext".equals(camel.getNodeName())) {
                        camelContext = camel;
                    }
                    if (!"camelContext".equals((child = camel.getChildNodes().item(i)).getNodeName())) continue;
                    camelContext = child;
                }
                if (camelContext == null) {
                    return Results.fail((String)("Cannot find <camelContext> in XML file " + xml));
                }
                String indent0 = "\n  ";
                String indent1 = "\n    ";
                String indent2 = "\n      ";
                ConfigureEndpointPropertiesStep.appendText(camelContext, indent1);
                Element route = DomHelper.addChildElement((Node)camelContext, (String)"route", (String)indent2);
                if (Strings.isNotBlank((String)this.routeId)) {
                    route.setAttribute("id", this.routeId);
                }
                if (Strings.isNotBlank((String)this.routeDescription)) {
                    DomHelper.addChildElement((Node)route, (String)"description", (String)this.routeDescription);
                    ConfigureEndpointPropertiesStep.appendText(route, indent2);
                }
                Element from = DomHelper.addChildElement((Node)route, (String)"from");
                from.setAttribute("uri", uri);
                ConfigureEndpointPropertiesStep.appendText(route, indent1);
                ConfigureEndpointPropertiesStep.appendText(camelContext, indent0);
                String content = DomHelper.toXml((Document)root);
                file.setContents(content);
            }
            return Results.success((String)"Added route");
        }
        return Results.fail((String)"Could not load camel XML");
    }
}

