/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project;

import io.fabric8.forge.addon.utils.XmlLineNumberParser;
import io.fabric8.forge.camel.commands.project.ConfigureEndpointPropertiesStep;
import io.fabric8.forge.camel.commands.project.dto.NodeDto;
import io.fabric8.forge.camel.commands.project.helper.CamelXmlHelper;
import io.fabric8.utils.DomHelper;
import io.fabric8.utils.Strings;
import java.io.InputStream;
import java.util.List;
import org.apache.camel.catalog.CamelCatalog;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.projects.dependencies.DependencyInstaller;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AddFromOrToEndpointXmlStep
extends ConfigureEndpointPropertiesStep {
    private final String id;
    private final String description;
    private final NodeDto parentNode;
    private final boolean isFrom;

    public AddFromOrToEndpointXmlStep(ProjectFactory projectFactory, DependencyInstaller dependencyInstaller, CamelCatalog camelCatalog, String componentName, String group, List<InputComponent> allInputs, List<InputComponent> inputs, boolean last, int index, int total, String id, String description, NodeDto parentNode, boolean isFrom) {
        super(projectFactory, dependencyInstaller, camelCatalog, componentName, group, allInputs, inputs, last, index, total);
        this.id = id;
        this.description = description;
        this.parentNode = parentNode;
        this.isFrom = isFrom;
    }

    @Override
    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(ConfigureEndpointPropertiesStep.class).name("Camel: Add Endpoint").category(Categories.create((String[])new String[]{CATEGORY})).description(String.format("Configure %s options (%s of %s)", this.getGroup(), this.getIndex(), this.getTotal()));
    }

    @Override
    protected Result addOrEditEndpointXml(FileResource file, String uri, String endpointUrl, String endpointInstanceName, String xml, String lineNumber) throws Exception {
        String key = this.parentNode.getKey();
        if (Strings.isNullOrBlank((String)key)) {
            return Results.fail((String)("Parent node has no key! " + this.parentNode + " in file " + file.getName()));
        }
        Document root = XmlLineNumberParser.parseXml((InputStream)file.getResourceInputStream());
        if (root != null) {
            Node selectedNode = CamelXmlHelper.findCamelNodeInDocument(root, key);
            if (selectedNode != null) {
                String[] paths;
                String indent0 = "\n";
                for (String path : paths = key.split("/")) {
                    indent0 = indent0 + "  ";
                }
                String indent1 = indent0 + "  ";
                String indent2 = indent1 + "  ";
                AddFromOrToEndpointXmlStep.appendText(selectedNode, indent1);
                Element endpointElement = DomHelper.addChildElement((Node)selectedNode, (String)(this.isFrom ? "from" : "to"), (String)(Strings.isNotBlank((String)this.description) ? indent2 : ""));
                if (Strings.isNotBlank((String)this.id)) {
                    endpointElement.setAttribute("id", this.id);
                }
                endpointElement.setAttribute("uri", uri);
                if (Strings.isNotBlank((String)this.description)) {
                    DomHelper.addChildElement((Node)endpointElement, (String)"description", (String)this.description);
                    AddFromOrToEndpointXmlStep.appendText(endpointElement, indent1);
                }
                AddFromOrToEndpointXmlStep.appendText(selectedNode, indent0);
                String content = DomHelper.toXml((Document)root);
                file.setContents(content);
                return Results.success((String)"Node deleted");
            }
            return Results.fail((String)("Cannot find Camel node in XML file " + key));
        }
        return Results.fail((String)("Could not load camel XML " + file.getName()));
    }
}

