/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project.completer;

import io.fabric8.forge.camel.commands.project.completer.RouteBuilderCamelEndpointsVisitor;
import io.fabric8.forge.camel.commands.project.model.CamelEndpointDetails;
import java.util.ArrayList;
import java.util.List;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.parser.java.resources.JavaResourceVisitor;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.UICompleter;

public class RouteBuilderEndpointsCompleter
implements UICompleter<String> {
    private final List<CamelEndpointDetails> endpoints = new ArrayList<CamelEndpointDetails>();

    public RouteBuilderEndpointsCompleter(JavaSourceFacet facet) {
        if (facet != null) {
            RouteBuilderCamelEndpointsVisitor visitor = new RouteBuilderCamelEndpointsVisitor(facet, this.endpoints);
            facet.visitJavaSources((JavaResourceVisitor)visitor);
        }
    }

    public List<CamelEndpointDetails> getEndpoints() {
        return this.endpoints;
    }

    public List<String> getEndpointUris() {
        ArrayList<String> uris = new ArrayList<String>();
        for (CamelEndpointDetails detail : this.endpoints) {
            uris.add(detail.getEndpointUri());
        }
        return uris;
    }

    public CamelEndpointDetails getEndpointDetail(String uri) {
        for (CamelEndpointDetails detail : this.endpoints) {
            String endpointUri = detail.getEndpointUri();
            if (endpointUri == null || !endpointUri.equals(uri)) continue;
            return detail;
        }
        return null;
    }

    public CamelEndpointDetails getEndpointDetailByInstanceName(String instanceName) {
        for (CamelEndpointDetails detail : this.endpoints) {
            String endpointInstance = detail.getEndpointInstance();
            if (endpointInstance == null || !endpointInstance.equals(instanceName)) continue;
            return detail;
        }
        return null;
    }

    public Iterable<String> getCompletionProposals(UIContext context, InputComponent input, String value) {
        ArrayList<String> answer = new ArrayList<String>();
        for (CamelEndpointDetails detail : this.endpoints) {
            if (value != null && !detail.getEndpointUri().startsWith(value)) continue;
            answer.add(detail.getEndpointUri());
        }
        return answer;
    }

    public String createDefaultNewInstanceName() {
        for (int count = this.endpoints.size() + 1; count > 0 && count < Integer.MAX_VALUE; ++count) {
            String name = "endpoint" + count;
            if (this.getEndpointDetailByInstanceName(name) != null) continue;
            return name;
        }
        return null;
    }
}

