/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project.helper;

import io.fabric8.forge.camel.commands.project.helper.AnonymousMethodSource;
import io.fabric8.forge.camel.commands.project.helper.ParserResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Block;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.BooleanLiteral;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Expression;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.ExpressionStatement;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.InfixExpression;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.MemberValuePair;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.MethodDeclaration;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.MethodInvocation;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.NormalAnnotation;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.NumberLiteral;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.ReturnStatement;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.SimpleName;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.SimpleType;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Statement;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.StringLiteral;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.VariableDeclaration;
import org.jboss.forge.roaster.model.source.AnnotationSource;
import org.jboss.forge.roaster.model.source.FieldSource;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.MethodSource;

public class CamelJavaParserHelper {
    public static MethodSource<JavaClassSource> findConfigureMethod(JavaClassSource clazz) {
        MethodDeclaration md;
        Block block;
        MethodSource method = clazz.getMethod("configure");
        if (method != null && method.isPublic() && method.getParameters().isEmpty() && method.getReturnType().isType("void")) {
            return method;
        }
        method = clazz.getMethod("createRouteBuilder");
        if (method != null && (method.isPublic() || method.isProtected()) && method.getParameters().isEmpty() && (block = (md = (MethodDeclaration)method.getInternal()).getBody()) != null) {
            List statements = block.statements();
            for (int i = 0; i < statements.size(); ++i) {
                ReturnStatement rs;
                Expression exp;
                Statement stmt = (Statement)statements.get(i);
                if (!(stmt instanceof ReturnStatement) || (exp = (rs = (ReturnStatement)stmt).getExpression()) == null || !(exp instanceof ClassInstanceCreation)) continue;
                ClassInstanceCreation cic = (ClassInstanceCreation)exp;
                boolean isRouteBuilder = false;
                if (cic.getType() instanceof SimpleType) {
                    SimpleType st = (SimpleType)cic.getType();
                    isRouteBuilder = "RouteBuilder".equals(st.getName().toString());
                }
                if (!isRouteBuilder || cic.getAnonymousClassDeclaration() == null) continue;
                List body = cic.getAnonymousClassDeclaration().bodyDeclarations();
                for (int j = 0; j < body.size(); ++j) {
                    MethodDeclaration amd;
                    Object line = body.get(j);
                    if (!(line instanceof MethodDeclaration) || !"configure".equals((amd = (MethodDeclaration)line).getName().toString())) continue;
                    return new AnonymousMethodSource(clazz, amd);
                }
            }
        }
        return null;
    }

    public static List<ParserResult> parseCamelConsumerUris(MethodSource<JavaClassSource> method, boolean strings, boolean fields) {
        return CamelJavaParserHelper.doParseCamelUris(method, true, false, strings, fields);
    }

    public static List<ParserResult> parseCamelProducerUris(MethodSource<JavaClassSource> method, boolean strings, boolean fields) {
        return CamelJavaParserHelper.doParseCamelUris(method, false, true, strings, fields);
    }

    private static List<ParserResult> doParseCamelUris(MethodSource<JavaClassSource> method, boolean consumers, boolean producers, boolean strings, boolean fields) {
        ArrayList<ParserResult> answer = new ArrayList<ParserResult>();
        MethodDeclaration md = (MethodDeclaration)method.getInternal();
        if (md.getBody() != null) {
            for (Object statement : md.getBody().statements()) {
                if (!(statement instanceof ExpressionStatement)) continue;
                ExpressionStatement es = (ExpressionStatement)statement;
                Expression exp = es.getExpression();
                ArrayList<ParserResult> uris = new ArrayList<ParserResult>();
                CamelJavaParserHelper.parseExpression((JavaClassSource)method.getOrigin(), exp, uris, consumers, producers, strings, fields);
                if (uris.isEmpty()) continue;
                Collections.reverse(uris);
                answer.addAll(uris);
            }
        }
        return answer;
    }

    private static void parseExpression(JavaClassSource clazz, Expression exp, List<ParserResult> uris, boolean consumers, boolean producers, boolean strings, boolean fields) {
        if (exp == null) {
            return;
        }
        if (exp instanceof MethodInvocation) {
            MethodInvocation mi = (MethodInvocation)exp;
            CamelJavaParserHelper.doParseCamelUris(clazz, mi, uris, consumers, producers, strings, fields);
            exp = mi.getExpression();
            CamelJavaParserHelper.parseExpression(clazz, exp, uris, consumers, producers, strings, fields);
        }
    }

    private static void doParseCamelUris(JavaClassSource clazz, MethodInvocation mi, List<ParserResult> uris, boolean consumers, boolean producers, boolean strings, boolean fields) {
        Iterator arg;
        List args;
        String name = mi.getName().getIdentifier();
        if (consumers) {
            if ("from".equals(name) && (args = mi.arguments()) != null) {
                for (Object arg2 : args) {
                    CamelJavaParserHelper.extractEndpointUriFromArgument(clazz, uris, arg2, strings, fields);
                }
            }
            if ("pollEnrich".equals(name) && (args = mi.arguments()) != null && args.size() >= 1) {
                arg = args.get(0);
                CamelJavaParserHelper.extractEndpointUriFromArgument(clazz, uris, arg, strings, fields);
            }
        }
        if (producers) {
            if (("to".equals(name) || "toD".equals(name)) && (args = mi.arguments()) != null) {
                for (Object arg2 : args) {
                    CamelJavaParserHelper.extractEndpointUriFromArgument(clazz, uris, arg2, strings, fields);
                }
            }
            if (("enrich".equals(name) || "wireTap".equals(name)) && (args = mi.arguments()) != null && args.size() >= 1) {
                arg = args.get(0);
                CamelJavaParserHelper.extractEndpointUriFromArgument(clazz, uris, arg, strings, fields);
            }
        }
    }

    private static void extractEndpointUriFromArgument(JavaClassSource clazz, List<ParserResult> uris, Object arg, boolean strings, boolean fields) {
        FieldSource field;
        String uri;
        if (strings && (uri = CamelJavaParserHelper.getLiteralValue(clazz, (Expression)arg, true)) != null) {
            int position = ((Expression)arg).getStartPosition();
            uris.add(new ParserResult(position, uri));
        }
        if (fields && arg instanceof SimpleName && (field = CamelJavaParserHelper.getField(clazz, (SimpleName)arg)) != null) {
            AnnotationSource annotation = field.getAnnotation("org.apache.camel.cdi.Uri");
            if (annotation == null) {
                annotation = field.getAnnotation("org.apache.camel.EndpointInject");
            }
            if (annotation != null) {
                Expression exp = (Expression)annotation.getInternal();
                if (exp instanceof SingleMemberAnnotation) {
                    exp = ((SingleMemberAnnotation)exp).getValue();
                } else if (exp instanceof NormalAnnotation) {
                    List values = ((NormalAnnotation)exp).values();
                    for (Object value : values) {
                        MemberValuePair pair = (MemberValuePair)value;
                        if (!"uri".equals(pair.getName().toString())) continue;
                        exp = pair.getValue();
                        break;
                    }
                }
                String uri2 = CamelJavaParserHelper.getLiteralValue(clazz, exp, false);
                if (uri2 != null) {
                    int position = ((SimpleName)arg).getStartPosition();
                    uris.add(new ParserResult(position, uri2));
                }
            } else {
                Expression exp;
                String uri3;
                Object fi = field.getInternal();
                if (fi instanceof VariableDeclaration && (uri3 = CamelJavaParserHelper.getLiteralValue(clazz, exp = ((VariableDeclaration)fi).getInitializer(), false)) != null) {
                    int position = ((VariableDeclaration)fi).getStartPosition();
                    uris.add(new ParserResult(position, uri3));
                }
            }
        }
    }

    public static List<ParserResult> parseCamelSimpleExpressions(MethodSource<JavaClassSource> method) {
        ArrayList<ParserResult> answer = new ArrayList<ParserResult>();
        MethodDeclaration md = (MethodDeclaration)method.getInternal();
        if (md.getBody() != null) {
            for (Object statement : md.getBody().statements()) {
                if (!(statement instanceof ExpressionStatement)) continue;
                ExpressionStatement es = (ExpressionStatement)statement;
                Expression exp = es.getExpression();
                ArrayList<ParserResult> expressions = new ArrayList<ParserResult>();
                CamelJavaParserHelper.parseExpression((JavaClassSource)method.getOrigin(), exp, expressions);
                if (expressions.isEmpty()) continue;
                Collections.reverse(expressions);
                answer.addAll(expressions);
            }
        }
        return answer;
    }

    private static void parseExpression(JavaClassSource clazz, Expression exp, List<ParserResult> expressions) {
        if (exp == null) {
            return;
        }
        if (exp instanceof MethodInvocation) {
            MethodInvocation mi = (MethodInvocation)exp;
            CamelJavaParserHelper.doParseCamelSimple(clazz, mi, expressions);
            exp = mi.getExpression();
            CamelJavaParserHelper.parseExpression(clazz, exp, expressions);
        }
    }

    private static void doParseCamelSimple(JavaClassSource clazz, MethodInvocation mi, List<ParserResult> expressions) {
        Object arg;
        String simple;
        List args;
        String name = mi.getName().getIdentifier();
        if ("simple".equals(name) && (args = mi.arguments()) != null && args.size() >= 1 && (simple = CamelJavaParserHelper.getLiteralValue(clazz, (Expression)(arg = args.get(0)), false)) != null && !simple.isEmpty()) {
            int position = ((Expression)arg).getStartPosition();
            expressions.add(new ParserResult(position, simple));
        }
        if ((args = mi.arguments()) != null) {
            for (Object arg2 : args) {
                if (!(arg2 instanceof MethodInvocation)) continue;
                MethodInvocation ami = (MethodInvocation)arg2;
                CamelJavaParserHelper.doParseCamelSimple(clazz, ami, expressions);
            }
        }
    }

    private static FieldSource getField(JavaClassSource clazz, SimpleName ref) {
        String fieldName = ref.getIdentifier();
        if (fieldName != null) {
            FieldSource field = clazz != null ? clazz.getField(fieldName) : null;
            return field;
        }
        return null;
    }

    public static String getLiteralValue(JavaClassSource clazz, Expression expression, boolean literalOnly) {
        if (expression instanceof ParenthesizedExpression) {
            expression = ((ParenthesizedExpression)expression).getExpression();
        }
        if (expression instanceof StringLiteral) {
            return ((StringLiteral)expression).getLiteralValue();
        }
        if (expression instanceof BooleanLiteral) {
            return "" + ((BooleanLiteral)expression).booleanValue();
        }
        if (expression instanceof NumberLiteral) {
            return ((NumberLiteral)expression).getToken();
        }
        if (literalOnly) {
            return null;
        }
        if (expression instanceof SimpleName) {
            Object fi;
            FieldSource field = CamelJavaParserHelper.getField(clazz, (SimpleName)expression);
            if (field != null && (fi = field.getInternal()) instanceof VariableDeclaration) {
                Expression exp = ((VariableDeclaration)fi).getInitializer();
                return CamelJavaParserHelper.getLiteralValue(clazz, exp, literalOnly);
            }
        } else if (expression instanceof InfixExpression) {
            String answer = null;
            InfixExpression ie = (InfixExpression)expression;
            if (InfixExpression.Operator.PLUS.equals(ie.getOperator())) {
                List extended;
                boolean numeric;
                String val1 = CamelJavaParserHelper.getLiteralValue(clazz, ie.getLeftOperand(), literalOnly);
                String val2 = CamelJavaParserHelper.getLiteralValue(clazz, ie.getRightOperand(), literalOnly);
                boolean bl = numeric = CamelJavaParserHelper.isNumericOperator(clazz, ie.getLeftOperand()) && CamelJavaParserHelper.isNumericOperator(clazz, ie.getRightOperand());
                if (numeric) {
                    Long num1 = val1 != null ? Long.valueOf(val1) : 0L;
                    Long num2 = val2 != null ? Long.valueOf(val2) : 0L;
                    answer = "" + (num1 + num2);
                } else {
                    answer = (val1 != null ? val1 : "") + (val2 != null ? val2 : "");
                }
                if (!answer.isEmpty() && (extended = ie.extendedOperands()) != null) {
                    for (Object ext : extended) {
                        String val3 = CamelJavaParserHelper.getLiteralValue(clazz, (Expression)ext, literalOnly);
                        if (numeric) {
                            Long num3 = val3 != null ? Long.valueOf(val3) : 0L;
                            Long num = Long.valueOf(answer);
                            answer = "" + (num + num3);
                            continue;
                        }
                        answer = answer + (val3 != null ? val3 : "");
                    }
                }
            }
            return answer;
        }
        return null;
    }

    private static boolean isNumericOperator(JavaClassSource clazz, Expression expression) {
        FieldSource field;
        if (expression instanceof NumberLiteral) {
            return true;
        }
        if (expression instanceof SimpleName && (field = CamelJavaParserHelper.getField(clazz, (SimpleName)expression)) != null) {
            return field.getType().isType("int") || field.getType().isType("long") || field.getType().isType("Integer") || field.getType().isType("Long");
        }
        return false;
    }
}

