/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project.helper;

import io.fabric8.forge.addon.utils.XmlLineNumberParser;
import io.fabric8.forge.camel.commands.project.helper.CamelCatalogHelper;
import io.fabric8.forge.camel.commands.project.helper.CamelXmlHelper;
import io.fabric8.forge.camel.commands.project.model.CamelEndpointDetails;
import io.fabric8.forge.camel.commands.project.model.CamelSimpleDetails;
import java.io.InputStream;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XmlRouteParser {
    public static void parseXmlRouteEndpoints(InputStream xml, String baseDir, String fullyQualifiedFileName, List<CamelEndpointDetails> endpoints) throws Exception {
        Document dom = XmlLineNumberParser.parseXml((InputStream)xml);
        if (dom != null) {
            List<Node> nodes = CamelXmlHelper.findAllEndpoints(dom);
            for (Node node : nodes) {
                String uri = CamelXmlHelper.getSafeAttribute(node, "uri");
                uri = CamelXmlHelper.trimEndpointUri(uri);
                String id = CamelXmlHelper.getSafeAttribute(node, "id");
                String lineNumber = (String)node.getUserData("lineNumber");
                String fileName = fullyQualifiedFileName;
                if (fileName.startsWith(baseDir)) {
                    fileName = fileName.substring(baseDir.length() + 1);
                }
                boolean consumerOnly = false;
                boolean producerOnly = false;
                String nodeName = node.getNodeName();
                if ("from".equals(nodeName) || "pollEnrich".equals(nodeName)) {
                    consumerOnly = true;
                } else if ("to".equals(nodeName) || "enrich".equals(nodeName) || "wireTap".equals(nodeName)) {
                    producerOnly = true;
                }
                CamelEndpointDetails detail = new CamelEndpointDetails();
                detail.setFileName(fileName);
                detail.setLineNumber(lineNumber);
                detail.setEndpointInstance(id);
                detail.setEndpointUri(uri);
                detail.setEndpointComponentName(CamelCatalogHelper.endpointComponentName(uri));
                detail.setConsumerOnly(consumerOnly);
                detail.setProducerOnly(producerOnly);
                endpoints.add(detail);
            }
        }
    }

    public static void parseXmlRouteSimpleExpressions(InputStream xml, String baseDir, String fullyQualifiedFileName, List<CamelSimpleDetails> simpleExpressions) throws Exception {
        Document dom = XmlLineNumberParser.parseXml((InputStream)xml);
        if (dom != null) {
            List<Node> nodes = CamelXmlHelper.findAllSimpleExpressions(dom);
            for (Node node : nodes) {
                String simple = node.getTextContent();
                String lineNumber = (String)node.getUserData("lineNumber");
                String fileName = fullyQualifiedFileName;
                if (fileName.startsWith(baseDir)) {
                    fileName = fileName.substring(baseDir.length() + 1);
                }
                CamelSimpleDetails detail = new CamelSimpleDetails();
                detail.setFileName(fileName);
                detail.setLineNumber(lineNumber);
                detail.setSimple(simple);
                simpleExpressions.add(detail);
            }
        }
    }
}

