/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project;

import io.fabric8.forge.camel.commands.project.AbstractCamelProjectCommand;
import io.fabric8.forge.camel.commands.project.completer.RouteBuilderEndpointsCompleter;
import io.fabric8.forge.camel.commands.project.completer.XmlEndpointsCompleter;
import io.fabric8.forge.camel.commands.project.dto.OutputFormat;
import io.fabric8.forge.camel.commands.project.model.CamelEndpointDetails;
import java.util.List;
import javax.inject.Inject;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.facets.ResourcesFacet;
import org.jboss.forge.addon.projects.facets.WebResourcesFacet;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;

public class CamelValidateEndpointCommand
extends AbstractCamelProjectCommand {
    @Inject
    @WithAttributes(label="Format", defaultValue="Text", description="Format output as text or json")
    private UISelectOne<OutputFormat> format;

    @Override
    public boolean isEnabled(UIContext context) {
        Project project = this.getSelectedProjectOrNull(context);
        return project != null;
    }

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(CamelValidateEndpointCommand.class).name("Camel: Validate Endpoint").category(Categories.create((String[])new String[]{CATEGORY})).description("Validate Camel Endpoints in the project");
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        builder.add(this.format);
    }

    public Result execute(UIExecutionContext context) throws Exception {
        String string;
        Project project = this.getSelectedProject((UIContextProvider)context);
        Dependency core = this.findCamelCoreDependency(project);
        if (core == null) {
            return Results.success((String)"Cannot find Apache Camel");
        }
        ResourcesFacet resourcesFacet = (ResourcesFacet)project.getFacet(ResourcesFacet.class);
        WebResourcesFacet webResourcesFacet = null;
        if (project.hasFacet(WebResourcesFacet.class)) {
            webResourcesFacet = (WebResourcesFacet)project.getFacet(WebResourcesFacet.class);
        }
        XmlEndpointsCompleter xmlEndpointCompleter = new XmlEndpointsCompleter(resourcesFacet, webResourcesFacet);
        JavaSourceFacet javaSourceFacet = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
        RouteBuilderEndpointsCompleter javaEndpointsCompleter = new RouteBuilderEndpointsCompleter(javaSourceFacet);
        List<CamelEndpointDetails> javaEndpoints = javaEndpointsCompleter.getEndpoints();
        List<CamelEndpointDetails> xmlEndpoints = xmlEndpointCompleter.getEndpoints();
        StringBuilder sb = new StringBuilder();
        boolean failed = false;
        for (CamelEndpointDetails detail : javaEndpoints) {
            string = detail.getEndpointUri();
        }
        for (CamelEndpointDetails detail : xmlEndpoints) {
            string = detail.getEndpointUri();
        }
        if (failed) {
            return Results.fail((String)("Camel endpoint validation failed:\n" + sb.toString()));
        }
        return Results.success((String)"Camel endpoint validation success");
    }
}

