/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project;

import io.fabric8.forge.camel.commands.project.AbstractCamelProjectCommand;
import io.fabric8.forge.camel.commands.project.completer.CamelLanguagesCompleter;
import io.fabric8.forge.camel.commands.project.dto.LanguageDto;
import io.fabric8.forge.camel.commands.project.helper.CamelCatalogHelper;
import javax.inject.Inject;
import org.jboss.forge.addon.convert.Converter;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.dependencies.builder.DependencyBuilder;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.dependencies.DependencyInstaller;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.input.ValueChangeListener;
import org.jboss.forge.addon.ui.input.events.ValueChangeEvent;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;

public class CamelAddLanguageCommand
extends AbstractCamelProjectCommand {
    @Inject
    @WithAttributes(label="Name", required=true, description="Name of language to add")
    private UISelectOne<LanguageDto> name;
    @Inject
    private DependencyInstaller dependencyInstaller;

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(CamelAddLanguageCommand.class).name("Camel: Add Language").category(Categories.create((String[])new String[]{CATEGORY})).description("Adds a Camel language to your project dependencies");
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        Project project = this.getSelectedProject((UIContextProvider)builder);
        this.name.setValueChoices(new CamelLanguagesCompleter(project, this.getCamelCatalog()).getValueChoices());
        this.name.setValueConverter((Converter)new Converter<String, LanguageDto>(){

            public LanguageDto convert(String text) {
                return CamelCatalogHelper.createLanguageDto(CamelAddLanguageCommand.this.getCamelCatalog(), text);
            }
        });
        this.name.addValueChangeListener(new ValueChangeListener(){

            public void valueChanged(ValueChangeEvent event) {
                LanguageDto language = (LanguageDto)event.getNewValue();
                if (language != null) {
                    String description = language.getDescription();
                    CamelAddLanguageCommand.this.name.setNote(description != null ? description : "");
                } else {
                    CamelAddLanguageCommand.this.name.setNote("");
                }
            }
        });
        builder.add(this.name);
    }

    public Result execute(UIExecutionContext context) throws Exception {
        Project project = this.getSelectedProject((UIContextProvider)context);
        Dependency core = this.findCamelCoreDependency(project);
        if (core == null) {
            return Results.fail((String)"The project does not include camel-core");
        }
        LanguageDto dto = (LanguageDto)this.name.getValue();
        if (dto != null) {
            DependencyBuilder component = DependencyBuilder.create().setGroupId(dto.getGroupId()).setArtifactId(dto.getArtifactId()).setVersion(core.getCoordinate().getVersion());
            this.dependencyInstaller.install(project, (Dependency)component);
            return Results.success((String)("Added Camel language " + dto.getName() + " (" + dto.getArtifactId() + ") to the project"));
        }
        return Results.fail((String)"Unknown Camel language");
    }
}

