/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project.completer;

import io.fabric8.forge.camel.commands.project.helper.CamelCatalogHelper;
import io.fabric8.forge.camel.commands.project.helper.CamelProjectHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.camel.catalog.DefaultCamelCatalog;
import org.apache.camel.catalog.JSonSchemaHelper;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.UICompleter;

public class CamelDataFormatsCompleter
implements UICompleter<String> {
    private Project project;

    public CamelDataFormatsCompleter(Project project) {
        this.project = project;
    }

    public Iterable<String> getCompletionProposals(UIContext context, InputComponent input, String value) {
        ArrayList<String> answer = new ArrayList<String>();
        Dependency core = CamelProjectHelper.findCamelCoreDependency(this.project);
        if (core == null) {
            return null;
        }
        DefaultCamelCatalog catalog = new DefaultCamelCatalog();
        List names = catalog.findDataFormatNames();
        ArrayList<String> filtered = new ArrayList<String>();
        for (String name : names) {
            if (value != null && !name.startsWith(value)) continue;
            filtered.add(name);
        }
        for (String name : filtered) {
            String json = catalog.dataFormatJSonSchema(name);
            String artifactId = CamelDataFormatsCompleter.findArtifactId(json);
            boolean already = false;
            if (artifactId != null) {
                already = CamelProjectHelper.hasDependency(this.project, "org.apache.camel", artifactId);
            }
            if (already) continue;
            answer.add(name);
        }
        return answer;
    }

    public Iterable<String> getValueChoices() {
        Dependency core = CamelProjectHelper.findCamelCoreDependency(this.project);
        if (core == null) {
            return null;
        }
        DefaultCamelCatalog catalog = new DefaultCamelCatalog();
        List names = catalog.findDataFormatNames();
        Set<Dependency> artifacts = CamelProjectHelper.findCamelArtifacts(this.project);
        for (Dependency dep : artifacts) {
            Set<String> languages = CamelCatalogHelper.dataFormatsFromArtifact(dep.getCoordinate().getArtifactId());
            names.removeAll(languages);
        }
        return names;
    }

    private static String findArtifactId(String json) {
        List data = JSonSchemaHelper.parseJsonSchema((String)"dataformat", (String)json, (boolean)false);
        for (Map row : data) {
            if (row.get("artifactId") == null) continue;
            return (String)row.get("artifactId");
        }
        return null;
    }
}

