/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project;

import io.fabric8.forge.addon.utils.validator.ClassNameValidator;
import io.fabric8.forge.camel.commands.project.AbstractDockerProjectCommand;
import io.fabric8.forge.camel.commands.project.FabricStepCommand;
import io.fabric8.forge.camel.commands.project.JubeStepCommand;
import io.fabric8.forge.camel.commands.project.helper.DockerSetupHelper;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.jboss.forge.addon.maven.projects.MavenFacet;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UINavigationContext;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.input.ValueChangeListener;
import org.jboss.forge.addon.ui.input.events.ValueChangeEvent;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.validate.UIValidator;
import org.jboss.forge.addon.ui.wizard.UIWizard;

public class DockerStepCommand
extends AbstractDockerProjectCommand
implements UIWizard {
    private String[] jarImages = new String[]{"fabric8/java"};
    private String[] bundleImages = new String[]{"fabric8/karaf-2.4"};
    private String[] warImages = new String[]{"fabric8/tomcat-8.0", "jboss/wildfly"};
    @Inject
    @WithAttributes(label="from", required=true, description="The docker image to use as base line")
    private UISelectOne<String> from;
    @Inject
    @WithAttributes(label="main", required=false, description="Main class to use for Java standalone")
    private UIInput<String> main;

    public boolean isEnabled(UIContext context) {
        return false;
    }

    public NavigationResult next(UINavigationContext context) throws Exception {
        String platform = (String)context.getUIContext().getAttributeMap().get("platform");
        if ("Docker-and-Jube".equals(platform)) {
            return Results.navigateTo(JubeStepCommand.class);
        }
        return Results.navigateTo(FabricStepCommand.class);
    }

    @Override
    protected boolean isProjectRequired() {
        return super.isProjectRequired();
    }

    public void initializeUI(final UIBuilder builder) throws Exception {
        String packaging = DockerStepCommand.getProjectPackaging(this.getSelectedProject((UIContextProvider)builder));
        ArrayList<String> choices = new ArrayList<String>();
        if (packaging == null || "jar".equals(packaging)) {
            choices.add(this.jarImages[0]);
        }
        if (packaging == null || "bundle".equals(packaging)) {
            choices.add(this.bundleImages[0]);
        }
        if (packaging == null || "war".equals(packaging)) {
            choices.add(this.warImages[0]);
            choices.add(this.warImages[1]);
        }
        this.from.setValueChoices(choices);
        String defaultChoice = DockerSetupHelper.defaultDockerImage(this.getSelectedProject((UIContextProvider)builder));
        if (defaultChoice != null && choices.contains(defaultChoice)) {
            this.from.setDefaultValue((Object)defaultChoice);
        }
        this.from.addValueChangeListener(new ValueChangeListener(){

            public void valueChanged(ValueChangeEvent event) {
                builder.getUIContext().getAttributeMap().put("docker.from", event.getNewValue());
            }
        });
        this.main.setRequired((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                for (String jar : DockerStepCommand.this.jarImages) {
                    if (!jar.equals(DockerStepCommand.this.from.getValue())) continue;
                    return true;
                }
                return false;
            }
        });
        this.main.setEnabled(this.main.isRequired());
        this.main.setDefaultValue((Object)DockerSetupHelper.defaultMainClass(this.getSelectedProject((UIContextProvider)builder)));
        this.main.addValidator((UIValidator)new ClassNameValidator(true));
        this.main.addValueChangeListener(new ValueChangeListener(){

            public void valueChanged(ValueChangeEvent event) {
                builder.getUIContext().getAttributeMap().put("docker.main", event.getNewValue());
            }
        });
        builder.add(this.from).add(this.main);
    }

    public Result execute(UIExecutionContext context) throws Exception {
        DockerSetupHelper.setupDocker(this.getSelectedProject((UIContextProvider)context), (String)this.from.getValue(), (String)this.main.getValue());
        return Results.success((String)("Adding Docker using image " + (String)this.from.getValue()));
    }

    private static String getProjectPackaging(Project project) {
        if (project != null) {
            MavenFacet maven = (MavenFacet)project.getFacet(MavenFacet.class);
            return maven.getModel().getPackaging();
        }
        return null;
    }
}

