/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project.validator;

import org.jboss.forge.addon.parser.java.ui.validators.AbstractJLSUIValidator;
import org.jboss.forge.addon.parser.java.utils.ResultType;
import org.jboss.forge.addon.parser.java.utils.ValidationResult;

public class PackageNameValidator
extends AbstractJLSUIValidator {
    protected ValidationResult validate(String s) {
        if (s == null) {
            return new ValidationResult(ResultType.INFO);
        }
        char[] chars = s.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char ch = chars[i];
            if (i > 0 && ch == '.') continue;
            if (!Character.isJavaIdentifierPart(ch)) {
                return new ValidationResult(ResultType.ERROR, "The package name [" + s + "] is invalid at position " + (i + 1));
            }
            if (!Character.isAlphabetic(ch) || Character.isLowerCase(ch)) continue;
            return new ValidationResult(ResultType.ERROR, "The package name [" + s + "] must be lower case alphabetic character");
        }
        return new ValidationResult(ResultType.INFO);
    }
}

