/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project;

import java.net.URLClassLoader;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.facets.ClassLoaderFacet;

public final class JavaHelper {
    public static String removeJavaPackageName(String className) {
        int idx = className.lastIndexOf(46);
        if (idx >= 0) {
            return className.substring(idx + 1);
        }
        return className;
    }

    public static URLClassLoader getProjectClassLoader(Project project) {
        ClassLoaderFacet classLoaderFacet;
        if (project != null && (classLoaderFacet = (ClassLoaderFacet)project.getFacet(ClassLoaderFacet.class)) != null) {
            return classLoaderFacet.getClassLoader();
        }
        return null;
    }

    public static boolean projectHasClassOnClassPath(Project project, String className) {
        URLClassLoader classLoader = JavaHelper.getProjectClassLoader(project);
        if (classLoader != null) {
            try {
                Class<?> clazz = classLoader.loadClass(className);
                return true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return false;
    }

    public static Class<?> loadProjectClass(Project project, String className) {
        URLClassLoader classLoader = JavaHelper.getProjectClassLoader(project);
        if (classLoader != null) {
            try {
                return classLoader.loadClass(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }
}

