/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project;

import io.fabric8.forge.camel.commands.jolokia.ConnectCommand;
import io.fabric8.forge.camel.commands.project.AbstractFabricProjectCommand;
import io.fabric8.forge.camel.commands.project.DockerSetupHelper;
import io.fabric8.forge.camel.commands.project.VersionHelper;
import java.util.Arrays;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.apache.maven.model.Model;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.dependencies.builder.DependencyBuilder;
import org.jboss.forge.addon.facets.constraints.FacetConstraint;
import org.jboss.forge.addon.maven.plugins.Execution;
import org.jboss.forge.addon.maven.plugins.ExecutionBuilder;
import org.jboss.forge.addon.maven.plugins.MavenPlugin;
import org.jboss.forge.addon.maven.plugins.MavenPluginBuilder;
import org.jboss.forge.addon.maven.projects.MavenFacet;
import org.jboss.forge.addon.maven.projects.MavenPluginFacet;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.dependencies.DependencyInstaller;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;

@FacetConstraint(value={MavenFacet.class, MavenPluginFacet.class})
public class FabricSetupCommand
extends AbstractFabricProjectCommand {
    private String[] platforms = new String[]{"Docker", "Jube", "Both"};
    @Inject
    @WithAttributes(label="platform", required=true, description="The runtime platform")
    private UISelectOne<String> platform;
    @Inject
    @WithAttributes(label="label", required=false, description="Label to use for the app")
    private UIInput<String> group;
    @Inject
    private DependencyInstaller dependencyInstaller;

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(ConnectCommand.class).name("Fabric: Setup").category(Categories.create((String[])new String[]{CATEGORY})).description("Setup Fabric8 in your project");
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        builder.add(this.platform);
        this.platform.setValueChoices(Arrays.asList(this.platforms));
        this.platform.setDefaultValue((Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                if (FabricSetupCommand.isPlatform("windows")) {
                    return "Jube";
                }
                return "Docker";
            }
        });
        builder.add(this.group);
    }

    public Result execute(UIExecutionContext context) throws Exception {
        Project project = this.getSelectedProject((UIContextProvider)context);
        boolean docker = false;
        boolean jube = false;
        if ("Docker".equals(this.platform.getValue()) || "Both".equals(this.platform.getValue())) {
            String fromImage = DockerSetupHelper.defaultDockerImage(project);
            if (fromImage == null) {
                fromImage = "fabric8/java";
            }
            docker = true;
            DockerSetupHelper.setupDocker(project, fromImage);
        }
        DependencyBuilder bom = DependencyBuilder.create().setCoordinate(this.createCoordinate("io.fabric8", "fabric8-project", VersionHelper.fabric8Version(), "pom")).setScopeType("import");
        this.dependencyInstaller.installManaged(project, (Dependency)bom);
        MavenPluginFacet pluginFacet = (MavenPluginFacet)project.getFacet(MavenPluginFacet.class);
        MavenPluginBuilder plugin = MavenPluginBuilder.create().setCoordinate(this.createCoordinate("io.fabric8", "fabric8-maven-plugin", VersionHelper.fabric8Version())).addExecution((Execution)ExecutionBuilder.create().setId("json").addGoal("json"));
        pluginFacet.addPlugin((MavenPlugin)plugin);
        String container = null;
        String icon = null;
        String packaging = this.getProjectPackaging(project);
        if ("jar".equals(packaging)) {
            container = "java";
            icon = "icons/java.svg";
        } else if ("bundle".equals(packaging)) {
            container = "karaf";
            icon = "icons/karaf.svg";
        } else if ("war".equals(packaging)) {
            container = "tomcat";
            icon = "icons/tomcat.svg";
        }
        MavenFacet maven = (MavenFacet)project.getFacet(MavenFacet.class);
        Model pom = maven.getModel();
        Properties properties = pom.getProperties();
        boolean updated = false;
        if (container != null) {
            properties.put("fabric8.label.container", container);
            updated = true;
        }
        if (icon != null) {
            properties.put("fabric8.iconRef", icon);
            updated = true;
        }
        if (this.group.getValue() != null) {
            properties.put("fabric8.label.group", this.group.getValue());
            updated = true;
        }
        if (updated) {
            maven.setModel(pom);
        }
        if (docker && jube) {
            return Results.success((String)"Added Fabric8 wtih Docker and Jube to the project");
        }
        if (docker) {
            return Results.success((String)"Added Fabric8 wtih Docker to the project");
        }
        return Results.success((String)"Added Fabric8 wtih Jube to the project");
    }

    protected String getProjectPackaging(Project project) {
        if (project != null) {
            MavenFacet maven = (MavenFacet)project.getFacet(MavenFacet.class);
            return maven.getModel().getPackaging();
        }
        return null;
    }

    public static boolean isPlatform(String platform) {
        String osName = System.getProperty("os.name").toLowerCase(Locale.US);
        return osName.contains(platform.toLowerCase(Locale.US));
    }
}

