/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project;

import io.fabric8.forge.camel.commands.jolokia.ConnectCommand;
import io.fabric8.forge.camel.commands.project.AbstractCamelProjectCommand;
import io.fabric8.forge.camel.commands.project.VersionHelper;
import javax.inject.Inject;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.dependencies.builder.DependencyBuilder;
import org.jboss.forge.addon.maven.plugins.MavenPlugin;
import org.jboss.forge.addon.maven.plugins.MavenPluginBuilder;
import org.jboss.forge.addon.maven.projects.MavenPluginFacet;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.dependencies.DependencyInstaller;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;

public class CamelSetupCommand
extends AbstractCamelProjectCommand {
    @Inject
    @WithAttributes(label="version", required=false, description="Camel version to use. If none provided then the latest version will be used.")
    private UIInput<String> version;
    @Inject
    private DependencyInstaller dependencyInstaller;

    @Override
    protected boolean requiresCamelSetup() {
        return false;
    }

    @Override
    public boolean isEnabled(UIContext context) {
        Project project = this.getSelectedProjectOrNull(context);
        boolean noCamel = project == null || this.findCamelCoreDependency(project) == null;
        return super.isEnabled(context) && noCamel;
    }

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(ConnectCommand.class).name("Camel: Setup").category(Categories.create((String[])new String[]{CATEGORY})).description("Setup Apache Camel in your project");
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        builder.add(this.version);
    }

    public Result execute(UIExecutionContext context) throws Exception {
        Project project = this.getSelectedProject((UIContextProvider)context);
        Dependency core = this.findCamelCoreDependency(project);
        if (core != null) {
            return Results.success((String)"Apache Camel is already setup");
        }
        core = DependencyBuilder.create().setCoordinate(this.createCamelCoordinate("camel-core", (String)this.version.getValue()));
        this.dependencyInstaller.install(project, core);
        core = this.findCamelCoreDependency(project);
        String camelVersion = core.getCoordinate().getVersion();
        MavenPluginFacet pluginFacet = (MavenPluginFacet)project.getFacet(MavenPluginFacet.class);
        MavenPluginBuilder plugin = MavenPluginBuilder.create().setCoordinate(this.createCamelCoordinate("camel-maven-plugin", camelVersion));
        pluginFacet.addPlugin((MavenPlugin)plugin);
        plugin = MavenPluginBuilder.create().setCoordinate(this.createCoordinate("io.hawt", "hawtio-maven-plugin", VersionHelper.hawtioVersion()));
        pluginFacet.addPlugin((MavenPlugin)plugin);
        return Results.success((String)"Added Apache Camel to the project");
    }
}

