/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.facets.DependencyFacet;

public class CamelProjectHelper {
    public static Dependency findCamelCoreDependency(Project project) {
        return CamelProjectHelper.findCamelArtifactDependency(project, "camel-core");
    }

    public static Dependency findCamelSpringDependency(Project project) {
        return CamelProjectHelper.findCamelArtifactDependency(project, "camel-spring");
    }

    public static Dependency findCamelCDIDependency(Project project) {
        return CamelProjectHelper.findCamelArtifactDependency(project, "camel-cdi");
    }

    public static Dependency findCamelBlueprintDependency(Project project) {
        return CamelProjectHelper.findCamelArtifactDependency(project, "camel-blueprint");
    }

    public static Dependency findCamelArtifactDependency(Project project, String artifactId) {
        List dependencies = ((DependencyFacet)project.getFacet(DependencyFacet.class)).getEffectiveDependencies();
        for (Dependency d : dependencies) {
            if (!"org.apache.camel".equals(d.getCoordinate().getGroupId()) || !artifactId.equals(d.getCoordinate().getArtifactId())) continue;
            return d;
        }
        return null;
    }

    public static Set<Dependency> findCamelArtifacts(Project project) {
        LinkedHashSet<Dependency> answer = new LinkedHashSet<Dependency>();
        List dependencies = ((DependencyFacet)project.getFacet(DependencyFacet.class)).getEffectiveDependencies();
        for (Dependency d : dependencies) {
            if (!"org.apache.camel".equals(d.getCoordinate().getGroupId())) continue;
            answer.add(d);
        }
        return answer;
    }

    public static boolean hasDependency(Project project, String groupId, String artifactId) {
        return CamelProjectHelper.hasDependency(project, groupId, artifactId, null);
    }

    public static boolean hasDependency(Project project, String groupId, String artifactId, String version) {
        List dependencies = ((DependencyFacet)project.getFacet(DependencyFacet.class)).getEffectiveDependencies();
        for (Dependency d : dependencies) {
            if (!d.getCoordinate().getGroupId().equals(groupId) || !d.getCoordinate().getArtifactId().equals(artifactId) || version != null && !d.getCoordinate().getVersion().equals(version)) continue;
            return true;
        }
        return false;
    }
}

