/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project;

import io.fabric8.forge.camel.commands.project.AbstractCamelProjectCommand;
import io.fabric8.forge.camel.commands.project.CamelCatalogHelper;
import java.io.PrintStream;
import java.util.Set;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;

public class CamelListComponentCommand
extends AbstractCamelProjectCommand {
    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(CamelListComponentCommand.class).name("Camel: List Component").category(Categories.create((String[])new String[]{CATEGORY})).description("Lists all the components the current project includes");
    }

    public void initializeUI(UIBuilder builder) throws Exception {
    }

    @Override
    public boolean isEnabled(UIContext context) {
        return super.isEnabled(context) && !context.getProvider().isGUI();
    }

    public Result execute(UIExecutionContext context) throws Exception {
        Project project = this.getSelectedProject((UIContextProvider)context);
        Dependency core = this.findCamelCoreDependency(project);
        if (core == null) {
            return Results.fail((String)"The project does not include camel-core");
        }
        PrintStream out = this.getOutput(context);
        Set<Dependency> artifacts = this.findCamelArtifacts(project);
        for (Dependency d : artifacts) {
            Set<String> components = CamelCatalogHelper.componentsFromArtifact(d.getCoordinate().getArtifactId());
            for (String c : components) {
                out.println(c);
            }
        }
        return Results.success();
    }
}

