/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project;

import io.fabric8.forge.camel.commands.project.CamelCatalogHelper;
import io.fabric8.forge.camel.commands.project.CamelProjectHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.camel.catalog.DefaultCamelCatalog;
import org.apache.camel.catalog.JSonSchemaHelper;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.UICompleter;
import org.jboss.forge.addon.ui.input.UIInput;

public class CamelComponentsCompleter
implements UICompleter<String> {
    private Project project;
    private UIInput<String> filter;
    private final boolean excludeComponentsOnClasspath;

    public CamelComponentsCompleter(Project project, UIInput<String> filter, boolean excludeComponentsOnClasspath) {
        this.project = project;
        this.filter = filter;
        this.excludeComponentsOnClasspath = excludeComponentsOnClasspath;
    }

    public Iterable<String> getCompletionProposals(UIContext context, InputComponent input, String value) {
        Dependency core = CamelProjectHelper.findCamelCoreDependency(this.project);
        if (core == null) {
            return null;
        }
        DefaultCamelCatalog catalog = new DefaultCamelCatalog();
        List names = catalog.findComponentNames();
        List<String> filtered = new ArrayList<String>();
        for (String name : names) {
            if (value != null && !name.startsWith(value)) continue;
            filtered.add(name);
        }
        filtered = this.filterByName(filtered);
        filtered = this.filterByLabel(filtered, (String)this.filter.getValue());
        return filtered;
    }

    public Iterable<String> getValueChoices(String label) {
        Dependency core = CamelProjectHelper.findCamelCoreDependency(this.project);
        if (core == null) {
            return null;
        }
        DefaultCamelCatalog catalog = new DefaultCamelCatalog();
        List names = catalog.findComponentNames();
        if (this.excludeComponentsOnClasspath) {
            Set<Dependency> artifacts = CamelProjectHelper.findCamelArtifacts(this.project);
            for (Dependency dep : artifacts) {
                Set<String> components = CamelCatalogHelper.componentsFromArtifact(dep.getCoordinate().getArtifactId());
                names.removeAll(components);
            }
        }
        if (label == null || "<all>".equals(label)) {
            return names;
        }
        return this.filterByLabel(names, label);
    }

    private List<String> filterByName(List<String> choices) {
        ArrayList<String> answer = new ArrayList<String>();
        DefaultCamelCatalog catalog = new DefaultCamelCatalog();
        for (String name : choices) {
            String json;
            String artifactId;
            boolean already = false;
            if (this.excludeComponentsOnClasspath && (artifactId = CamelComponentsCompleter.findArtifactId(json = catalog.componentJSonSchema(name))) != null) {
                already = CamelProjectHelper.hasDependency(this.project, "org.apache.camel", artifactId);
            }
            if (already) continue;
            answer.add(name);
        }
        return answer;
    }

    private List<String> filterByLabel(List<String> choices, String label) {
        if (label == null || label.isEmpty()) {
            return choices;
        }
        ArrayList<String> answer = new ArrayList<String>();
        DefaultCamelCatalog catalog = new DefaultCamelCatalog();
        block0: for (String name : choices) {
            String json = catalog.componentJSonSchema(name);
            String labels = CamelComponentsCompleter.findLabel(json);
            if (labels != null) {
                for (String target : labels.split(",")) {
                    if (!target.startsWith(label)) continue;
                    answer.add(name);
                    continue block0;
                }
                continue;
            }
            answer.addAll(choices);
        }
        return answer;
    }

    private static String findArtifactId(String json) {
        List data = JSonSchemaHelper.parseJsonSchema((String)"component", (String)json, (boolean)false);
        for (Map row : data) {
            if (row.get("artifactId") == null) continue;
            return (String)row.get("artifactId");
        }
        return null;
    }

    private static String findLabel(String json) {
        List data = JSonSchemaHelper.parseJsonSchema((String)"component", (String)json, (boolean)false);
        for (Map row : data) {
            if (row.get("label") == null) continue;
            return (String)row.get("label");
        }
        return null;
    }
}

