/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project;

import io.fabric8.forge.camel.commands.project.AbstractCamelProjectCommand;
import io.fabric8.forge.camel.commands.project.CamelCommands;
import io.fabric8.forge.camel.commands.project.ClassNameValidator;
import io.fabric8.forge.camel.commands.project.ConfigureComponentPropertiesStep;
import io.fabric8.forge.camel.commands.project.PackageNameCompleter;
import io.fabric8.forge.camel.commands.project.PackageNameValidator;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.jboss.forge.addon.dependencies.DependencyResolver;
import org.jboss.forge.addon.facets.constraints.FacetConstraint;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.dependencies.DependencyInstaller;
import org.jboss.forge.addon.projects.facets.ClassLoaderFacet;
import org.jboss.forge.addon.projects.facets.ResourcesFacet;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UINavigationContext;
import org.jboss.forge.addon.ui.input.UICompleter;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.addon.ui.validate.UIValidator;
import org.jboss.forge.addon.ui.wizard.UIWizard;
import org.jboss.forge.roaster.model.util.Strings;

@FacetConstraint(value={JavaSourceFacet.class, ResourcesFacet.class, ClassLoaderFacet.class})
public class CamelAddComponentInstanceSpringCommand
extends AbstractCamelProjectCommand
implements UIWizard {
    @Inject
    @WithAttributes(label="componentNameFilter", required=false, description="To filter components")
    private UISelectOne<String> componentNameFilter;
    @Inject
    @WithAttributes(label="componentName", required=true, description="Name of component type to add")
    private UISelectOne<String> componentName;
    @Inject
    @WithAttributes(label="instanceName", required=true, description="Name of component instance to add")
    private UISelectOne<String> instanceName;
    @Inject
    @WithAttributes(label="targetPackage", required=false, description="The package name where this type will be created")
    private UIInput<String> targetPackage;
    @Inject
    @WithAttributes(label="className", required=true, description="Name of the Spring Component class to generate")
    private UIInput<String> className;
    @Inject
    private DependencyInstaller dependencyInstaller;
    @Inject
    private DependencyResolver dependencyResolver;

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(CamelAddComponentInstanceSpringCommand.class).name("Camel: New Component Spring").category(Categories.create((String[])new String[]{CATEGORY})).description("Adds a Camel component instance configuration using Spring to your project");
    }

    @Override
    public boolean isEnabled(UIContext context) {
        boolean enabled = super.isEnabled(context);
        if (enabled) {
            return CamelCommands.isSpringProject(this.getSelectedProject(context));
        }
        return false;
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        Project project = this.getSelectedProject(builder.getUIContext());
        JavaSourceFacet facet = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
        this.componentNameFilter.setValueChoices(CamelCommands.createComponentNameValues(project));
        this.componentNameFilter.setDefaultValue((Object)"<all>");
        this.componentName.setValueChoices(CamelCommands.createComponentNameValues(project, this.componentNameFilter, false));
        this.instanceName.setDefaultValue((Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                String value = (String)CamelAddComponentInstanceSpringCommand.this.componentName.getValue();
                return value;
            }
        });
        this.targetPackage.setCompleter((UICompleter)new PackageNameCompleter(facet));
        this.targetPackage.addValidator((UIValidator)new PackageNameValidator());
        this.targetPackage.setDefaultValue((Object)"org.apache.camel.spring.components");
        this.className.addValidator((UIValidator)new ClassNameValidator());
        this.className.setDefaultValue((Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return CamelAddComponentInstanceSpringCommand.this.getDefaultProducerClassName();
            }
        });
        builder.add(this.componentNameFilter).add(this.componentName).add(this.instanceName).add(this.targetPackage).add(this.className);
    }

    public NavigationResult next(UINavigationContext context) throws Exception {
        Map attributeMap = context.getUIContext().getAttributeMap();
        attributeMap.put("componentName", this.componentName.getValue());
        attributeMap.put("instanceName", this.instanceName.getValue());
        attributeMap.put("targetPackage", this.targetPackage.getValue());
        attributeMap.put("className", this.className.getValue());
        attributeMap.put("kind", "spring");
        return Results.navigateTo(ConfigureComponentPropertiesStep.class);
    }

    public Result execute(UIExecutionContext context) throws Exception {
        return Results.success();
    }

    protected String getDefaultProducerClassName() {
        String name = (String)this.instanceName.getValue();
        if (!Strings.isBlank((String)name)) {
            return Strings.capitalize((String)name) + "ComponentFactory";
        }
        return null;
    }
}

