/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.spring.boot.converters;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;

public class FactoryConverter<S, T>
implements GenericConverter,
BeanFactoryAware {
    private String name;
    private Class<S> sourceType;
    private Class<S> targetType;
    private Class<?> type;
    private BeanFactory beanFactory;

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(this.sourceType, this.targetType));
    }

    public Object convert(Object o, TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor1) {
        try {
            Object factory = this.beanFactory.getBean(this.type);
            Method method = factory.getClass().getDeclaredMethod(this.name, this.sourceType);
            return method.invoke(factory, o);
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to convert.", t);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Class<S> getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(Class<S> sourceType) {
        this.sourceType = sourceType;
    }

    public Class<S> getTargetType() {
        return this.targetType;
    }

    public void setTargetType(Class<S> targetType) {
        this.targetType = targetType;
    }

    public Class<?> getType() {
        return this.type;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }
}

