/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge;

import io.fabric8.forge.NewProjectFormData;
import io.fabric8.selenium.ConsoleTests;
import io.fabric8.selenium.PageSupport;
import io.fabric8.selenium.WebDriverFacade;
import io.fabric8.utils.Millis;
import org.junit.Assert;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public class ProjectsPage
extends PageSupport {
    private final By signInBy = By.linkText((String)"Sign In");
    private final By createProjectBy = By.partialLinkText((String)"Create Project");
    private final By projectsLinkBy = By.linkText((String)"Projects");
    private final String gogsPassword = "RedHat$1";
    private final String gogsEmail = "james.strachan@gmail.com";
    private String startUrl;
    private String buildConfigsUrl;
    private String gogsUserName = "gogsadmin";

    public ProjectsPage(WebDriverFacade facade) {
        super(facade);
        ConsoleTests.waitUntilLoggedIn(facade);
        this.startUrl = this.getDriver().getCurrentUrl();
        this.buildConfigsUrl = this.relativeUrl(this.startUrl, "/kubernetes", "/kubernetes/buildConfigs");
    }

    public void goToProjectsPage() {
        WebDriverFacade facade = this.getFacade();
        facade.untilLinkClickedLoop(this.projectsLinkBy, this.buildConfigsUrl);
        facade.untilOneOf(this.signInBy, this.createProjectBy);
        WebElement signIn = facade.findOptionalElement(this.signInBy);
        if (signIn != null && signIn.isDisplayed()) {
            this.logInfo("Waiting for signin button to be clicked");
            facade.untilLinkClicked(this.signInBy);
            this.signIntoGogs();
        } else {
            this.logInfo("Sign in button not present");
        }
        this.logWait("button: " + this.createProjectBy + "");
        facade.untilIsEnabled(this.createProjectBy);
    }

    public void createProject(NewProjectFormData form) {
        this.goToProjectsPage();
        WebDriverFacade facade = this.getFacade();
        facade.untilLinkClicked(this.createProjectBy);
        By nextButton = By.xpath((String)"//button[@ng-click='execute()']");
        facade.setDefaultTimeoutInSeconds(540L);
        String named = form.getNamed();
        facade.form().clearAndSendKeys(By.xpath((String)"//input[@ng-model='entity.named']"), named).submitButton(nextButton).submit();
        facade.form().completeComboBox(By.xpath((String)"//label[text() = 'Archetype']/following::input[@type='text']"), form.getArchetypeFilter()).submitButton(nextButton).submit();
        this.untilNextWizardPage(facade, nextButton);
        facade.form().submitButton(nextButton).submit();
        this.untilNextWizardPage(facade, nextButton);
        facade.form().completeComboBox(By.xpath((String)"//label[text() = 'Flow']/following::input[@type='text']"), form.getJenkinsFileFilter()).submitButton(nextButton).submit();
        facade.untilIsDisplayed(By.xpath((String)"//a[@href='/forge/repos' and text()='Done']"));
        this.logInfo("Created project: " + named);
        this.goToProjectsPage();
        facade.untilIsDisplayed(By.partialLinkText((String)named));
    }

    public By getCreateProjectBy() {
        return this.createProjectBy;
    }

    public By getSignInBy() {
        return this.signInBy;
    }

    public String getGogsEmail() {
        return "james.strachan@gmail.com";
    }

    public String getGogsUserName() {
        return this.gogsUserName;
    }

    public void setGogsUserName(String gogsUserName) {
        this.gogsUserName = gogsUserName;
    }

    public String getGogsPassword() {
        return "RedHat$1";
    }

    protected String relativeUrl(String url, String trimPath, String newPath) {
        int idx = url.indexOf(trimPath);
        if (idx < 0) {
            Assert.fail((String)("The URL `" + url + "` does not include path `" + trimPath + "`"));
        }
        return url.substring(0, idx) + newPath;
    }

    protected void signIntoGogs() {
        this.getFacade().form().clearAndSendKeys(By.id((String)"gitUsername"), this.gogsUserName).clearAndSendKeys(By.id((String)"gitPassword"), "RedHat$1").clearAndSendKeys(By.id((String)"gitEmail"), "james.strachan@gmail.com").submitButton(By.xpath((String)"//button[@ng-click='doLogin()']")).submit();
    }

    protected void untilNextWizardPage(WebDriverFacade facade, By nextButton) {
        facade.sleep(Millis.seconds((int)5));
        facade.untilIsEnabled(nextButton);
    }
}

