/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.plugin.mojo.internal;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.maven.core.util.VersionUtil;
import io.fabric8.maven.plugin.mojo.internal.AbstractArtifactSearchMojo;
import io.fabric8.utils.Strings;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="manifest-index")
public class ManifestIndexMojo
extends AbstractArtifactSearchMojo {
    @Parameter(property="fabric8.manifest.indexTitle", defaultValue="Manifest Repository")
    private String manifestTitle;
    @Parameter(property="fabric8.manifest.kubernetes.introductionHtmlFile", defaultValue="${basedir}/src/main/fabric8/site/kubernetes-introduction.html")
    private File kubernetesIntroductionHtmlFile;
    @Parameter(property="fabric8.manifest.openshift.introductionHtmlFile", defaultValue="${basedir}/src/main/fabric8/site/openshift-introduction.html")
    private File openshiftIntroductionHtmlFile;
    @Parameter(property="fabric8.manifest.kubernetes.headHtmlFile", defaultValue="${basedir}/src/main/fabric8/site/kubernetes-head.html")
    private File kubernetesHeadHtmlFile;
    @Parameter(property="fabric8.manifest.openshift.headHtmlFile", defaultValue="${basedir}/src/main/fabric8/site/openshift-head.html")
    private File openshiftHeadHtmlFile;
    @Parameter(property="fabric8.manifest.kubernetes.headHtmlFile", defaultValue="${basedir}/src/main/fabric8/site/kubernetes-footer.html")
    private File kubernetesFooterHtmlFile;
    @Parameter(property="fabric8.manifest.openshift.headHtmlFile", defaultValue="${basedir}/src/main/fabric8/site/openshift-footer.html")
    private File openshiftFooterHtmlFile;
    @Parameter(property="fabric8.manifest.outputYamlFile", defaultValue="${project.build.directory}/fabric8/site/manifests/index.yaml")
    private File outputFile;
    @Parameter(property="fabric8.manifest.outputHtmlDir", defaultValue="${project.build.directory}/fabric8/site/manifests")
    private File outputHtmlDir;
    @Parameter(property="fabric8.manifest.tempDir", defaultValue="${project.build.directory}/fabric8/tmp-manifests")
    private File tempDir;
    @Parameter(property="fabric8.manifest.index.maxVersionsPerApp", defaultValue="8")
    private int maxVersionsPerApp;

    private static String getDescription(ManifestInfo manifestInfo) {
        String answer = manifestInfo.getDescription();
        return answer != null ? answer : "";
    }

    protected static String getVersion(ManifestInfo manifestInfo) {
        return manifestInfo.getVersion();
    }

    @Override
    public void executeInternal() throws MojoExecutionException, MojoFailureException {
        this.outputFile.getParentFile().mkdirs();
        this.log.info("Creating Manifest Index file at: %s", new Object[]{this.outputFile});
        List<AbstractArtifactSearchMojo.ArtifactDTO> artifacts = this.searchMaven("?q=l:%22kubernetes%22");
        TreeMap<String, ManifestInfo> manifests = new TreeMap<String, ManifestInfo>();
        for (AbstractArtifactSearchMojo.ArtifactDTO artifactDTO : artifacts) {
            this.addManifestInfo(manifests, artifactDTO);
        }
        Set entries = manifests.entrySet();
        for (Map.Entry entry : entries) {
            this.getLog().debug((CharSequence)("" + (String)entry.getKey() + " = " + entry.getValue()));
        }
        try {
            ObjectMapper objectMapper = KubernetesHelper.createYamlObjectMapper();
            objectMapper.writeValue(this.outputFile, manifests);
        }
        catch (IOException iOException) {
            throw new MojoExecutionException("Failed to write results as YAML to: " + this.outputFile + ". " + iOException, (Exception)iOException);
        }
        this.generateHTML(new File(this.outputHtmlDir, "kubernetes.html"), manifests, true, this.kubernetesIntroductionHtmlFile, this.kubernetesHeadHtmlFile, this.kubernetesFooterHtmlFile);
        this.generateHTML(new File(this.outputHtmlDir, "openshift.html"), manifests, false, this.openshiftIntroductionHtmlFile, this.openshiftHeadHtmlFile, this.openshiftFooterHtmlFile);
    }

    protected void generateHTML(File outputHtmlFile, Map<String, ManifestInfo> manifests, boolean kubernetes, File introductionHtmlFile, File headHtmlFile, File footerHtmlFile) throws MojoExecutionException {
        TreeMap<String, TreeSet<ManifestInfo>> manifestMap = new TreeMap<String, TreeSet<ManifestInfo>>();
        for (ManifestInfo manifestInfo : manifests.values()) {
            String key = manifestInfo.getName();
            TreeSet<ManifestInfo> set = (TreeSet<ManifestInfo>)manifestMap.get(key);
            if (set == null) {
                set = new TreeSet<ManifestInfo>(this.createManifestComparator());
                manifestMap.put(key, set);
            }
            set.add(manifestInfo);
        }
        try (PrintWriter writer = new PrintWriter(new FileWriter(outputHtmlFile));){
            writer.println("<html>");
            writer.println("<head>");
            writer.println(ManifestIndexMojo.getHtmlFileContentOrDefault(headHtmlFile, "<link href='style.css' rel=stylesheet>\n<link href='custom.css' rel=stylesheet>\n<title>" + this.manifestTitle + "</title>\n"));
            writer.println("</head>");
            writer.println("<body>");
            writer.println(ManifestIndexMojo.getHtmlFileContentOrDefault(introductionHtmlFile, "<h1>" + this.manifestTitle + "</h1>"));
            writer.println("<table class='table table-striped table-hover'>");
            writer.println("  <hhead>");
            writer.println("    <tr>");
            writer.println("      <th>Manifest</th>");
            writer.println("      <th>Versions</th>");
            writer.println("    </tr>");
            writer.println("  </hhead>");
            writer.println("  <tbody>");
            for (Map.Entry entry : manifestMap.entrySet()) {
                String key = (String)entry.getKey();
                SortedSet set = (SortedSet)entry.getValue();
                if (set.isEmpty()) continue;
                ManifestInfo first = (ManifestInfo)set.first();
                first.configure(this);
                if (!first.isValid()) continue;
                String manifestDescription = ManifestIndexMojo.getDescription(first);
                writer.println("    <tr>");
                writer.println("      <td title='" + manifestDescription + "'>");
                String iconHtml = "";
                String iconUrl = this.findIconURL(set);
                if (Strings.isNotBlank((String)iconUrl)) {
                    iconHtml = "<img class='logo' src='" + iconUrl + "'>";
                }
                writer.println("        " + iconHtml + "<span class='manifest-name'>" + key + "</span>");
                writer.println("      </td>");
                writer.println("      <td class='versions'>");
                int count = 0;
                for (ManifestInfo manifestInfo : set) {
                    if (this.maxVersionsPerApp > 0 && ++count > this.maxVersionsPerApp) break;
                    String description = ManifestIndexMojo.getDescription(manifestInfo);
                    String version = manifestInfo.getVersion();
                    String href = kubernetes ? manifestInfo.getKubernetesUrl() : manifestInfo.getOpenShiftUrl();
                    String versionId = manifestInfo.getId();
                    String command = kubernetes ? "kubectl" : "oc";
                    writer.println("        <a class='btn btn-default' role='button' data-toggle='collapse' href='#" + versionId + "' aria-expanded='false' aria-controls='" + versionId + "' title='" + description + "'>\n" + version + "\n" + "</a>\n" + "<div class='collapse' id='" + versionId + "'>\n" + "  <div class='well'>\n" + "    <p>To install version <b>" + version + "</b> of <b>" + key + "</b> type the following command:</p>\n" + "    <code>" + command + " apply -f " + href + "</code>\n" + "    <div class='version-buttons'><a class='btn btn-primary' title='Download the YAML manifest for " + key + " version " + version + "' href='" + href + "'><i class='fa fa-download' aria-hidden='true'></i> Download Manifest</a> " + "<a class='btn btn-primary' target='gofabric8' title='Run this application via the go.fabric8.io website' href='https://go.fabric8.io/?manifest=" + href + "'><i class='fa fa-external-link' aria-hidden='true'></i> Run via browser</a></div>\n" + "  </div>\n" + "</div>");
                }
                writer.println("      </td>");
                writer.println("    </tr>");
            }
            writer.println("  </tbody>");
            writer.println("  </table>");
            writer.println(ManifestIndexMojo.getHtmlFileContentOrDefault(footerHtmlFile, ""));
            writer.println("</body>");
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to write to " + outputHtmlFile + ". " + e, (Exception)e);
        }
    }

    private String findIconURL(Iterable<ManifestInfo> manifestInfos) {
        for (ManifestInfo manifestInfo : manifestInfos) {
            String icon = manifestInfo.getIcon();
            if (!Strings.isNotBlank((String)icon)) continue;
            return icon;
        }
        return "https://fabric8.io/images/logos/kubernetes.png";
    }

    private Comparator<ManifestInfo> createManifestComparator() {
        return new Comparator<ManifestInfo>(){

            @Override
            public int compare(ManifestInfo c1, ManifestInfo c2) {
                String v2;
                String v1 = ManifestIndexMojo.getVersion(c1);
                int answer = VersionUtil.compareVersions((String)v1, (String)(v2 = ManifestIndexMojo.getVersion(c2)));
                if (answer > 0) {
                    return -1;
                }
                if (answer < 0) {
                    return 1;
                }
                return 0;
            }
        };
    }

    protected void addManifestInfo(Map<String, ManifestInfo> manifests, AbstractArtifactSearchMojo.ArtifactDTO artifact) {
        List<String> ec = artifact.getEc();
        if (ec != null && ec.indexOf("-openshift.yml") >= 0 && ec.indexOf("-openshift.yml") >= 0) {
            ManifestInfo latest = new ManifestInfo(this.mavenRepoUrl, artifact);
            String key = artifact.createKey();
            manifests.put(key, latest);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    protected class ManifestInfo {
        @JsonIgnore
        private final AbstractArtifactSearchMojo.ArtifactDTO artifact;
        private String kubernetesUrl;
        private String openShiftUrl;
        private String icon;
        private String name;
        private String version;
        private String description;
        private String buildUrl;
        private String gitUrl;
        private String gitCommit;
        private String docsUrl;
        @JsonIgnore
        private Object kubernetesManifest;
        @JsonIgnore
        private Object openShiftManifest;

        public ManifestInfo(String mavenRepoUrl, AbstractArtifactSearchMojo.ArtifactDTO artifact) {
            this.artifact = artifact;
            this.version = artifact.getV();
            String artifactId = artifact.getA();
            String urlPrefix = mavenRepoUrl + artifact.getG().replace('.', '/') + "/" + artifactId + "/" + this.version + "/" + artifactId + "-" + this.version;
            this.kubernetesUrl = urlPrefix + "-kubernetes.yml";
            this.openShiftUrl = urlPrefix + "-openshift.yml";
            this.name = artifactId;
        }

        private void updateFromManifest(Object manifest) {
            if (Strings.isNullOrBlank((String)this.description)) {
                this.description = AbstractArtifactSearchMojo.findManifestAnnotation(manifest, "description");
            }
            if (Strings.isNullOrBlank((String)this.icon)) {
                this.icon = ManifestIndexMojo.this.convertRelativeIcon(AbstractArtifactSearchMojo.findManifestIcon(manifest));
            }
            if (Strings.isNullOrBlank((String)this.buildUrl)) {
                this.buildUrl = AbstractArtifactSearchMojo.findManifestAnnotation(manifest, "fabric8.io/build-url");
            }
            if (Strings.isNullOrBlank((String)this.gitUrl)) {
                this.gitUrl = AbstractArtifactSearchMojo.findManifestAnnotation(manifest, "fabric8.io/git-url");
            }
            if (Strings.isNullOrBlank((String)this.gitCommit)) {
                this.gitCommit = AbstractArtifactSearchMojo.findManifestAnnotation(manifest, "fabric8.io/git-commit");
            }
            if (Strings.isNullOrBlank((String)this.docsUrl)) {
                this.docsUrl = AbstractArtifactSearchMojo.findManifestAnnotation(manifest, "fabric8.io/docs-url");
            }
        }

        public String toString() {
            return "ManifestInfo{name='" + this.name + '\'' + ", version='" + this.version + '\'' + '}';
        }

        public void configure(AbstractArtifactSearchMojo mojo) {
            Object manifest;
            if (this.kubernetesManifest == null) {
                manifest = mojo.loadKubernetesManifestFile(this.artifact);
                this.setKubernetesManifest(manifest);
                if (manifest == null) {
                    mojo.getLog().warn((CharSequence)("Could not find kubernetes manifest for " + this));
                }
            }
            if (this.openShiftManifest == null) {
                manifest = mojo.loadOpenShiftManifestFile(this.artifact);
                this.setOpenShiftManifest(manifest);
                if (manifest == null) {
                    mojo.getLog().warn((CharSequence)("Could not find openshift manifest for " + this));
                }
            }
        }

        public String getKubernetesUrl() {
            return this.kubernetesUrl;
        }

        public void setKubernetesUrl(String kubernetesUrl) {
            this.kubernetesUrl = kubernetesUrl;
        }

        public String getOpenShiftUrl() {
            return this.openShiftUrl;
        }

        public void setOpenShiftUrl(String openShiftUrl) {
            this.openShiftUrl = openShiftUrl;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getIcon() {
            return this.icon;
        }

        public void setIcon(String icon) {
            this.icon = icon;
        }

        public Object getKubernetesManifest() {
            return this.kubernetesManifest;
        }

        public void setKubernetesManifest(Object kubernetesManifest) {
            this.kubernetesManifest = kubernetesManifest;
            this.updateFromManifest(kubernetesManifest);
        }

        public Object getOpenShiftManifest() {
            return this.openShiftManifest;
        }

        public void setOpenShiftManifest(Object openShiftManifest) {
            this.openShiftManifest = openShiftManifest;
            this.updateFromManifest(this.kubernetesManifest);
        }

        public String getBuildUrl() {
            return this.buildUrl;
        }

        public void setBuildUrl(String buildUrl) {
            this.buildUrl = buildUrl;
        }

        public String getGitUrl() {
            return this.gitUrl;
        }

        public void setGitUrl(String gitUrl) {
            this.gitUrl = gitUrl;
        }

        public String getGitCommit() {
            return this.gitCommit;
        }

        public void setGitCommit(String gitCommit) {
            this.gitCommit = gitCommit;
        }

        public String getDocsUrl() {
            return this.docsUrl;
        }

        public void setDocsUrl(String docsUrl) {
            this.docsUrl = docsUrl;
        }

        public boolean isValid() {
            return this.kubernetesManifest != null && this.openShiftManifest != null && this.kubernetesUrl != null && this.openShiftUrl != null;
        }

        public String getId() {
            String answer = this.name + "_" + this.version;
            answer = answer.replace('.', '_').replace('-', '_');
            return answer;
        }
    }
}

