/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.plugin;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.maven.plugin.AbstractFabric8Mojo;
import io.fabric8.maven.plugin.HelmMojo;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.maven.artifact.repository.MavenArtifactRepository;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.tar.TarUnArchiver;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.impl.ArtifactResolver;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResult;

@Mojo(name="helm-index")
public class HelmIndexMojo
extends AbstractFabric8Mojo {
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter(property="fabric8.helm.indexFile", defaultValue="${project.build.directory}/fabric8/helm-index.yaml")
    private File outputFile;
    @Parameter(property="fabric8.helm.tempDir", defaultValue="${project.build.directory}/fabric8/tmp-charts")
    private File tempDir;
    @Component
    protected ArtifactResolver artifactResolver;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}")
    protected List<MavenArtifactRepository> remoteRepositories;
    @Component(role=UnArchiver.class, hint="tar")
    private TarUnArchiver unArchiver;
    @Parameter(defaultValue="${repositorySystemSession}")
    private RepositorySystemSession repoSession;
    @Parameter(property="fabric8.helm.index.maxSearchResults", defaultValue="50000")
    private int maxSearchResults = 2;
    @Parameter(property="fabric8.helm.index.mavenRepoUrl", defaultValue="http://central.maven.org/maven2/")
    private String mavenRepoUrl;
    @Parameter(property="fabric8.helm.index.mavenRepoSearchUrl", defaultValue="http://search.maven.org/solrsearch/select")
    private String mavenRepoSearchUrl;

    @Override
    public void executeInternal() throws MojoExecutionException, MojoFailureException {
        this.outputFile.getParentFile().mkdirs();
        this.log.info("Creating Helm Chart Index file at: %s", new Object[]{this.outputFile});
        Result result = null;
        String urlText = this.mavenRepoSearchUrl + "?q=l:%22helm%22&wt=json&rows=" + this.maxSearchResults;
        try {
            URL url = new URL(urlText);
            ObjectMapper mapper = new ObjectMapper();
            result = (Result)mapper.readerFor(Result.class).readValue(url);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not query " + urlText + " : " + e, (Exception)e);
        }
        if (result == null) {
            throw new MojoExecutionException("No result!");
        }
        Response response = result.getResponse();
        if (response == null) {
            throw new MojoExecutionException("No response!");
        }
        List<ArtifactDTO> artifacts = response.getDocs();
        if (artifacts == null) {
            throw new MojoExecutionException("No docs!");
        }
        TreeMap<String, ChartInfo> charts = new TreeMap<String, ChartInfo>();
        for (ArtifactDTO artifactDTO : artifacts) {
            this.addChartInfo(charts, artifactDTO);
        }
        Set entries = charts.entrySet();
        for (Map.Entry entry : entries) {
            this.getLog().debug((CharSequence)("" + (String)entry.getKey() + " = " + entry.getValue()));
        }
        try {
            ObjectMapper objectMapper = KubernetesHelper.createYamlObjectMapper();
            objectMapper.writeValue(this.outputFile, charts);
        }
        catch (IOException iOException) {
            throw new MojoExecutionException("Failed to write results as YAML to: " + this.outputFile + ". " + iOException, (Exception)iOException);
        }
    }

    protected void addChartInfo(Map<String, ChartInfo> charts, ArtifactDTO artifact) {
        ChartInfo latest = new ChartInfo(this.mavenRepoUrl, artifact);
        String key = this.createChartKey(artifact);
        HelmMojo.Chart chartfile = this.createChartFile(artifact);
        if (chartfile != null) {
            latest.setChartfile(chartfile);
            charts.put(key, latest);
        } else {
            this.getLog().warn((CharSequence)("Could not find chartfile for " + latest));
        }
    }

    private String createChartKey(ArtifactDTO artifact) {
        return artifact.getA() + "-" + artifact.getV();
    }

    private HelmMojo.Chart createChartFile(ArtifactDTO artifactDTO) {
        File file = null;
        try {
            ArtifactRequest artifactRequest = new ArtifactRequest();
            DefaultArtifact artifact = new DefaultArtifact(artifactDTO.getG(), artifactDTO.getA(), "helm", "tar.gz", artifactDTO.getV());
            artifactRequest.setArtifact((Artifact)artifact);
            ArrayList<RemoteRepository> aetherRepoList = new ArrayList<RemoteRepository>();
            for (MavenArtifactRepository remoteRepository : this.remoteRepositories) {
                RemoteRepository.Builder builder = new RemoteRepository.Builder(remoteRepository.getId(), remoteRepository.getLayout().getId(), remoteRepository.getUrl());
                RemoteRepository aetherRepo = builder.build();
                aetherRepoList.add(aetherRepo);
            }
            artifactRequest.setRepositories(aetherRepoList);
            ArtifactResult artifactResult = this.artifactResolver.resolveArtifact(this.repoSession, artifactRequest);
            Artifact resolvedArtifact = artifactResult.getArtifact();
            if (resolvedArtifact == null) {
                this.getLog().warn((CharSequence)("Could not resolve artifact " + artifactDTO.description()));
                return null;
            }
            file = resolvedArtifact.getFile();
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)("Failed to resolve helm chart for " + artifactDTO.description() + ". " + e), (Throwable)e);
            return null;
        }
        if (file == null) {
            this.getLog().warn((CharSequence)("Could not resolve artifact file for " + artifactDTO.description()));
            return null;
        }
        if (!file.isFile() || !file.exists()) {
            this.getLog().warn((CharSequence)("Resolved artifact file does not exist for " + artifactDTO.description()));
            return null;
        }
        File untarDestDir = new File(this.tempDir, artifactDTO.getG() + "/" + artifactDTO.getA() + "-" + artifactDTO.getV() + "-chart");
        untarDestDir.mkdirs();
        this.getLog().debug((CharSequence)("" + artifactDTO.description() + " extracting " + file.getAbsolutePath() + " to " + untarDestDir));
        this.unArchiver.setSourceFile(file);
        this.unArchiver.setDestDirectory(untarDestDir);
        this.unArchiver.setCompression(TarUnArchiver.UntarCompressionMethod.GZIP);
        this.unArchiver.extract();
        File tempChartFile = new File(untarDestDir, "Chart.yaml");
        if (!tempChartFile.isFile() || !tempChartFile.exists()) {
            this.getLog().warn((CharSequence)("No Chart.yaml exists at " + tempChartFile));
            return null;
        }
        try {
            return (HelmMojo.Chart)KubernetesHelper.loadYaml((File)tempChartFile, HelmMojo.Chart.class);
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)("Failed to parse " + tempChartFile + ". " + e), (Throwable)e);
            return null;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    protected static class ChartInfo {
        private String url;
        private String name;
        private HelmMojo.Chart chartfile;

        public ChartInfo(String mavenRepoUrl, ArtifactDTO artifact) {
            String artifactId = artifact.getA();
            String version = artifact.getV();
            this.url = mavenRepoUrl + artifact.getG().replace('.', '/') + "/" + artifactId + "/" + version + "/" + artifactId + "-" + version + "-helm.tar.gz";
            this.name = artifactId;
        }

        public String toString() {
            return "ChartInfo{url='" + this.url + '\'' + ", name='" + this.name + '\'' + ", chartfile=" + this.chartfile + '}';
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public HelmMojo.Chart getChartfile() {
            return this.chartfile;
        }

        public void setChartfile(HelmMojo.Chart chartfile) {
            this.chartfile = chartfile;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ArtifactDTO {
        private String id;
        private String g;
        private String a;
        private String v;
        private String p;

        public String toString() {
            return "ArtifactDTO: " + this.g + ":" + this.a + ":" + this.v;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getG() {
            return this.g;
        }

        public void setG(String g) {
            this.g = g;
        }

        public String getA() {
            return this.a;
        }

        public void setA(String a) {
            this.a = a;
        }

        public String getV() {
            return this.v;
        }

        public void setV(String v) {
            this.v = v;
        }

        public String getP() {
            return this.p;
        }

        public void setP(String p) {
            this.p = p;
        }

        public String description() {
            return "" + this.g + ":" + this.a + ":" + this.v;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Response {
        private List<ArtifactDTO> docs;

        public List<ArtifactDTO> getDocs() {
            return this.docs;
        }

        public void setDocs(List<ArtifactDTO> docs) {
            this.docs = docs;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Result {
        private Response response;

        public Response getResponse() {
            return this.response;
        }

        public void setResponse(Response response) {
            this.response = response;
        }
    }
}

