/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven;

import io.fabric8.maven.HelmMojo;
import io.fabric8.utils.Files;
import io.fabric8.utils.Objects;
import io.fabric8.utils.Strings;
import java.io.File;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;

@Mojo(name="helm-push", defaultPhase=LifecyclePhase.PACKAGE)
public class HelmPushMojo
extends HelmMojo {
    @Parameter(property="fabric8.helm.commitMessage", defaultValue="Adding charts for ${project.groupId}/${project.artifactId} version ${project.version}")
    private String commitMessage;
    @Parameter(property="fabric8.helm.push", defaultValue="true")
    private boolean pushChanges;
    @Parameter(property="fabric8.helm.username")
    private String userName;
    @Parameter(property="fabric8.helm.email")
    private String emailAddress;
    @Parameter(defaultValue="${reactorProjects}", readonly=true, required=true)
    private List<MavenProject> reactorProjects;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.isRootReactorBuild()) {
            this.getLog().info((CharSequence)"Not the root reactor build so not committing changes");
            return;
        }
        File outputDir = this.getHelmRepoFolder();
        if (!Files.isDirectory((File)outputDir)) {
            throw new MojoExecutionException("No helm repository exists for " + outputDir + ". Did you run `mvn fabric8:helm` yet?");
        }
        File gitFolder = new File(outputDir, ".git");
        if (!Files.isDirectory((File)gitFolder)) {
            throw new MojoExecutionException("No helm git repository exists for " + gitFolder + ". Did you run `mvn fabric8:helm` yet?");
        }
        FileRepositoryBuilder builder = new FileRepositoryBuilder();
        Git git = null;
        try {
            Repository repository = ((FileRepositoryBuilder)((FileRepositoryBuilder)((FileRepositoryBuilder)builder.setGitDir(gitFolder)).readEnvironment()).findGitDir()).build();
            git = new Git(repository);
            git.add().addFilepattern(".").call();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to add files to the helm git repository: " + e, e);
        }
        CommitCommand commit = git.commit().setAll(true).setMessage(this.commitMessage);
        PersonIdent author = null;
        if (Strings.isNotBlank((String)this.userName) && Strings.isNotBlank((String)this.emailAddress)) {
            author = new PersonIdent(this.userName, this.emailAddress);
        }
        if (author != null) {
            commit = commit.setAuthor(author);
        }
        try {
            RevCommit answer = commit.call();
            this.getLog().info((CharSequence)("Committed " + answer.getId() + " " + answer.getFullMessage()));
        }
        catch (GitAPIException e) {
            throw new MojoExecutionException("Failed to commit changes to help repository: " + (Object)((Object)e), (Exception)((Object)e));
        }
        if (this.pushChanges) {
            PushCommand push = git.push();
            try {
                push.setRemote(this.remoteRepoName).call();
                this.getLog().info((CharSequence)("Pushed commits upstream to " + this.getHelmGitUrl()));
            }
            catch (GitAPIException e) {
                throw new MojoExecutionException("Failed to push helm git changes to remote repository " + this.remoteRepoName + ": " + (Object)((Object)e), (Exception)((Object)e));
            }
        }
    }

    protected boolean isRootReactorBuild() {
        MavenProject parent;
        if (this.reactorProjects == null || this.reactorProjects.size() <= 1) {
            return true;
        }
        MavenProject project = this.getProject();
        return project != null && (parent = project.getParent()) != null && !HelmPushMojo.containsProject(this.reactorProjects, parent);
    }

    protected static boolean containsProject(List<MavenProject> projects, MavenProject actualProject) {
        for (MavenProject project : projects) {
            if (!HelmPushMojo.projectsEqual(project, actualProject)) continue;
            return true;
        }
        return false;
    }

    protected static boolean projectsEqual(MavenProject project1, MavenProject project2) {
        return Objects.equal((Object)project1.getGroupId(), (Object)project2.getGroupId()) && Objects.equal((Object)project1.getArtifactId(), (Object)project2.getArtifactId()) && Objects.equal((Object)project1.getVersion(), (Object)project2.getVersion());
    }
}

