/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven;

import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.maven.AbstractFabric8Mojo;
import io.fabric8.maven.helm.Chart;
import io.fabric8.utils.Files;
import io.fabric8.utils.Strings;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.model.Developer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;

@Mojo(name="helm", defaultPhase=LifecyclePhase.PACKAGE)
public class HelmMojo
extends AbstractFabric8Mojo {
    public static final String HELM_YAML_EXTENSION = ".yaml";
    public static final String PROPERTY_HELM_GIT_URL = "fabric8.helm.gitUrl";
    public static final String PROPERTY_HELM_CHART_NAME = "fabric8.helm.chart";
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter(property="fabric8.helm.gitUrl", defaultValue="git@github.com:fabric8io/charts.git")
    private String helmGitUrl;
    @Parameter(property="fabric8.yaml.target", defaultValue="${basedir}/target/classes/kubernetes.yml")
    private File kubernetesYaml;
    @Parameter(property="fabric8.helm.cloneDir")
    private File helmCloneDir;
    @Parameter(property="fabric8.helm.chart", defaultValue="${project.artifactId}")
    private String chartName;
    @Parameter(property="fabric8.helm.gitRemote", defaultValue="origin")
    protected String remoteRepoName;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File yaml = this.getKubernetesYaml();
        if (Files.isFile((File)yaml)) {
            this.getLog().info((CharSequence)("Creating Helm Chart for kubernetes yaml file: " + yaml));
            File outputDir = this.getOutputDir();
            if (outputDir != null) {
                File basedir;
                File manifestsDir = new File(outputDir, "manifests");
                if (Files.isDirectory((File)manifestsDir)) {
                    Files.recursiveDelete((File)manifestsDir);
                }
                manifestsDir.mkdirs();
                File outputYamlFile = new File(manifestsDir, this.chartName + HELM_YAML_EXTENSION);
                try {
                    Files.copy((File)yaml, (File)outputYamlFile);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Failed to copy file " + yaml + " to chart manifest file: " + outputYamlFile + ". Reason: " + e, (Exception)e);
                }
                File outputChartFile = new File(outputDir, "Chart.yaml");
                Chart chart = this.createChart();
                try {
                    KubernetesHelper.saveYaml((Object)chart, (File)outputChartFile);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Failed to save chart " + outputChartFile + ". Reason: " + e, (Exception)e);
                }
                MavenProject project = this.getProject();
                if (project != null && (basedir = project.getBasedir()) != null) {
                    String outputReadMeFileName = "README.md";
                    try {
                        HelmMojo.copyReadMe(basedir, outputDir, outputReadMeFileName);
                    }
                    catch (IOException e) {
                        throw new MojoExecutionException("Failed to save " + outputReadMeFileName + ". Reason: " + e, (Exception)e);
                    }
                }
                this.getLog().info((CharSequence)("Generated Helm Chart " + this.chartName + " at " + outputDir));
            }
        }
    }

    public String getHelmGitUrl() {
        return this.helmGitUrl;
    }

    protected Chart createChart() {
        Chart answer = new Chart();
        answer.setName(this.chartName);
        MavenProject project = this.getProject();
        if (project != null) {
            answer.setVersion(project.getVersion());
            answer.setDescription(project.getDescription());
            answer.setHome(project.getUrl());
            List developers = project.getDevelopers();
            if (developers != null) {
                ArrayList<String> maintainers = new ArrayList<String>();
                for (Developer developer : developers) {
                    String email = developer.getEmail();
                    String name = developer.getName();
                    String text = Strings.defaultIfEmpty((String)name, (String)"");
                    if (Strings.isNotBlank((String)email)) {
                        text = Strings.isNotBlank((String)text) ? text + " <" + email + ">" : email;
                    }
                    if (!Strings.isNotBlank((String)text)) continue;
                    maintainers.add(text);
                }
                answer.setMaintainers(maintainers);
            }
        }
        return answer;
    }

    protected File getOutputDir() throws MojoExecutionException {
        File helmRepoDir = this.getHelmRepoFolder();
        if (helmRepoDir == null) {
            return null;
        }
        if (Strings.isNullOrBlank((String)this.helmGitUrl)) {
            this.getLog().warn((CharSequence)"No git url so cannot clone a Helm repository. Please specify the `fabric8.helm.gitUrl` property");
        } else {
            this.cloneGitRepository(helmRepoDir, this.helmGitUrl);
        }
        if (Strings.isNullOrBlank((String)this.chartName)) {
            throw new MojoExecutionException("No Chart name defined! Please specify the `fabric8.helm.chart` property");
        }
        return new File(helmRepoDir, this.chartName);
    }

    protected File getHelmRepoFolder() {
        File rootProjectFolder;
        if (this.helmCloneDir == null && (rootProjectFolder = this.getRootProjectFolder()) != null) {
            this.helmCloneDir = new File(rootProjectFolder, "target/helm-repo");
        }
        return this.helmCloneDir;
    }

    protected void cloneGitRepository(File outputFolder, String gitUrl) {
        File gitFolder = new File(outputFolder, ".git");
        if (!Files.isDirectory((File)gitFolder)) {
            CloneCommand command = Git.cloneRepository();
            command = command.setURI(gitUrl).setDirectory(outputFolder).setRemote(this.remoteRepoName);
            try {
                Git git = command.call();
            }
            catch (Throwable e) {
                throw new RuntimeException("Failed to clone chart repo " + gitUrl + " due: " + e.getMessage());
            }
        }
    }

    public File getKubernetesYaml() {
        return this.kubernetesYaml;
    }
}

