/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven;

import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.ClientLoggableResource;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.maven.AbstractFabric8Mojo;
import io.fabric8.utils.Objects;
import io.fabric8.utils.Strings;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="delete-pods", defaultPhase=LifecyclePhase.COMPILE)
public class DeletePodsMojo
extends AbstractFabric8Mojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        List items;
        String dockerImage = this.getDockerImage();
        if (Strings.isNullOrBlank((String)dockerImage)) {
            this.getLog().error((CharSequence)"Cannot delete any pods as there is no docker image specified via the `docker.image` property");
            return;
        }
        KubernetesClient kubernetes = this.getKubernetes();
        PodList podList = (PodList)((ClientNonNamespaceOperation)kubernetes.pods().inNamespace(this.getNamespace())).list();
        int count = 0;
        if (podList != null && (items = podList.getItems()) != null) {
            for (Pod pod : items) {
                if (!this.podUsesDockerImage(pod, dockerImage)) continue;
                try {
                    ((ClientLoggableResource)((ClientNonNamespaceOperation)kubernetes.pods().inNamespace(this.getNamespace())).withName(KubernetesHelper.getName((HasMetadata)pod))).delete();
                    ++count;
                }
                catch (Exception e) {
                    this.getLog().error((CharSequence)("Failed to delete pod " + KubernetesHelper.getName((HasMetadata)pod) + " namespace: " + KubernetesHelper.getNamespace((HasMetadata)pod)));
                }
            }
        }
        if (count == 0) {
            this.getLog().info((CharSequence)("No pods found using image " + dockerImage + " in namespace: " + this.getNamespace() + " on address: " + kubernetes.getMasterUrl()));
        } else {
            this.getLog().info((CharSequence)("Deleted " + count + " pod(s) using image " + dockerImage + " in namespace: " + this.getNamespace() + " on address: " + kubernetes.getMasterUrl()));
        }
    }

    protected boolean podUsesDockerImage(Pod pod, String dockerImage) {
        List containers = KubernetesHelper.getContainers((Pod)pod);
        for (Container container : containers) {
            if (!Objects.equal((Object)dockerImage, (Object)container.getImage())) continue;
            return true;
        }
        return false;
    }
}

