/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven;

import io.fabric8.kubernetes.api.Controller;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.utils.Strings;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractNamespacedMojo
extends AbstractMojo {
    @Parameter(property="fabric8.namespace")
    private String namespace = KubernetesHelper.defaultNamespace();
    @Parameter(property="fabric8.domain", defaultValue="${env.KUBERNETES_DOMAIN}")
    protected String routeDomain;
    @Parameter(property="fabric8.apply.failOnError", defaultValue="true")
    protected boolean failOnError;
    @Parameter(property="fabric8.recreate", defaultValue="false")
    protected boolean recreate;
    private KubernetesClient kubernetes;

    public KubernetesClient getKubernetes() {
        return new DefaultKubernetesClient();
    }

    protected Controller createController() {
        Controller controller = new Controller(this.getKubernetes());
        controller.setThrowExceptionOnError(this.failOnError);
        controller.setRecreateMode(this.recreate);
        this.getLog().debug((CharSequence)("Using recreate mode: " + this.recreate));
        return controller;
    }

    protected synchronized String getNamespace() {
        if (Strings.isNullOrBlank((String)this.namespace)) {
            this.namespace = KubernetesHelper.defaultNamespace();
        }
        return this.namespace;
    }

    public String getRouteDomain() {
        return this.routeDomain;
    }

    public void setRouteDomain(String routeDomain) {
        this.routeDomain = routeDomain;
    }

    public boolean isRecreate() {
        return this.recreate;
    }

    public void setRecreate(boolean recreate) {
        this.recreate = recreate;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }
}

