/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.support;

import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public enum VolumeType {
    HOST_PATH("hostPath"){

        @Override
        public Volume fromProperties(String name, Properties properties) {
            String path = properties.getProperty(String.format(VolumeType.VOLUME_PROPERTY, name, this.getType()));
            return ((VolumeBuilder)((VolumeBuilder)new VolumeBuilder().withName(name)).withNewHostPath(path)).build();
        }
    }
    ,
    EMPTY_DIR("emptyDir"){

        @Override
        public Volume fromProperties(String name, Properties properties) {
            String medium = properties.getProperty(String.format(VolumeType.VOLUME_PROPERTY, name, this.getType()));
            return ((VolumeBuilder)((VolumeBuilder)new VolumeBuilder().withName(name)).withNewEmptyDir(medium)).build();
        }
    }
    ,
    GIT_REPO("gitRepo"){

        @Override
        public Volume fromProperties(String name, Properties properties) {
            String repository = properties.getProperty(String.format(VolumeType.VOLUME_PROPERTY, name, this.getType()));
            String revision = properties.getProperty(String.format(VolumeType.VOLUME_PROPERTY, name, VolumeType.VOLUME_GIT_REV));
            return ((VolumeBuilder)((VolumeFluent.GitRepoNested)((VolumeFluent.GitRepoNested)((VolumeBuilder)new VolumeBuilder().withName(name)).withNewGitRepo().withRepository(repository)).withRevision(revision)).endGitRepo()).build();
        }
    }
    ,
    SECRET("secret"){

        @Override
        public Volume fromProperties(String name, Properties properties) {
            String secretName = properties.getProperty(String.format(VolumeType.VOLUME_PROPERTY, name, VolumeType.VOLUME_SECRET_NAME));
            return ((VolumeBuilder)((VolumeBuilder)new VolumeBuilder().withName(name)).withNewSecret(secretName)).build();
        }
    }
    ,
    NFS_PATH("nfsPath"){

        @Override
        public Volume fromProperties(String name, Properties properties) {
            String path = properties.getProperty(String.format(VolumeType.VOLUME_PROPERTY, name, this.getType()));
            String server = properties.getProperty(String.format(VolumeType.VOLUME_PROPERTY, name, VolumeType.VOLUME_NFS_SERVER));
            Boolean readOnly = VolumeType.toBool(properties.getProperty(String.format(VolumeType.VOLUME_PROPERTY, name, VolumeType.READONLY)));
            return ((VolumeBuilder)((VolumeBuilder)new VolumeBuilder().withName(name)).withNewNfs(path, readOnly, server)).build();
        }
    }
    ,
    CGE_DISK("gcePdName"){

        @Override
        public Volume fromProperties(String name, Properties properties) {
            String pdName = properties.getProperty(String.format(VolumeType.VOLUME_PROPERTY, name, this.getType()));
            String fsType = properties.getProperty(String.format(VolumeType.VOLUME_PROPERTY, name, VolumeType.VOLUME_GCE_FS_TYPE));
            Integer partition = VolumeType.toInt(properties.getProperty(String.format(VolumeType.VOLUME_PROPERTY, name, VolumeType.VOLUME_GCE_FS_TYPE)));
            Boolean readOnly = VolumeType.toBool(properties.getProperty(String.format(VolumeType.VOLUME_PROPERTY, name, VolumeType.READONLY)));
            return ((VolumeBuilder)((VolumeBuilder)new VolumeBuilder().withName(name)).withNewGcePersistentDisk(fsType, partition, pdName, readOnly)).build();
        }
    }
    ,
    GLUSTER_FS_PATH("glusterFsPath"){

        @Override
        public Volume fromProperties(String name, Properties properties) {
            String path = properties.getProperty(String.format(VolumeType.VOLUME_PROPERTY, name, this.getType()));
            String endpoints = properties.getProperty(String.format(VolumeType.VOLUME_PROPERTY, name, VolumeType.VOLUME_GLUSTERFS_ENDPOINTS));
            Boolean readOnly = VolumeType.toBool(properties.getProperty(String.format(VolumeType.VOLUME_PROPERTY, name, VolumeType.READONLY)));
            return ((VolumeBuilder)((VolumeBuilder)new VolumeBuilder().withName(name)).withNewGlusterfs(path, endpoints, readOnly)).build();
        }
    }
    ,
    PERSISTENT_VOLUME_CLAIM("persistentVolumeClaim"){

        @Override
        public Volume fromProperties(String name, Properties properties) {
            String claimRef = properties.getProperty(String.format(VolumeType.VOLUME_PROPERTY, name, this.getType()));
            Boolean readOnly = VolumeType.toBool(properties.getProperty(String.format(VolumeType.VOLUME_PROPERTY, name, VolumeType.READONLY)));
            return ((VolumeBuilder)((VolumeBuilder)new VolumeBuilder().withName(name)).withNewPersistentVolumeClaim(claimRef, readOnly)).build();
        }
    };

    private final String type;
    private static final Map<String, VolumeType> VOLUME_TYPES;
    private static final String VOLUME_PREFIX = "fabric8.volume";
    private static final String VOLUME_NAME_PREFIX = "fabric8.volume.%s";
    public static final String VOLUME_PROPERTY = "fabric8.volume.%s.%s";
    private static final String VOLUME_GIT_REV = "revision";
    private static final String VOLUME_SECRET_NAME = "secret";
    private static final String VOLUME_NFS_SERVER = "nfsServer";
    private static final String VOLUME_GCE_FS_TYPE = "gceFsType";
    private static final String VOLUME_GLUSTERFS_ENDPOINTS = "endpoints";
    public static final String VOLUME_PVC_REQUEST_STORAGE = "requestStorage";
    private static final String READONLY = "readOnly";

    public abstract Volume fromProperties(String var1, Properties var2);

    private VolumeType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public static final VolumeType typeFor(String type) {
        return VOLUME_TYPES.get(type);
    }

    private static Boolean toBool(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof String) {
            return Boolean.parseBoolean((String)obj);
        }
        return false;
    }

    private static Integer toInt(Object obj) {
        if (obj == null) {
            return 0;
        }
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        if (obj instanceof String) {
            return Integer.parseInt((String)obj);
        }
        return 0;
    }

    static {
        VOLUME_TYPES = new HashMap<String, VolumeType>();
        for (VolumeType volumeType : VolumeType.values()) {
            VOLUME_TYPES.put(volumeType.getType(), volumeType);
        }
    }
}

