/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.support;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.fabric8.maven.support.JsonSchema;
import io.fabric8.maven.support.JsonSchemaProperty;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class JsonSchemas {
    public static final String ENVIRONMENT_SCHEMA_FILE = "io/fabric8/environment/schema.json";
    protected static ObjectMapper objectMapper = JsonSchemas.createObjectMapper();

    public static JsonSchema loadEnvironmentSchemas(ClassLoader classLoader, String ... folderPaths) throws IOException {
        JsonSchema answer = null;
        Enumeration<URL> resources = classLoader.getResources(ENVIRONMENT_SCHEMA_FILE);
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            JsonSchema schema = JsonSchemas.loadSchema(url);
            answer = JsonSchemas.combineSchemas(answer, schema);
        }
        for (String folderPath : folderPaths) {
            File file = new File(folderPath, ENVIRONMENT_SCHEMA_FILE);
            if (!file.isFile()) continue;
            JsonSchema schema = JsonSchemas.loadSchema(file);
            answer = JsonSchemas.combineSchemas(answer, schema);
        }
        return answer;
    }

    protected static JsonSchema combineSchemas(JsonSchema schema1, JsonSchema schema2) {
        if (schema1 == null) {
            return schema2;
        }
        if (schema2 != null) {
            Map<String, JsonSchemaProperty> properties2 = schema2.getProperties();
            Map<String, JsonSchemaProperty> properties1 = schema1.getProperties();
            if (properties2 != null) {
                if (properties1 == null) {
                    return schema2;
                }
                properties1.putAll(properties2);
            }
        }
        return schema1;
    }

    public static JsonSchema loadSchema(URL url) throws IOException {
        return (JsonSchema)objectMapper.reader(JsonSchema.class).readValue(url);
    }

    public static JsonSchema loadSchema(File file) throws IOException {
        return (JsonSchema)objectMapper.reader(JsonSchema.class).readValue(file);
    }

    public static JsonSchema loadSchema(InputStream inputStream) throws IOException {
        return (JsonSchema)objectMapper.reader(JsonSchema.class).readValue(inputStream);
    }

    public static JsonSchema loadSchema(byte[] data) throws IOException {
        return (JsonSchema)objectMapper.reader(JsonSchema.class).readValue(data);
    }

    protected static ObjectMapper createObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        return mapper;
    }

    public static void addEnvironmentVariables(JsonSchema schema, Map<String, String> environmentVariables) {
        Map<String, JsonSchemaProperty> properties = schema.getProperties();
        if (properties == null) {
            properties = new HashMap<String, JsonSchemaProperty>();
            schema.setProperties(properties);
        }
        Set<Map.Entry<String, String>> entries = environmentVariables.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            String name = entry.getKey();
            String value = entry.getValue();
            JsonSchemaProperty property = properties.get(name);
            if (property == null) {
                property = new JsonSchemaProperty();
                properties.put(name, property);
            }
            property.setDefaultValue(value);
        }
    }
}

