/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven;

import com.google.common.annotations.VisibleForTesting;
import io.fabric8.maven.AbstractFabric8Mojo;
import io.fabric8.maven.support.Apps;
import io.fabric8.utils.Files;
import io.fabric8.utils.Strings;
import java.io.Console;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import org.apache.maven.artifact.deployer.ArtifactDeployer;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.io.SettingsWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="deploy", defaultPhase=LifecyclePhase.INSTALL, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
@Execute(phase=LifecyclePhase.INSTALL)
public class DeployToWikiMojo
extends AbstractFabric8Mojo {
    private static final transient Logger LOG = LoggerFactory.getLogger(DeployToWikiMojo.class);
    public static final String DEFAULT_CONSOLE_URL = "http://dockerhost:8484/hawtio/";
    @Component
    Settings mavenSettings;
    @Parameter(defaultValue="${user.home}/.m2/settings.xml")
    private File mavenSettingsFile;
    @Component
    SettingsWriter mavenSettingsWriter;
    @Component
    ArtifactDeployer deployer;
    @Component
    protected ArtifactResolver resolver;
    @Parameter(property="localRepository", readonly=true, required=true)
    protected ArtifactRepository localRepository;
    @Parameter(property="project.remoteArtifactRepositories")
    protected List remoteRepositories;
    @Parameter(property="fabric8.serverId", defaultValue="fabric8.console")
    private String serverId;
    @Parameter(property="fabric8.consoleUrl", defaultValue="${env.FABRIC8_CONSOLE}", required=false)
    private String consoleUrl;
    @Parameter(property="fabric8.branch", defaultValue="master")
    private String branch;
    @Parameter(property="fabric8.deployPath", defaultValue="/")
    private String deployPath;
    @VisibleForTesting
    Server fabricServer;
    private boolean customUsernameAndPassword;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isIgnoreProject()) {
            return;
        }
        try {
            boolean newUserAdded = false;
            this.fabricServer = this.mavenSettings.getServer(this.serverId);
            if (Strings.isNullOrBlank((String)this.consoleUrl)) {
                this.consoleUrl = DEFAULT_CONSOLE_URL;
            }
            String jolokiaUsername = null;
            String jolokiaPassword = null;
            try {
                URL url = new URL(this.consoleUrl);
                String s = url.getUserInfo();
                if (Strings.isNotBlank((String)s) && s.indexOf(58) > 0) {
                    int idx = s.indexOf(58);
                    jolokiaUsername = s.substring(0, idx);
                    jolokiaPassword = s.substring(idx + 1);
                    this.customUsernameAndPassword = true;
                }
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Option consoleUrl is invalid due " + e.getMessage());
            }
            if (jolokiaUsername != null) {
                if (this.fabricServer == null) {
                    this.fabricServer = new Server();
                }
                this.getLog().info((CharSequence)("Using username: " + jolokiaUsername + " and password from provided consoleUrl option"));
                this.fabricServer.setUsername(jolokiaUsername);
                this.fabricServer.setPassword(jolokiaPassword);
            }
            if (this.fabricServer == null) {
                boolean create = false;
                if (this.mavenSettings.isInteractiveMode() && this.mavenSettingsWriter != null) {
                    block20: {
                        String value;
                        System.out.println("Maven settings file: " + this.mavenSettingsFile.getAbsolutePath());
                        System.out.println();
                        System.out.println();
                        System.out.println("There is no <server> section in your ~/.m2/settings.xml file for the server id: " + this.serverId);
                        System.out.println();
                        System.out.println("You can enter the username/password now and have the settings.xml updated or you can do this by hand if you prefer.");
                        System.out.println();
                        do {
                            if (!(value = this.readInput("Would you like to update the settings.xml file now? (y/n): ").toLowerCase()).startsWith("n")) continue;
                            System.out.println();
                            System.out.println();
                            break block20;
                        } while (!value.startsWith("y"));
                        create = true;
                    }
                    if (create) {
                        System.out.println("Please let us know the login details for this server: " + this.serverId);
                        System.out.println();
                        String userName = this.readInput("Username: ");
                        String password = this.readPassword("Password: ");
                        String password2 = this.readPassword("Repeat Password: ");
                        while (!password.equals(password2)) {
                            System.out.println("Passwords do not match, please try again.");
                            password = this.readPassword("Password: ");
                            password2 = this.readPassword("Repeat Password: ");
                        }
                        System.out.println();
                        this.fabricServer = new Server();
                        this.fabricServer.setId(this.serverId);
                        this.fabricServer.setUsername(userName);
                        this.fabricServer.setPassword(password);
                        this.mavenSettings.addServer(this.fabricServer);
                        if (this.mavenSettingsFile.exists()) {
                            File backupFile;
                            int counter = 1;
                            while ((backupFile = new File(this.mavenSettingsFile.getAbsolutePath() + ".backup-" + counter++ + ".xml")).exists()) {
                            }
                            System.out.println("Copied original: " + this.mavenSettingsFile.getAbsolutePath() + " to: " + backupFile.getAbsolutePath());
                            Files.copy((File)this.mavenSettingsFile, (File)backupFile);
                        }
                        HashMap config = new HashMap();
                        this.mavenSettingsWriter.write(this.mavenSettingsFile, config, this.mavenSettings);
                        System.out.println("Updated settings file: " + this.mavenSettingsFile.getAbsolutePath());
                        System.out.println();
                        newUserAdded = true;
                    }
                }
            }
            if (this.fabricServer == null) {
                String message = "No <server> element can be found in ~/.m2/settings.xml for the server <id>" + this.serverId + "</id> so we cannot connect to fabric8!\n\n" + "Please add the following to your ~/.m2/settings.xml file (using the correct user/password values):\n\n" + "<servers>\n" + "  <server>\n" + "    <id>" + this.serverId + "</id>\n" + "    <username>admin</username>\n" + "    <password>admin</password>\n" + "  </server>\n" + "</servers>\n";
                this.getLog().error((CharSequence)message);
                throw new MojoExecutionException(message);
            }
            if (!this.isIgnoreProject()) {
                this.uploadAppZip(newUserAdded);
            } else {
                this.getLog().info((CharSequence)"Ignoring this project so not uploading the App Zip");
            }
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error executing", e);
        }
    }

    protected String readInput(String prompt) {
        Console console = System.console();
        System.out.print(prompt);
        return console.readLine();
    }

    protected String readPassword(String prompt) {
        Console console = System.console();
        System.out.print(prompt);
        char[] pw = console.readPassword();
        return new String(pw);
    }

    protected void uploadAppZip(boolean newUserAdded) throws Exception {
        File file = this.getZipFile();
        if (!file.exists()) {
            this.getLog().error((CharSequence)("No App Zip file at " + file.getAbsolutePath() + ". Did you execute the fabric8:zip goal?"));
            return;
        }
        if (!file.isFile()) {
            this.getLog().error((CharSequence)("Invalid App Zip file at " + file.getAbsolutePath() + ". This should be a file not a directory!"));
            return;
        }
        String user = this.fabricServer.getUsername();
        String password = this.fabricServer.getPassword();
        if (Strings.isNullOrBlank((String)user)) {
            this.getLog().warn((CharSequence)("No <username> value defined for the server " + this.serverId + " in your ~/.m2/settings.xml. Please add a value!"));
        }
        if (Strings.isNullOrBlank((String)password)) {
            this.getLog().warn((CharSequence)("No <password> value defined for the server " + this.serverId + " in your ~/.m2/settings.xml. Please add a value!"));
        }
        Apps.postFileToGit(file, user, password, this.consoleUrl, this.branch, this.deployPath, LOG);
    }
}

