/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven;

import io.fabric8.maven.support.JsonSchema;
import io.fabric8.maven.support.JsonSchemas;
import io.fabric8.utils.Function;
import io.fabric8.utils.PropertiesHelper;
import io.fabric8.utils.Strings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class AbstractFabric8Mojo
extends AbstractMojo {
    @Parameter(property="fabric8.zip.file", defaultValue="${project.build.directory}/${project.artifactId}-${project.version}-app.zip")
    protected File zipFile;
    @Parameter(property="appConfigDir", defaultValue="${basedir}/src/main/fabric8")
    protected File appConfigDir;
    @Parameter(property="kubernetesJson", defaultValue="${basedir}/target/classes/kubernetes.json")
    private File kubernetesJson;
    @Parameter(property="kubernetesSourceJson", defaultValue="${basedir}/src/main/fabric8/kubernetes.json")
    protected File kubernetesSourceJson;
    @Component
    private MavenProject project;
    @Parameter(property="fabric8.replicas", defaultValue="1")
    private Integer replicas;
    @Parameter(property="fabric8.ignoreProject", defaultValue="false")
    private boolean ignoreProject;

    protected static URLClassLoader createURLClassLoader(Collection<URL> jars) {
        return new URLClassLoader(jars.toArray(new URL[jars.size()]));
    }

    public File getKubernetesJson() {
        return this.kubernetesJson;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public Integer getReplicas() {
        return this.replicas;
    }

    public boolean isIgnoreProject() {
        return this.ignoreProject;
    }

    public File getZipFile() {
        return this.zipFile;
    }

    protected boolean isPom(MavenProject reactorProject) {
        return "pom".equals(reactorProject.getPackaging());
    }

    protected InputStream loadPluginResource(String iconRef) throws MojoExecutionException {
        InputStream answer = Thread.currentThread().getContextClassLoader().getResourceAsStream(iconRef);
        if (answer == null) {
            answer = this.getTestClassLoader().getResourceAsStream(iconRef);
        }
        if (answer == null) {
            answer = ((Object)((Object)this)).getClass().getResourceAsStream(iconRef);
        }
        return answer;
    }

    protected URLClassLoader getCompileClassLoader() throws MojoExecutionException {
        try {
            List classpathElements = this.getProject().getCompileClasspathElements();
            return this.createClassLoader(classpathElements, this.getProject().getBuild().getOutputDirectory());
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to resolve classpath: " + e, e);
        }
    }

    protected URLClassLoader getTestClassLoader() throws MojoExecutionException {
        try {
            List classpathElements = this.getProject().getTestClasspathElements();
            return this.createClassLoader(classpathElements, this.getProject().getBuild().getTestOutputDirectory());
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to resolve classpath: " + e, e);
        }
    }

    protected URLClassLoader createClassLoader(List<String> classpathElements, String ... paths) throws MalformedURLException {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String path : paths) {
            URL url = this.pathToUrl(path);
            urls.add(url);
        }
        for (String object : classpathElements) {
            if (object == null) continue;
            String path = object.toString();
            URL url = this.pathToUrl(path);
            urls.add(url);
        }
        this.getLog().debug((CharSequence)("Creating class loader from: " + urls));
        return AbstractFabric8Mojo.createURLClassLoader(urls);
    }

    private URL pathToUrl(String path) throws MalformedURLException {
        File file = new File(path);
        return file.toURI().toURL();
    }

    protected boolean hasConfigDir() {
        return this.appConfigDir.isDirectory();
    }

    protected boolean isPomProject() {
        return this.isPom(this.getProject());
    }

    protected boolean shouldGenerateForThisProject() {
        return !this.isPomProject() || this.hasConfigDir();
    }

    public Map<String, String> getEnvironmentVariableProperties() {
        return PropertiesHelper.findPropertiesWithPrefix((Properties)this.getProject().getProperties(), (String)"fabric8.env.", (Function)Strings.toEnvironmentVariableFunction());
    }

    public JsonSchema getEnvironmentVariableJsonSchema() throws IOException, MojoExecutionException {
        JsonSchema schema = JsonSchemas.loadEnvironmentSchemas(this.getCompileClassLoader(), this.getProject().getBuild().getOutputDirectory());
        if (schema == null) {
            this.getLog().info((CharSequence)"No environment schemas found for file: io/fabric8/environment/schema.json");
            schema = new JsonSchema();
        }
        Map<String, String> envs = this.getEnvironmentVariableProperties();
        JsonSchemas.addEnvironmentVariables(schema, envs);
        return schema;
    }
}

