/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven;

import io.fabric8.kubernetes.api.Controller;
import io.fabric8.kubernetes.api.KubernetesClient;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.maven.AbstractFabric8Mojo;
import io.fabric8.utils.Files;
import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="run", defaultPhase=LifecyclePhase.INSTALL)
public class RunMojo
extends AbstractFabric8Mojo {
    private KubernetesClient kubernetes = new KubernetesClient();

    public void execute() throws MojoExecutionException, MojoFailureException {
        File json = this.getKubernetesJson();
        if (!Files.isFile((File)json)) {
            if (Files.isFile((File)this.kubernetesSourceJson)) {
                json = this.kubernetesSourceJson;
            } else {
                throw new MojoFailureException("No such generated kubernetes json file: " + json + " or source json file " + this.kubernetesSourceJson);
            }
        }
        KubernetesClient api = this.getKubernetes();
        this.getLog().info((CharSequence)("Deploying " + json + " to " + api.getAddress()));
        try {
            Object dto = KubernetesHelper.loadJson((File)json);
            if (dto == null) {
                throw new MojoFailureException("Could not load kubernetes json: " + json);
            }
            Controller controller = new Controller(this.kubernetes);
            controller.apply(dto, json.getName());
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    public KubernetesClient getKubernetes() {
        return this.kubernetes;
    }
}

