/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven;

import com.google.common.annotations.VisibleForTesting;
import io.fabric8.common.util.Files;
import io.fabric8.common.util.Strings;
import io.fabric8.deployer.ProjectDeployerImpl;
import io.fabric8.deployer.dto.DependencyDTO;
import io.fabric8.deployer.dto.DeployResults;
import io.fabric8.deployer.dto.DtoHelper;
import io.fabric8.deployer.dto.ProjectRequirements;
import io.fabric8.maven.AbstractProfileMojo;
import io.fabric8.utils.Base64Encoder;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.deployer.ArtifactDeployer;
import org.apache.maven.artifact.deployer.ArtifactDeploymentException;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.Authentication;
import org.apache.maven.artifact.repository.DefaultArtifactRepository;
import org.apache.maven.artifact.repository.MavenArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.io.SettingsWriter;
import org.jolokia.client.J4pClient;
import org.jolokia.client.exception.J4pConnectException;
import org.jolokia.client.exception.J4pException;
import org.jolokia.client.exception.J4pRemoteException;
import org.jolokia.client.request.J4pExecRequest;
import org.jolokia.client.request.J4pReadRequest;
import org.jolokia.client.request.J4pRequest;
import org.jolokia.client.request.J4pResponse;
import org.jolokia.client.request.J4pSearchRequest;
import org.jolokia.client.request.J4pSearchResponse;

@Mojo(name="deploy", defaultPhase=LifecyclePhase.INSTALL, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
@Execute(phase=LifecyclePhase.INSTALL)
public class DeployToProfileMojo
extends AbstractProfileMojo {
    @VisibleForTesting
    static final String PLACEHOLDER_PROJECT_GROUP_ID = "${project.groupId}";
    @VisibleForTesting
    static final String PLACEHOLDER_PROJECT_ARTIFACT_ID = "${project.artifactId}";
    @VisibleForTesting
    static final String PLACEHOLDER_PROJECT_VERSION = "${project.version}";
    public static String FABRIC_MBEAN = "io.fabric8:type=Fabric";
    @Component
    Settings mavenSettings;
    @Parameter(defaultValue="${user.home}/.m2/settings.xml")
    private File mavenSettingsFile;
    @Component
    SettingsWriter mavenSettingsWriter;
    @Component
    ArtifactDeployer deployer;
    @Parameter(property="fabric8.serverId", defaultValue="fabric8.upload.repo")
    private String serverId;
    @Parameter(property="fabric8.jolokiaUrl", defaultValue="http://localhost:8181/jolokia")
    private String jolokiaUrl;
    @Parameter(property="fabric8.upload", defaultValue="true")
    private boolean upload;
    @Parameter(property="retryFailedDeploymentCount", defaultValue="1")
    private int retryFailedDeploymentCount;
    @VisibleForTesting
    Server fabricServer;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            if (this.isIgnoreProject()) {
                return;
            }
            ProjectRequirements requirements = new ProjectRequirements();
            if (this.isIncludeArtifact()) {
                DependencyDTO rootDependency = this.loadRootDependency();
                requirements.setRootDependency(rootDependency);
            }
            this.configureRequirements(requirements);
            boolean newUserAdded = false;
            this.fabricServer = this.mavenSettings.getServer(this.serverId);
            if (this.fabricServer == null) {
                boolean create = false;
                if (this.mavenSettings.isInteractiveMode() && this.mavenSettingsWriter != null) {
                    block16: {
                        String value;
                        System.out.println("Maven settings file: " + this.mavenSettingsFile.getAbsolutePath());
                        System.out.println();
                        System.out.println();
                        System.out.println("There is no <server> section in your ~/.m2/settings.xml file for the server id: " + this.serverId);
                        System.out.println();
                        System.out.println("You can enter the username/password now and have the settings.xml updated or you can do this by hand if you prefer.");
                        System.out.println();
                        do {
                            if (!(value = this.readInput("Would you like to update the settings.xml file now? (y/n): ").toLowerCase()).startsWith("n")) continue;
                            System.out.println();
                            System.out.println();
                            break block16;
                        } while (!value.startsWith("y"));
                        create = true;
                    }
                    if (create) {
                        System.out.println("Please let us know the login details for this server: " + this.serverId);
                        System.out.println();
                        String userName = this.readInput("Username: ");
                        String password = this.readPassword("Password: ");
                        String password2 = this.readPassword("Repeat Password: ");
                        while (!password.equals(password2)) {
                            System.out.println("Passwords do not match, please try again.");
                            password = this.readPassword("Password: ");
                            password2 = this.readPassword("Repeat Password: ");
                        }
                        System.out.println();
                        this.fabricServer = new Server();
                        this.fabricServer.setId(this.serverId);
                        this.fabricServer.setUsername(userName);
                        this.fabricServer.setPassword(password);
                        this.mavenSettings.addServer(this.fabricServer);
                        if (this.mavenSettingsFile.exists()) {
                            File backupFile;
                            int counter = 1;
                            while ((backupFile = new File(this.mavenSettingsFile.getAbsolutePath() + ".backup-" + counter++ + ".xml")).exists()) {
                            }
                            System.out.println("Copied original: " + this.mavenSettingsFile.getAbsolutePath() + " to: " + backupFile.getAbsolutePath());
                            Files.copy((File)this.mavenSettingsFile, (File)backupFile);
                        }
                        HashMap config = new HashMap();
                        this.mavenSettingsWriter.write(this.mavenSettingsFile, config, this.mavenSettings);
                        System.out.println("Updated settings file: " + this.mavenSettingsFile.getAbsolutePath());
                        System.out.println();
                        newUserAdded = true;
                    }
                }
            }
            if (this.fabricServer == null) {
                String message = "No <server> element can be found in ~/.m2/settings.xml for the server <id>" + this.serverId + "</id> so we cannot connect to fabric8!\n\n" + "Please add the following to your ~/.m2/settings.xml file (using the correct user/password values):\n\n" + "<servers>\n" + "  <server>\n" + "    <id>" + this.serverId + "</id>\n" + "    <username>admin</username>\n" + "    <password>admin</password>\n" + "  </server>\n" + "</servers>\n";
                this.getLog().error((CharSequence)message);
                throw new MojoExecutionException(message);
            }
            J4pClient client = this.createJolokiaClient();
            if (this.upload && this.isIncludeArtifact()) {
                this.uploadDeploymentUnit(client, newUserAdded);
            } else {
                this.getLog().info((CharSequence)"Uploading to the fabric8 maven repository is disabled");
            }
            DeployResults results = this.uploadRequirements(client, requirements);
            if (results != null) {
                this.uploadReadMeFile(client, results);
                this.uploadProfileConfigurations(client, results);
                this.refreshProfile(client, results);
            }
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error executing", e);
        }
    }

    protected void uploadDeploymentUnit(J4pClient client, boolean newUserAdded) throws Exception {
        boolean isPomArtifact;
        String uri = this.getMavenUploadUri(client);
        Artifact artifact = this.project.getArtifact();
        ArtifactResolutionRequest request = new ArtifactResolutionRequest();
        request.setArtifact(artifact);
        this.addNeededRemoteRepository();
        request.setRemoteRepositories(this.remoteRepositories);
        request.setLocalRepository(this.localRepository);
        this.resolver.resolve(request);
        String packaging = this.project.getPackaging();
        File pomFile = this.project.getFile();
        List attachedArtifacts = this.project.getAttachedArtifacts();
        DefaultRepositoryLayout layout = new DefaultRepositoryLayout();
        DefaultArtifactRepository repo = new DefaultArtifactRepository(this.serverId, uri, (ArtifactRepositoryLayout)layout);
        if (newUserAdded) {
            repo.setAuthentication(new Authentication(this.fabricServer.getUsername(), this.fabricServer.getPassword()));
        }
        if (!(isPomArtifact = "pom".equals(packaging))) {
            ProjectArtifactMetadata metadata = new ProjectArtifactMetadata(artifact, pomFile);
            artifact.addMetadata((ArtifactMetadata)metadata);
        }
        try {
            if (isPomArtifact) {
                this.deploy(pomFile, artifact, (ArtifactRepository)repo, this.localRepository, this.retryFailedDeploymentCount);
            } else {
                File file = artifact.getFile();
                if (DeployToProfileMojo.isFile(pomFile)) {
                    this.deploy(pomFile, artifact, (ArtifactRepository)repo, this.localRepository, this.retryFailedDeploymentCount);
                }
                if (DeployToProfileMojo.isFile(file)) {
                    this.deploy(file, artifact, (ArtifactRepository)repo, this.localRepository, this.retryFailedDeploymentCount);
                } else if (!attachedArtifacts.isEmpty()) {
                    this.getLog().info((CharSequence)"No primary artifact to deploy, deploying attached artifacts instead.");
                    Artifact pomArtifact = this.artifactFactory.createProjectArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getBaseVersion());
                    pomArtifact.setFile(pomFile);
                    this.deploy(pomFile, pomArtifact, (ArtifactRepository)repo, this.localRepository, this.retryFailedDeploymentCount);
                    artifact.setResolvedVersion(pomArtifact.getVersion());
                } else {
                    String message = "The packaging for this project did not assign a file to the build artifact";
                    throw new MojoExecutionException(message);
                }
            }
            for (Artifact attached : attachedArtifacts) {
                this.deploy(attached.getFile(), attached, (ArtifactRepository)repo, this.localRepository, this.retryFailedDeploymentCount);
            }
        }
        catch (ArtifactDeploymentException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private void addNeededRemoteRepository() {
        boolean found = false;
        if (this.remoteRepositories != null) {
            for (Object obj : this.remoteRepositories) {
                ArtifactRepository repo;
                if (!(obj instanceof ArtifactRepository) || !(repo = (ArtifactRepository)obj).getUrl().contains("repository.jboss.org/nexus/content/groups/fs-public")) continue;
                found = true;
                this.getLog().debug((CharSequence)("Found existing (" + repo.getId() + ") remote repository: " + repo.getUrl()));
                break;
            }
        }
        if (!found) {
            MavenArtifactRepository fsPublic = new MavenArtifactRepository();
            fsPublic.setId("jboss-public-fs");
            fsPublic.setUrl("http://repository.jboss.org/nexus/content/groups/fs-public/");
            fsPublic.setLayout((ArtifactRepositoryLayout)new DefaultRepositoryLayout());
            fsPublic.setReleaseUpdatePolicy(new ArtifactRepositoryPolicy(true, "never", "warn"));
            fsPublic.setSnapshotUpdatePolicy(new ArtifactRepositoryPolicy(false, "never", "ignore"));
            if (this.remoteRepositories == null) {
                this.remoteRepositories = new ArrayList();
            }
            this.remoteRepositories.add(fsPublic);
            this.getLog().info((CharSequence)"Adding needed remote repository: http://repository.jboss.org/nexus/content/groups/fs-public/");
        }
    }

    protected void deploy(File source, Artifact artifact, ArtifactRepository deploymentRepository, ArtifactRepository localRepository, int retryFailedDeploymentCount) throws ArtifactDeploymentException {
        this.getLog().info((CharSequence)("Uploading file " + source));
        int retryFailedDeploymentCounter = Math.max(1, Math.min(10, retryFailedDeploymentCount));
        ArtifactDeploymentException exception = null;
        for (int count = 0; count < retryFailedDeploymentCounter; ++count) {
            try {
                if (count > 0) {
                    this.getLog().info((CharSequence)("Retrying deployment attempt " + (count + 1) + " of " + retryFailedDeploymentCounter));
                }
                this.deployer.deploy(source, artifact, deploymentRepository, localRepository);
                exception = null;
                break;
            }
            catch (ArtifactDeploymentException e) {
                if (count + 1 < retryFailedDeploymentCounter) {
                    this.getLog().warn((CharSequence)("Encountered issue during deployment: " + e.getLocalizedMessage()));
                    this.getLog().debug((Throwable)e);
                }
                if (exception != null) continue;
                exception = e;
                continue;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    protected String getMavenUploadUri(J4pClient client) throws MalformedObjectNameException, J4pException, MojoExecutionException {
        Throwable exception = null;
        try {
            J4pSearchResponse searchResponse = (J4pSearchResponse)client.execute((J4pRequest)new J4pSearchRequest(FABRIC_MBEAN));
            List mbeanNames = searchResponse.getMBeanNames();
            if (mbeanNames == null || mbeanNames.isEmpty()) {
                this.getLog().warn((CharSequence)("No MBean " + FABRIC_MBEAN + " found, are you sure you have created a fabric in this JVM?"));
                return null;
            }
            J4pResponse request = client.execute((J4pRequest)new J4pReadRequest(FABRIC_MBEAN, new String[]{"MavenRepoUploadURI"}));
            Object value = request.getValue();
            if (value != null) {
                String uri = value.toString();
                if (uri.startsWith("http")) {
                    return uri;
                }
                this.getLog().warn((CharSequence)("Could not find the Maven upload URI. Got: " + value));
            } else {
                this.getLog().warn((CharSequence)"Could not find the Maven upload URI");
            }
        }
        catch (J4pConnectException e) {
            String message = "Could not connect to jolokia on " + this.jolokiaUrl + " using user: " + this.fabricServer.getUsername() + ".\nAre you sure you are running a fabric8 container?";
            this.getLog().error((CharSequence)message);
            throw new MojoExecutionException(message, (Exception)((Object)e));
        }
        catch (J4pRemoteException e) {
            int status = e.getStatus();
            if (status == 401) {
                String message = "Unauthorized to access to: " + this.jolokiaUrl + " using user: " + this.fabricServer.getUsername() + ".\nHave you created a Fabric?\nHave you setup your ~/.m2/settings.xml with the correct user and password for server ID: " + this.serverId + " and do the user/password match the server " + this.jolokiaUrl + "?";
                this.getLog().error((CharSequence)message);
                throw new MojoExecutionException(message, (Exception)((Object)e));
            }
            exception = e;
        }
        catch (Exception e) {
            exception = e;
        }
        if (exception != null) {
            this.getLog().error((CharSequence)("Failed to get maven repository URI from " + this.jolokiaUrl + ". " + exception), exception);
            throw new MojoExecutionException("Could not find the Maven Upload Repository URI");
        }
        throw new MojoExecutionException("Could not find the Maven Upload Repository URI");
    }

    protected void uploadProfileConfigurations(J4pClient client, DeployResults results) throws Exception {
        if (this.profileConfigDir != null && this.profileConfigDir.exists()) {
            this.uploadProfileConfigDir(client, results, this.profileConfigDir, this.profileConfigDir);
        } else {
            this.getLog().info((CharSequence)("No profile configuration file directory " + this.profileConfigDir + " is defined in this project; so not importing any other configuration files into the profile."));
        }
    }

    protected void uploadReadMeFile(J4pClient client, DeployResults results) throws Exception {
        File[] files;
        File profileConfigReadme = null;
        if (this.profileConfigDir != null && (files = this.profileConfigDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase(Locale.ENGLISH).startsWith("readme.");
            }
        })) != null && files.length == 1) {
            profileConfigReadme = files[0];
        }
        if (profileConfigReadme != null || !this.includeReadMe) {
            return;
        }
        files = this.project.getBasedir().listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase(Locale.ENGLISH).startsWith("readme.");
            }
        });
        if (files != null && files.length == 1) {
            File rootConfigReadme = files[0];
            this.uploadProfileConfigFile(client, results, this.project.getBasedir(), rootConfigReadme);
        }
    }

    protected void uploadProfileConfigDir(J4pClient client, DeployResults results, File rootDir, File file) throws MojoExecutionException, J4pException, IOException, MalformedObjectNameException {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files != null) {
                for (File child : files) {
                    this.uploadProfileConfigDir(client, results, rootDir, child);
                }
            }
        } else if (file.isFile()) {
            this.uploadProfileConfigFile(client, results, rootDir, file);
        }
    }

    protected void uploadProfileConfigFile(J4pClient client, DeployResults results, File rootDir, File configFile) throws MojoExecutionException, J4pException, IOException, MalformedObjectNameException {
        String profileId = results.getProfileId();
        String versionId = results.getVersionId();
        if (Strings.isNullOrBlank((String)profileId)) {
            throw new MojoExecutionException("Cannot upload configuration file " + configFile + " to profile as the profileId was not returned");
        }
        if (Strings.isNullOrBlank((String)versionId)) {
            throw new MojoExecutionException("Cannot upload configuration file " + configFile + " to profile as the versionId was not returned");
        }
        String relativePath = Files.getRelativePath((File)rootDir, (File)configFile);
        if (relativePath.startsWith("/")) {
            relativePath = relativePath.substring(1);
        }
        relativePath = Files.normalizePath((String)relativePath, (char)'\\', (char)'/');
        String configFileContents = this.loadFilteredConfigFile(configFile);
        if (configFileContents == null) {
            this.getLog().debug((CharSequence)String.format("Filtered copy of the config file %s not found. Using the original file.", configFile));
            configFileContents = Files.toString((File)configFile);
        }
        String expandedConfig = this.expandPlaceholders(configFileContents);
        String data = Base64Encoder.encode((String)expandedConfig);
        String mbeanName = "io.fabric8:type=Fabric";
        this.getLog().info((CharSequence)("Uploading file " + relativePath + " to invoke mbean " + mbeanName + " on jolokia URL: " + this.jolokiaUrl + " with user: " + this.fabricServer.getUsername()));
        try {
            J4pExecRequest request = new J4pExecRequest(mbeanName, "setConfigurationFile", new Object[]{versionId, profileId, relativePath, data});
            J4pResponse response = client.execute((J4pRequest)request, "POST");
            Object value = response.getValue();
            if (value != null) {
                this.getLog().info((CharSequence)("Upload returned result: " + value));
            }
        }
        catch (J4pException e) {
            if (e.getMessage().contains(".InstanceNotFoundException")) {
                throw new MojoExecutionException("Could not find the mbean " + mbeanName + " in the JVM for " + this.jolokiaUrl + ". Are you sure this JVM is running the Fabric8 console?");
            }
            throw e;
        }
    }

    protected String loadFilteredConfigFile(File file) {
        File filteredPidFile = new File("target/classes/" + file.getName());
        try {
            if (filteredPidFile.exists()) {
                return Files.toString((File)filteredPidFile);
            }
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)String.format("Problems while loading filtered PID file %s. Skipping.", filteredPidFile));
        }
        return null;
    }

    protected String expandPlaceholders(String configToExpand) {
        this.getLog().debug((CharSequence)("Expanding placeholders in the configuration file: " + configToExpand));
        String expandedConfig = configToExpand.replace(PLACEHOLDER_PROJECT_GROUP_ID, this.project.getGroupId()).replace(PLACEHOLDER_PROJECT_ARTIFACT_ID, this.project.getArtifactId()).replace(PLACEHOLDER_PROJECT_VERSION, this.project.getVersion());
        this.getLog().debug((CharSequence)("Expanded configuration file: " + expandedConfig));
        return expandedConfig;
    }

    protected DeployResults uploadRequirements(J4pClient client, ProjectRequirements requirements) throws Exception {
        String json = DtoHelper.getMapper().writeValueAsString((Object)requirements);
        ObjectName mbeanName = ProjectDeployerImpl.OBJECT_NAME;
        this.getLog().info((CharSequence)("Updating " + (requirements.isAbstractProfile() ? "abstract " : "") + "profile: " + requirements.getProfileId() + " with parent profile(s): " + requirements.getParentProfiles()));
        this.getLog().info((CharSequence)("About to invoke mbean " + mbeanName + " on jolokia URL: " + this.jolokiaUrl + " with user: " + this.fabricServer.getUsername()));
        this.getLog().debug((CharSequence)("JSON: " + json));
        try {
            J4pExecRequest request = new J4pExecRequest(mbeanName, "deployProjectJson", new Object[]{json});
            J4pResponse response = client.execute((J4pRequest)request, "POST");
            Object value = response.getValue();
            if (value == null) {
                return null;
            }
            DeployResults answer = (DeployResults)DtoHelper.getMapper().reader(DeployResults.class).readValue(value.toString());
            if (answer != null) {
                String profileUrl = answer.getProfileUrl();
                if (profileUrl != null) {
                    this.getLog().info((CharSequence)"");
                    this.getLog().info((CharSequence)("Profile page: " + profileUrl));
                    this.getLog().info((CharSequence)"");
                } else {
                    this.getLog().info((CharSequence)("Result: " + answer));
                }
            } else {
                this.getLog().info((CharSequence)("Result: " + value));
            }
            return answer;
        }
        catch (J4pException e) {
            if (e.getMessage().contains(".InstanceNotFoundException")) {
                throw new MojoExecutionException("Could not find the mbean " + mbeanName + " in the JVM for " + this.jolokiaUrl + ". Are you sure this JVM is running the Fabric8 console?");
            }
            throw e;
        }
    }

    protected void refreshProfile(J4pClient client, DeployResults results) throws Exception {
        String profileId = results.getProfileId();
        String versionId = results.getVersionId();
        ObjectName mbeanName = new ObjectName(FABRIC_MBEAN);
        if (!Strings.isNullOrBlank((String)profileId) && !Strings.isNullOrBlank((String)versionId)) {
            this.getLog().info((CharSequence)("Performing profile refresh on mbean: " + mbeanName + " version: " + versionId + " profile: " + profileId));
            J4pExecRequest request = new J4pExecRequest(mbeanName, "refreshProfile", new Object[]{versionId, profileId});
            J4pResponse response = client.execute((J4pRequest)request, "POST");
            response.getValue();
        }
    }

    protected J4pClient createJolokiaClient() throws MojoExecutionException {
        String user = this.fabricServer.getUsername();
        String password = this.fabricServer.getPassword();
        if (Strings.isNullOrBlank((String)user)) {
            throw new MojoExecutionException("No <username> value defined for the server " + this.serverId + " in your ~/.m2/settings.xml. Please add a value!");
        }
        if (Strings.isNullOrBlank((String)password)) {
            throw new MojoExecutionException("No <password> value defined for the server " + this.serverId + " in your ~/.m2/settings.xml. Please add a value!");
        }
        return J4pClient.url((String)this.jolokiaUrl).user(user).password(password).build();
    }
}

