/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.common.util.Files;
import io.fabric8.common.util.Strings;
import io.fabric8.deployer.dto.DependencyDTO;
import io.fabric8.deployer.dto.DtoHelper;
import io.fabric8.deployer.dto.ProjectRequirements;
import io.fabric8.maven.AbstractProfileMojo;
import io.fabric8.maven.Zips;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilderException;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.MavenInvocationException;

@Mojo(name="zip", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
@Execute(phase=LifecyclePhase.PACKAGE)
public class CreateProfileZipMojo
extends AbstractProfileMojo {
    @Parameter(property="fabric8.zip.buildDir", defaultValue="${project.build.directory}/generated-profiles")
    private File buildDir;
    @Parameter(property="fabric8.zip.outFile", defaultValue="${project.build.directory}/profile.zip")
    private File outputFile;
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter(property="fabric8.zip.artifactType", defaultValue="zip")
    private String artifactType = "zip";
    @Parameter(property="fabric8.zip.artifactClassifier", defaultValue="profile")
    private String artifactClassifier = "profile";
    @Parameter(property="fabric8.excludedFiles", defaultValue="io.fabric8.agent.properties")
    private String[] filesToBeExcluded;
    @Parameter(defaultValue="${reactorProjects}")
    private List<MavenProject> reactorProjects;
    @Parameter(property="fabric8.fullzip.reactorProjectOutputPath", defaultValue="target/generated-profiles")
    private String reactorProjectOutputPath;
    protected MavenSession session;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            if (this.isIgnoreProject()) {
                return;
            }
            this.generateZip();
            if (this.reactorProjects != null) {
                boolean last;
                ArrayList<MavenProject> pomZipProjects = new ArrayList<MavenProject>();
                ArrayList<MavenProject> fabricZipGoalProjects = new ArrayList<MavenProject>();
                ArrayList<MavenProject> fabricHasParentZipGoalProject = new ArrayList<MavenProject>();
                for (MavenProject reactorProject : this.reactorProjects) {
                    if ("pom".equals(reactorProject.getPackaging())) {
                        pomZipProjects.add(reactorProject);
                    }
                    List buildPlugins = reactorProject.getBuildPlugins();
                    for (Plugin buildPlugin : buildPlugins) {
                        String artifactId = buildPlugin.getArtifactId();
                        if (!"fabric8-maven-plugin".equals(artifactId)) continue;
                        Object goals = buildPlugin.getGoals();
                        boolean hasZipGoal = goals != null && goals.toString().contains("zip");
                        List executions = buildPlugin.getExecutions();
                        for (PluginExecution execution : executions) {
                            List execGoals = execution.getGoals();
                            if (!execGoals.contains("zip")) continue;
                            hasZipGoal = true;
                        }
                        this.getLog().debug((CharSequence)("project " + reactorProject.getArtifactId() + " has zip goal: " + hasZipGoal));
                        fabricZipGoalProjects.add(reactorProject);
                    }
                }
                for (MavenProject project : fabricZipGoalProjects) {
                    if (!fabricZipGoalProjects.contains(project.getParent())) continue;
                    fabricHasParentZipGoalProject.add(project);
                }
                boolean bl = last = this.reactorProjects.size() > 1 && this.project == this.reactorProjects.get(this.reactorProjects.size() - 1);
                if (!last) {
                    boolean bl2 = last = fabricHasParentZipGoalProject.size() > 1 && this.project == fabricHasParentZipGoalProject.get(fabricHasParentZipGoalProject.size() - 1);
                }
                if (!last) {
                    boolean bl3 = last = fabricZipGoalProjects.size() > 1 && this.project == fabricZipGoalProjects.get(fabricZipGoalProjects.size() - 1);
                }
                if (last) {
                    this.getLog().info((CharSequence)"");
                    this.getLog().info((CharSequence)"Creating aggregated profile zip");
                    this.getLog().info((CharSequence)("built the last fabric8:zip project so generating a combined zip for all " + fabricZipGoalProjects.size() + " projects with a fabric8:zip goal"));
                    MavenProject rootProject = fabricZipGoalProjects.size() > 0 ? (MavenProject)fabricZipGoalProjects.get(0) : this.reactorProjects.get(0);
                    ArrayList<MavenProject> ourPomZipProjects = new ArrayList<MavenProject>();
                    if (pomZipProjects.contains(rootProject)) {
                        ourPomZipProjects.add(rootProject);
                    }
                    ourPomZipProjects.add(rootProject);
                    for (MavenProject zip : pomZipProjects) {
                        if (!this.hasParent(zip, rootProject, true)) continue;
                        ourPomZipProjects.add(zip);
                    }
                    this.getLog().info((CharSequence)("Choosing root project " + rootProject.getArtifactId() + " for generation of aggregated zip"));
                    this.generateAggregatedZip(rootProject, fabricZipGoalProjects, ourPomZipProjects);
                }
            }
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error executing", e);
        }
    }

    protected boolean hasParent(MavenProject me, MavenProject parent, boolean recusive) {
        if (me == null) {
            return false;
        }
        if (me.getParent() == parent) {
            return true;
        }
        if (recusive) {
            return this.hasParent(me.getParent(), parent, recusive);
        }
        return false;
    }

    protected void generateAggregatedZip(MavenProject rootProject, List<MavenProject> reactorProjects, List<MavenProject> pomZipProjects) throws IOException, MojoExecutionException {
        File projectBaseDir = rootProject.getBasedir();
        File projectOutputFile = new File(projectBaseDir, "target/profile.zip");
        this.getLog().info((CharSequence)("Generating " + projectOutputFile.getAbsolutePath() + " from root project " + rootProject.getArtifactId()));
        File projectBuildDir = new File(projectBaseDir, this.reactorProjectOutputPath);
        this.createAggregatedZip(reactorProjects, projectBaseDir, projectBuildDir, this.reactorProjectOutputPath, projectOutputFile, this.includeReadMe, pomZipProjects);
        if (rootProject.getAttachedArtifacts() != null) {
            Artifact found = null;
            for (Artifact artifact : rootProject.getAttachedArtifacts()) {
                if (this.artifactClassifier == null || !artifact.hasClassifier() || !artifact.getClassifier().equals(this.artifactClassifier)) continue;
                found = artifact;
                break;
            }
            if (found != null) {
                rootProject.getAttachedArtifacts().remove(found);
            }
        }
        this.getLog().info((CharSequence)("Attaching aggregated zip " + projectOutputFile + " to root project " + rootProject.getArtifactId()));
        this.projectHelper.attachArtifact(rootProject, this.artifactType, this.artifactClassifier, projectOutputFile);
        if (rootProject.hasLifecyclePhase("install")) {
            this.getLog().info((CharSequence)("Installing aggregated zip " + projectOutputFile));
            DefaultInvocationRequest request = new DefaultInvocationRequest();
            request.setBaseDirectory(rootProject.getBasedir());
            request.setPomFile(new File("./pom.xml"));
            request.setGoals(Collections.singletonList("install:install-file"));
            request.setRecursive(false);
            request.setInteractive(false);
            Properties props = new Properties();
            props.setProperty("file", "target/profile.zip");
            props.setProperty("groupId", rootProject.getGroupId());
            props.setProperty("artifactId", rootProject.getArtifactId());
            props.setProperty("version", rootProject.getVersion());
            props.setProperty("classifier", "profile");
            props.setProperty("packaging", "zip");
            request.setProperties(props);
            this.getLog().info((CharSequence)("Installing aggregated zip using: mvn install:install-file" + this.serializeMvnProperties(props)));
            DefaultInvoker invoker = new DefaultInvoker();
            try {
                InvocationResult result = invoker.execute((InvocationRequest)request);
                if (result.getExitCode() != 0) {
                    throw new IllegalStateException("Error invoking Maven goal install:install-file");
                }
            }
            catch (MavenInvocationException e) {
                throw new MojoExecutionException("Error invoking Maven goal install:install-file", (Exception)((Object)e));
            }
        }
    }

    protected void generateZip() throws DependencyTreeBuilderException, MojoExecutionException, IOException {
        ProjectRequirements requirements = new ProjectRequirements();
        DependencyDTO rootDependency = null;
        if (this.isIncludeArtifact()) {
            rootDependency = this.loadRootDependency();
            requirements.setRootDependency(rootDependency);
        }
        this.configureRequirements(requirements);
        if (this.isIncludeArtifact()) {
            this.addProjectArtifactBundle(requirements);
        }
        File profileBuildDir = this.createProfileBuildDir(requirements.getProfileId());
        boolean hasConfigDir = this.profileConfigDir.isDirectory();
        if (hasConfigDir) {
            this.copyProfileConfigFiles(profileBuildDir, this.profileConfigDir);
        } else {
            this.getLog().info((CharSequence)("The profile configuration files directory " + this.profileConfigDir + " doesn't exist, so not copying any additional project documentation or configuration files"));
        }
        if (hasConfigDir || rootDependency != null || CreateProfileZipMojo.notEmpty(requirements.getBundles()) || CreateProfileZipMojo.notEmpty(requirements.getFeatures()) || CreateProfileZipMojo.notEmpty(requirements.getFeatureRepositories())) {
            String description;
            if (this.includeReadMe) {
                CreateProfileZipMojo.copyReadMe(this.project.getFile().getParentFile(), profileBuildDir);
            }
            if (this.generateSummaryFile && Strings.isNotBlank((String)(description = this.project.getDescription()))) {
                File summaryMd = new File(profileBuildDir, "Summary.md");
                summaryMd.getParentFile().mkdirs();
                if (!summaryMd.exists()) {
                    byte[] bytes = description.getBytes();
                    Files.copy((InputStream)new ByteArrayInputStream(bytes), (OutputStream)new FileOutputStream(summaryMd));
                }
            }
            if (this.isIncludeArtifact()) {
                this.writeProfileRequirements(requirements, profileBuildDir);
            }
            this.generateFabricAgentProperties(requirements, new File(profileBuildDir, "io.fabric8.agent.properties"));
            if ("war".equals(this.project.getPackaging())) {
                this.generateFabricContextPathProperties(requirements, new File(profileBuildDir, "io.fabric8.web.contextPath.properties"));
            }
            Zips.createZipFile(this.getLog(), this.buildDir, this.outputFile);
            this.projectHelper.attachArtifact(this.project, this.artifactType, this.artifactClassifier, this.outputFile);
            this.getLog().info((CharSequence)("Created profile zip file: " + this.outputFile));
        }
    }

    public static boolean notEmpty(List<?> list) {
        return list != null && !list.isEmpty();
    }

    protected void copyProfileConfigFiles(File profileBuildDir, File profileConfigDir) throws IOException {
        File[] files = profileConfigDir.listFiles();
        if (files != null) {
            profileBuildDir.mkdirs();
            for (File file : files) {
                if (this.toBeExclude(file.getName())) continue;
                File outFile = new File(profileBuildDir, file.getName());
                if (file.isDirectory()) {
                    this.copyProfileConfigFiles(outFile, file);
                    continue;
                }
                Files.copy((File)file, (File)outFile);
            }
        }
    }

    protected ArrayList<String> removePath(List<String> filesToBeExcluded) {
        ArrayList<String> fileName = new ArrayList<String>();
        for (String name : filesToBeExcluded) {
            int pos = name.lastIndexOf("/");
            if (pos <= 0) continue;
            String fname = name.substring(0, pos);
            fileName.add(fname);
        }
        return fileName;
    }

    protected boolean toBeExclude(String fileName) {
        List<String> excludedFilesList = Arrays.asList(this.filesToBeExcluded);
        Boolean result = excludedFilesList.contains(fileName);
        return result;
    }

    protected File createProfileBuildDir(String profileId) {
        String profilePath = profileId.replace('-', '/') + ".profile";
        return new File(this.buildDir, profilePath);
    }

    protected void writeProfileRequirements(ProjectRequirements requirements, File profileBuildDir) throws IOException {
        ObjectMapper mapper = DtoHelper.getMapper();
        String name = DtoHelper.getRequirementsConfigFileName((ProjectRequirements)requirements);
        File outFile = new File(profileBuildDir, name);
        outFile.getParentFile().mkdirs();
        mapper.writeValue(outFile, (Object)requirements);
        this.getLog().info((CharSequence)("Writing " + outFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateFabricAgentProperties(ProjectRequirements requirements, File file) throws MojoExecutionException, IOException {
        file.getParentFile().mkdirs();
        PrintWriter writer = new PrintWriter(new FileWriter(file));
        try {
            String profileId = requirements.getProfileId();
            writer.println("# Profile: " + profileId);
            writer.println("# generated by the fabric8 maven plugin at " + new Date());
            writer.println("# see: http://fabric8.io/gitbook/mavenPlugin.html");
            writer.println();
            List<String> parentProfiles = Zips.notNullList(requirements.getParentProfiles());
            if (!parentProfiles.isEmpty()) {
                writer.write("attribute.parents =");
                for (String parentProfile : parentProfiles) {
                    writer.write(" ");
                    writer.write(parentProfile);
                }
                writer.println();
                writer.println();
            }
            List<String> bundles = Zips.notNullList(requirements.getBundles());
            List<String> features = Zips.notNullList(requirements.getFeatures());
            List<String> repos = Zips.notNullList(requirements.getFeatureRepositories());
            for (String bundle : bundles) {
                if (!Strings.isNotBlank((String)bundle)) continue;
                writer.println("bundle." + this.escapeAgentPropertiesKey(bundle) + " = " + this.escapeAgentPropertiesValue(bundle));
            }
            if (!bundles.isEmpty()) {
                writer.println();
            }
            for (String feature : features) {
                if (!Strings.isNotBlank((String)feature)) continue;
                writer.println("feature." + this.escapeAgentPropertiesKey(feature) + " = " + this.escapeAgentPropertiesValue(feature));
            }
            if (!features.isEmpty()) {
                writer.println();
            }
            for (String repo : repos) {
                if (!Strings.isNotBlank((String)repo)) continue;
                writer.println("repository." + this.escapeAgentPropertiesKey(repo) + " = " + this.escapeAgentPropertiesValue(repo));
            }
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateFabricContextPathProperties(ProjectRequirements requirements, File file) throws MojoExecutionException, IOException {
        String webContextPath = requirements.getWebContextPath();
        if (Strings.isNullOrBlank((String)webContextPath)) {
            return;
        }
        file.getParentFile().mkdirs();
        PrintWriter writer = new PrintWriter(new FileWriter(file));
        try {
            String path = CreateProfileZipMojo.leadingSlash(webContextPath);
            String key = this.project.getGroupId() + "/" + this.project.getArtifactId();
            writer.println(this.escapeAgentPropertiesKey(key) + " = " + this.escapeAgentPropertiesValue(path));
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception e) {}
        }
    }

    protected String escapeAgentPropertiesKey(String text) {
        return text.replaceAll("\\:", "\\\\:");
    }

    protected String escapeAgentPropertiesValue(String text) {
        return this.escapeAgentPropertiesKey(text);
    }

    protected static String leadingSlash(String path) {
        if (path.startsWith("/")) {
            return path;
        }
        return "/" + path;
    }

    private String serializeMvnProperties(Properties properties) {
        StringBuilder sb = new StringBuilder();
        if (properties != null) {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                sb.append(" -D").append(key).append('=').append(value);
            }
        }
        return sb.toString();
    }
}

