/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.devops;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.utils.Maps;
import io.fabric8.utils.Strings;
import java.util.Map;
import java.util.TreeMap;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class ProjectConfig {
    private String flow;
    private String chatRoom;
    private String issueProjectName;
    private String buildName;
    private Boolean codeReview;
    private Map<String, String> links;
    private Map<String, String> buildParameters;
    private Map<String, String> environments;
    private Boolean useLocalFlow;

    public String toString() {
        return "ProjectConfig{flow=" + this.flow + ", chatRoom='" + this.chatRoom + '\'' + ", buildName='" + this.buildName + '\'' + ", issueProjectName='" + this.issueProjectName + '\'' + '}';
    }

    public void addLink(String name, String url) {
        if (this.links == null) {
            this.links = new TreeMap<String, String>();
        }
        this.links.put(name, url);
    }

    @JsonIgnore
    public boolean isEmpty() {
        return this.codeReview == null && Strings.isNullOrBlank((String)this.chatRoom) && Strings.isNullOrBlank((String)this.issueProjectName) && Strings.isNullOrBlank((String)this.flow) && Maps.isNullOrEmpty(this.buildParameters) && Maps.isNullOrEmpty(this.environments) && this.useLocalFlow != null;
    }

    public String getChatRoom() {
        return this.chatRoom;
    }

    public void setChatRoom(String chatRoom) {
        this.chatRoom = chatRoom;
    }

    public Boolean getCodeReview() {
        return this.codeReview;
    }

    public void setCodeReview(Boolean codeReview) {
        this.codeReview = codeReview;
    }

    public String getFlow() {
        return this.flow;
    }

    public void setFlow(String flow) {
        this.flow = flow;
    }

    public String getIssueProjectName() {
        return this.issueProjectName;
    }

    public void setIssueProjectName(String issueProjectName) {
        this.issueProjectName = issueProjectName;
    }

    public Map<String, String> getLinks() {
        return this.links;
    }

    public void setLinks(Map<String, String> links) {
        this.links = links;
    }

    public String getBuildName() {
        return this.buildName;
    }

    public void setBuildName(String buildName) {
        this.buildName = buildName;
    }

    public Map<String, String> getBuildParameters() {
        return this.buildParameters;
    }

    public void setBuildParameters(Map<String, String> buildParameters) {
        this.buildParameters = buildParameters;
    }

    public Map<String, String> getEnvironments() {
        return this.environments;
    }

    public void setEnvironments(Map<String, String> environments) {
        this.environments = environments;
    }

    public void setUseLocalFlow(Boolean useLocalFlow) {
        this.useLocalFlow = useLocalFlow;
    }

    public Boolean getUseLocalFlow() {
        return this.useLocalFlow;
    }

    public boolean isUseLocalFlow() {
        return this.useLocalFlow != null && this.useLocalFlow != false;
    }
}

