/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.devops.connector;

import io.fabric8.devops.ProjectConfig;
import io.fabric8.devops.ProjectConfigs;
import io.fabric8.devops.ProjectRepositories;
import io.fabric8.devops.connector.WebHooks;
import io.fabric8.kubernetes.api.Controller;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.builders.ListEnvVarBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.letschat.LetsChatClient;
import io.fabric8.letschat.LetsChatKubernetes;
import io.fabric8.letschat.RoomDTO;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildConfigBuilder;
import io.fabric8.openshift.api.model.BuildConfigFluent;
import io.fabric8.openshift.api.model.BuildConfigSpecFluent;
import io.fabric8.openshift.api.model.BuildSourceFluent;
import io.fabric8.openshift.api.model.BuildStrategyFluent;
import io.fabric8.openshift.api.model.BuildTriggerPolicyFluent;
import io.fabric8.openshift.api.model.CustomBuildStrategyFluent;
import io.fabric8.openshift.api.model.EditableBuildConfig;
import io.fabric8.repo.git.GitRepoClient;
import io.fabric8.repo.git.GitRepoKubernetes;
import io.fabric8.taiga.ModuleDTO;
import io.fabric8.taiga.ProjectDTO;
import io.fabric8.taiga.TaigaClient;
import io.fabric8.taiga.TaigaKubernetes;
import io.fabric8.taiga.TaigaModule;
import io.fabric8.utils.DomHelper;
import io.fabric8.utils.GitHelpers;
import io.fabric8.utils.IOHelpers;
import io.fabric8.utils.Strings;
import io.fabric8.utils.Systems;
import io.fabric8.utils.URLUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class DevOpsConnector {
    private transient Logger log = LoggerFactory.getLogger(DevOpsConnector.class);
    private File basedir;
    private ProjectConfig projectConfig;
    private String username;
    private String password;
    private String branch;
    private String repoName;
    private String fullName;
    private String gitUrl;
    private String secret = "secret101";
    private String buildImageStream = "triggerJenkins";
    private String buildImageTag = "latest";
    private String s2iCustomBuilderImage = "fabric8/openshift-s2i-jenkins-trigger";
    private String jenkinsJob;
    private boolean triggerJenkinsJob = true;
    private String jenkinsMonitorView;
    private String jenkinsPipelineView;
    private String taigaProjectName;
    private String taigaProjectSlug;
    private String taigaProjectLinkPage = "backlog";
    private String taigaProjectLinkLabel = "Backlog";
    private String issueTrackerUrl;
    private String issueTrackerLabel = "Issues";
    private String teamUrl;
    private String teamLabel = "Team";
    private String releasesUrl;
    private String releasesLabel = "Releases";
    private String repositoryBrowseLink;
    private String repositoryBrowseLabel = "Repository";
    private String taigaTeamLinkPage = "team";
    private String taigaTeamLinkLabel = "Team";
    private boolean taigaAutoCreate = true;
    private boolean taigaEnabled = true;
    private boolean letschatEnabled = true;
    private String letschatRoomLinkLabel = "Room";
    private String letschatRoomExpression = "fabric8_${namespace}";
    private String flowGitUrl = Systems.getEnvVar((String)"JENKINS_WORKFLOW_GIT_REPOSITORY", (String)"https://github.com/fabric8io/jenkins-workflow-library.git");
    private boolean recreateMode;
    private String namespace = KubernetesHelper.defaultNamespace();
    private String fabric8ConsoleNamespace = KubernetesHelper.defaultNamespace();
    private String jenkinsNamespace = KubernetesHelper.defaultNamespace();
    private boolean tryLoadConfigFileFromRemoteGit = true;
    private boolean modifiedConfig;
    private boolean registerWebHooks;
    private GitRepoClient gitRepoClient;
    private KubernetesClient kubernetes;
    private String jenkinsJobUrl;
    private ProjectDTO taigaProject;
    private TaigaClient taiga;

    public String toString() {
        return "DevOpsConnector{gitUrl='" + this.gitUrl + '\'' + ", basedir=" + this.basedir + ", username='" + this.username + '\'' + ", branch='" + this.branch + '\'' + ", repoName='" + this.repoName + '\'' + '}';
    }

    public void execute() throws Exception {
        Map environments;
        this.loadConfigFile();
        KubernetesClient kubernetes = this.getKubernetes();
        String name = null;
        if (this.projectConfig != null) {
            name = this.projectConfig.getBuildName();
        }
        if (Strings.isNullOrBlank(name)) {
            name = this.jenkinsJob;
        }
        if (Strings.isNullOrBlank((String)name)) {
            name = ProjectRepositories.createBuildName((String)this.username, (String)this.repoName);
            if (this.projectConfig != null) {
                this.projectConfig.setBuildName(name);
            }
        }
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("user", this.username);
        labels.put("repo", this.repoName);
        this.taiga = null;
        this.taigaProject = null;
        try {
            this.taiga = this.createTaiga();
            this.taigaProject = this.createTaigaProject(this.taiga);
        }
        catch (Exception e) {
            this.getLog().error("Failed to load or lazily create the Taiga project: " + e, (Throwable)e);
        }
        LetsChatClient letschat = null;
        try {
            letschat = this.createLetsChat();
        }
        catch (Exception e) {
            this.getLog().error("Failed to load or lazily create the LetsChat client: " + e, (Throwable)e);
        }
        HashMap<String, String> annotations = new HashMap<String, String>();
        this.jenkinsJobUrl = null;
        String jenkinsUrl = null;
        try {
            jenkinsUrl = this.getJenkinsServiceUrl();
            if (Strings.isNotBlank((String)jenkinsUrl)) {
                String url;
                if (Strings.isNotBlank((String)this.jenkinsMonitorView)) {
                    url = URLUtils.pathJoin((String[])new String[]{jenkinsUrl, "/view", this.jenkinsMonitorView});
                    this.annotationLink(annotations, "fabric8.link.jenkins.monitor/", url, "Monitor");
                }
                if (Strings.isNotBlank((String)this.jenkinsPipelineView)) {
                    url = URLUtils.pathJoin((String[])new String[]{jenkinsUrl, "/view", this.jenkinsPipelineView});
                    this.annotationLink(annotations, "fabric8.link.jenkins.pipeline/", url, "Pipeline");
                }
                if (Strings.isNotBlank((String)name)) {
                    this.jenkinsJobUrl = URLUtils.pathJoin((String[])new String[]{jenkinsUrl, "/job", name});
                    this.annotationLink(annotations, "fabric8.link.jenkins.job/", this.jenkinsJobUrl, "Job");
                }
            }
        }
        catch (Exception e) {
            this.getLog().warn("Could not find the Jenkins URL!: " + e, (Throwable)e);
        }
        if (!this.annotationLink(annotations, "fabric8.link.issues/", this.issueTrackerUrl, this.issueTrackerLabel)) {
            String taigaLink = this.getProjectPageLink(this.taiga, this.taigaProject, this.taigaProjectLinkPage);
            this.annotationLink(annotations, "fabric8.link.taiga/", taigaLink, this.taigaProjectLinkLabel);
        }
        if (!this.annotationLink(annotations, "fabric8.link.team/", this.teamUrl, this.teamLabel)) {
            String taigaTeamLink = this.getProjectPageLink(this.taiga, this.taigaProject, this.taigaTeamLinkPage);
            this.annotationLink(annotations, "fabric8.link.taiga.team/", taigaTeamLink, this.taigaTeamLinkLabel);
        }
        this.annotationLink(annotations, "fabric8.link.releases/", this.releasesUrl, this.releasesLabel);
        String chatRoomLink = this.getChatRoomLink(letschat);
        this.annotationLink(annotations, "fabric8.link.letschat.room/", chatRoomLink, this.letschatRoomLinkLabel);
        this.annotationLink(annotations, "fabric8.link.repository.browse/", this.repositoryBrowseLink, this.repositoryBrowseLabel);
        ProjectConfigs.defaultEnvironments((ProjectConfig)this.projectConfig);
        String consoleUrl = this.getServiceUrl("fabric8", this.namespace, this.fabric8ConsoleNamespace);
        if (Strings.isNotBlank((String)consoleUrl) && this.projectConfig != null && (environments = this.projectConfig.getEnvironments()) != null) {
            for (Map.Entry entry : environments.entrySet()) {
                String value;
                String label = (String)entry.getKey();
                String key = value = (String)entry.getValue();
                String environmentLink = URLUtils.pathJoin((String[])new String[]{consoleUrl, "/kubernetes/pods?namespace=" + value});
                annotations.put("fabric8.link.environment." + key + "/url", environmentLink);
                annotations.put("fabric8.link.environment." + key + "/label", label);
                this.addLink(label, environmentLink);
            }
        }
        BuildConfigFluent.SpecNested specBuilder = ((BuildConfigBuilder)((BuildConfigFluent.MetadataNested)((BuildConfigFluent.MetadataNested)((BuildConfigFluent.MetadataNested)new BuildConfigBuilder().withNewMetadata().withName(name)).withLabels(labels)).withAnnotations(annotations)).endMetadata()).withNewSpec();
        if (Strings.isNotBlank((String)this.gitUrl)) {
            specBuilder = (BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.SourceNested)((BuildSourceFluent.GitNested)((BuildConfigSpecFluent.SourceNested)specBuilder.withNewSource().withType("Git")).withNewGit().withUri(this.gitUrl)).endGit()).endSource();
        }
        if (Strings.isNotBlank((String)this.buildImageStream) && Strings.isNotBlank((String)this.buildImageTag)) {
            ListEnvVarBuilder envBuilder = new ListEnvVarBuilder();
            envBuilder.withEnvVar("BASE_URI", jenkinsUrl);
            envBuilder.withEnvVar("JOB_NAME", name);
            specBuilder = (BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.StrategyNested)((BuildStrategyFluent.CustomStrategyNested)((BuildStrategyFluent.CustomStrategyNested)((CustomBuildStrategyFluent.FromNested)((CustomBuildStrategyFluent.FromNested)((BuildConfigSpecFluent.StrategyNested)specBuilder.withNewStrategy().withType("Custom")).withNewCustomStrategy().withNewFrom().withKind("DockerImage")).withName(this.s2iCustomBuilderImage)).endFrom()).withEnv(envBuilder.build())).endCustomStrategy()).endStrategy();
        }
        EditableBuildConfig buildConfig = ((BuildConfigBuilder)((BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.TriggersNested)((BuildTriggerPolicyFluent.GenericNested)((BuildConfigSpecFluent.TriggersNested)((BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.TriggersNested)((BuildTriggerPolicyFluent.GithubNested)((BuildConfigSpecFluent.TriggersNested)specBuilder.addNewTrigger().withType("GitHub")).withNewGithub().withSecret(this.secret)).endGithub()).endTrigger()).addNewTrigger().withType("Generic")).withNewGeneric().withSecret(this.secret)).endGeneric()).endTrigger()).endSpec()).build();
        Controller controller = this.createController();
        try {
            this.getLog().info("About to apply build config: " + new JSONObject(KubernetesHelper.toJson((Object)buildConfig)).toString(4));
            controller.applyBuildConfig((BuildConfig)buildConfig, "maven");
            this.getLog().info("Created build configuration for " + name + " in namespace: " + controller.getNamespace() + " at " + kubernetes.getMasterUrl());
        }
        catch (Exception e) {
            this.getLog().error("Failed to create BuildConfig for " + KubernetesHelper.toJson((Object)buildConfig) + ". " + e, (Throwable)e);
        }
        if (Strings.isNotBlank((String)name)) {
            this.createJenkinsJob(name, this.jenkinsJobUrl);
        }
        if (this.isRegisterWebHooks()) {
            this.registerWebHooks();
        }
        if (this.modifiedConfig) {
            if (this.basedir == null) {
                this.getLog().error("Could not save updated fabric8.yml due to missing basedir");
            } else {
                try {
                    ProjectConfigs.saveToFolder((File)this.basedir, (ProjectConfig)this.projectConfig, (boolean)true);
                    this.getLog().info("Updated fabric8.yml");
                }
                catch (IOException e) {
                    this.getLog().error("Could not save updated fabric8.yml: " + e, (Throwable)e);
                }
            }
        }
    }

    protected String getJenkinsServiceUrl() {
        return this.getServiceUrl("jenkins", this.namespace, this.jenkinsNamespace);
    }

    protected String getServiceUrl(String serviceName, String ... namespaces) {
        return this.getServiceUrl(serviceName, true, namespaces);
    }

    private String getServiceUrl(String serviceName, boolean serviceExternal, String ... namespaces) {
        ArrayList<String> namespaceList = new ArrayList<String>(Arrays.asList(namespaces));
        String[] defaults = new String[]{KubernetesHelper.defaultNamespace(), "default"};
        for (String defaultNamespace : defaults) {
            if (!namespaceList.contains(defaultNamespace)) continue;
            namespaceList.add(defaultNamespace);
        }
        for (String namespace : namespaceList) {
            try {
                return KubernetesHelper.getServiceURL((KubernetesClient)this.getKubernetes(), (String)serviceName, (String)namespace, (String)"http", (boolean)serviceExternal);
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    protected boolean annotationLink(Map<String, String> annotations, String annotationPrefix, String issueTrackerUrl, String issueTrackerLabel) {
        if (Strings.isNotBlank((String)issueTrackerUrl)) {
            annotations.put(annotationPrefix + "url", issueTrackerUrl);
            annotations.put(annotationPrefix + "label", issueTrackerLabel);
            this.addLink(issueTrackerLabel, issueTrackerUrl);
            return true;
        }
        return false;
    }

    public void registerWebHooks() {
        if (Strings.isNotBlank((String)this.jenkinsJobUrl)) {
            this.createJenkinsWebhook(this.jenkinsJobUrl);
        }
        if (this.taiga != null && this.taigaProject != null) {
            this.createTaigaWebhook(this.taiga, this.taigaProject);
        }
    }

    public void addLink(String label, String url) {
        if (this.projectConfig == null) {
            this.projectConfig = new ProjectConfig();
        }
        this.projectConfig.addLink(label, url);
        this.modifiedConfig = true;
    }

    public Logger getLog() {
        return this.log;
    }

    public void setLog(Logger log) {
        this.log = log;
    }

    public KubernetesClient getKubernetes() {
        if (this.kubernetes == null) {
            this.kubernetes = new DefaultKubernetesClient();
        }
        return this.kubernetes;
    }

    public GitRepoClient getGitRepoClient() {
        if (this.gitRepoClient == null) {
            this.gitRepoClient = GitRepoKubernetes.createGitRepoClient((KubernetesClient)this.getKubernetes(), (String)this.username, (String)this.password);
            if (this.gitRepoClient != null) {
                if (Strings.isNullOrBlank((String)this.username)) {
                    this.username = this.gitRepoClient.getUsername();
                }
                if (Strings.isNullOrBlank((String)this.password)) {
                    this.password = this.gitRepoClient.getPassword();
                }
            }
        }
        return this.gitRepoClient;
    }

    public File getBasedir() {
        return this.basedir;
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    public String getBranch() {
        return this.branch;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    public String getBuildImageStream() {
        return this.buildImageStream;
    }

    public void setBuildImageStream(String buildImageStream) {
        this.buildImageStream = buildImageStream;
    }

    public String getBuildImageTag() {
        return this.buildImageTag;
    }

    public void setBuildImageTag(String buildImageTag) {
        this.buildImageTag = buildImageTag;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public void setGitRepoClient(GitRepoClient gitRepoClient) {
        this.gitRepoClient = gitRepoClient;
    }

    public String getGitUrl() {
        return this.gitUrl;
    }

    public void setGitUrl(String gitUrl) {
        this.gitUrl = gitUrl;
    }

    public String getJenkinsJob() {
        return this.jenkinsJob;
    }

    public void setJenkinsJob(String jenkinsJob) {
        this.jenkinsJob = jenkinsJob;
    }

    public String getJenkinsMonitorView() {
        return this.jenkinsMonitorView;
    }

    public void setJenkinsMonitorView(String jenkinsMonitorView) {
        this.jenkinsMonitorView = jenkinsMonitorView;
    }

    public String getJenkinsPipelineView() {
        return this.jenkinsPipelineView;
    }

    public void setJenkinsPipelineView(String jenkinsPipelineView) {
        this.jenkinsPipelineView = jenkinsPipelineView;
    }

    public void setKubernetes(KubernetesClient kubernetes) {
        this.kubernetes = kubernetes;
    }

    public boolean isTriggerJenkinsJob() {
        return this.triggerJenkinsJob;
    }

    public void setTriggerJenkinsJob(boolean triggerJenkinsJob) {
        this.triggerJenkinsJob = triggerJenkinsJob;
    }

    public boolean isLetschatEnabled() {
        return this.letschatEnabled;
    }

    public void setLetschatEnabled(boolean letschatEnabled) {
        this.letschatEnabled = letschatEnabled;
    }

    public String getLetschatRoomExpression() {
        return this.letschatRoomExpression;
    }

    public void setLetschatRoomExpression(String letschatRoomExpression) {
        this.letschatRoomExpression = letschatRoomExpression;
    }

    public String getLetschatRoomLinkLabel() {
        return this.letschatRoomLinkLabel;
    }

    public void setLetschatRoomLinkLabel(String letschatRoomLinkLabel) {
        this.letschatRoomLinkLabel = letschatRoomLinkLabel;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getFabric8ConsoleNamespace() {
        return this.fabric8ConsoleNamespace;
    }

    public void setFabric8ConsoleNamespace(String fabric8ConsoleNamespace) {
        this.fabric8ConsoleNamespace = fabric8ConsoleNamespace;
    }

    public String getJenkinsNamespace() {
        return this.jenkinsNamespace;
    }

    public void setJenkinsNamespace(String jenkinsNamespace) {
        this.jenkinsNamespace = jenkinsNamespace;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isRecreateMode() {
        return this.recreateMode;
    }

    public void setRecreateMode(boolean recreateMode) {
        this.recreateMode = recreateMode;
    }

    public String getRepoName() {
        return this.repoName;
    }

    public void setRepoName(String repoName) {
        this.repoName = repoName;
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public boolean isTaigaAutoCreate() {
        return this.taigaAutoCreate;
    }

    public void setTaigaAutoCreate(boolean taigaAutoCreate) {
        this.taigaAutoCreate = taigaAutoCreate;
    }

    public boolean isTaigaEnabled() {
        return this.taigaEnabled;
    }

    public void setTaigaEnabled(boolean taigaEnabled) {
        this.taigaEnabled = taigaEnabled;
    }

    public String getTaigaProjectLinkLabel() {
        return this.taigaProjectLinkLabel;
    }

    public void setTaigaProjectLinkLabel(String taigaProjectLinkLabel) {
        this.taigaProjectLinkLabel = taigaProjectLinkLabel;
    }

    public String getTaigaProjectLinkPage() {
        return this.taigaProjectLinkPage;
    }

    public void setTaigaProjectLinkPage(String taigaProjectLinkPage) {
        this.taigaProjectLinkPage = taigaProjectLinkPage;
    }

    public String getTaigaProjectName() {
        return this.taigaProjectName;
    }

    public void setTaigaProjectName(String taigaProjectName) {
        this.taigaProjectName = taigaProjectName;
    }

    public String getTaigaProjectSlug() {
        return this.taigaProjectSlug;
    }

    public void setTaigaProjectSlug(String taigaProjectSlug) {
        this.taigaProjectSlug = taigaProjectSlug;
    }

    public String getTaigaTeamLinkLabel() {
        return this.taigaTeamLinkLabel;
    }

    public void setTaigaTeamLinkLabel(String taigaTeamLinkLabel) {
        this.taigaTeamLinkLabel = taigaTeamLinkLabel;
    }

    public String getTaigaTeamLinkPage() {
        return this.taigaTeamLinkPage;
    }

    public void setTaigaTeamLinkPage(String taigaTeamLinkPage) {
        this.taigaTeamLinkPage = taigaTeamLinkPage;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public boolean isTryLoadConfigFileFromRemoteGit() {
        return this.tryLoadConfigFileFromRemoteGit;
    }

    public void setTryLoadConfigFileFromRemoteGit(boolean tryLoadConfigFileFromRemoteGit) {
        this.tryLoadConfigFileFromRemoteGit = tryLoadConfigFileFromRemoteGit;
    }

    public ProjectConfig getProjectConfig() {
        return this.projectConfig;
    }

    public void setProjectConfig(ProjectConfig projectConfig) {
        this.projectConfig = projectConfig;
    }

    public void setRegisterWebHooks(boolean registerWebHooks) {
        this.registerWebHooks = registerWebHooks;
    }

    public boolean isRegisterWebHooks() {
        return this.registerWebHooks;
    }

    public String getIssueTrackerLabel() {
        return this.issueTrackerLabel;
    }

    public void setIssueTrackerLabel(String issueTrackerLabel) {
        this.issueTrackerLabel = issueTrackerLabel;
    }

    public String getIssueTrackerUrl() {
        return this.issueTrackerUrl;
    }

    public void setIssueTrackerUrl(String issueTrackerUrl) {
        this.issueTrackerUrl = issueTrackerUrl;
    }

    public String getTeamUrl() {
        return this.teamUrl;
    }

    public void setTeamUrl(String teamUrl) {
        this.teamUrl = teamUrl;
    }

    public String getTeamLabel() {
        return this.teamLabel;
    }

    public void setTeamLabel(String teamLabel) {
        this.teamLabel = teamLabel;
    }

    public String getReleasesUrl() {
        return this.releasesUrl;
    }

    public void setReleasesUrl(String releasesUrl) {
        this.releasesUrl = releasesUrl;
    }

    public String getReleasesLabel() {
        return this.releasesLabel;
    }

    public void setReleasesLabel(String releasesLabel) {
        this.releasesLabel = releasesLabel;
    }

    public String getRepositoryBrowseLabel() {
        return this.repositoryBrowseLabel;
    }

    public void setRepositoryBrowseLabel(String repositoryBrowseLabel) {
        this.repositoryBrowseLabel = repositoryBrowseLabel;
    }

    public String getRepositoryBrowseLink() {
        return this.repositoryBrowseLink;
    }

    public void setRepositoryBrowseLink(String repositoryBrowseLink) {
        this.repositoryBrowseLink = repositoryBrowseLink;
    }

    protected Controller createController() {
        Controller controller = new Controller(this.getKubernetes());
        controller.setNamespace(this.namespace);
        controller.setThrowExceptionOnError(true);
        controller.setRecreateMode(this.recreateMode);
        return controller;
    }

    protected void loadConfigFile() {
        if (this.projectConfig == null) {
            GitRepoClient gitRepo = this.getGitRepoClient();
            boolean hasLocalConfig = false;
            if (this.basedir != null && this.basedir.isDirectory()) {
                this.projectConfig = ProjectConfigs.loadFromFolder((File)this.basedir);
                if (!this.projectConfig.isEmpty() || ProjectConfigs.hasConfigFile((File)this.basedir)) {
                    hasLocalConfig = true;
                }
            }
            if (!hasLocalConfig && this.tryLoadConfigFileFromRemoteGit && Strings.isNotBlank((String)this.repoName) && gitRepo != null) {
                try {
                    InputStream input = gitRepo.getRawFile(this.username, this.repoName, this.branch, "fabric8.yml");
                    if (input != null) {
                        try {
                            this.getLog().info("Parsing fabric8.yml from the git repo " + this.repoName + " user " + this.username + " in branch " + this.branch);
                            this.projectConfig = ProjectConfigs.parseProjectConfig((InputStream)input);
                        }
                        catch (IOException e) {
                            this.getLog().warn("Failed to parse fabric8.yml from the repo " + this.repoName + " for user " + this.username + " branch: " + this.branch + ". " + e, (Throwable)e);
                        }
                    }
                }
                catch (Exception e) {
                    this.getLog().warn("Failed to load fabric8.yml from the repo " + this.repoName + " for user " + this.username + " branch: " + this.branch + ". " + e, (Throwable)e);
                }
            }
        }
        if (this.projectConfig != null) {
            String issueProjectName;
            String chatRoom = this.projectConfig.getChatRoom();
            if (Strings.isNotBlank((String)chatRoom)) {
                this.getLog().info("Found chat room: " + chatRoom);
                this.letschatRoomExpression = chatRoom;
            }
            if (Strings.isNotBlank((String)(issueProjectName = this.projectConfig.getIssueProjectName()))) {
                this.taigaProjectName = issueProjectName;
            }
        } else {
            this.getLog().info("No fabric8.yml file found for " + this.basedir);
        }
        if (Strings.isNullOrBlank((String)this.gitUrl)) {
            try {
                this.gitUrl = GitHelpers.extractGitUrl((File)this.basedir);
            }
            catch (IOException e) {
                this.getLog().warn("Could not load git URL from directory: " + e, (Throwable)e);
            }
        }
        if (Strings.isNullOrBlank((String)this.taigaProjectName)) {
            this.taigaProjectName = this.repoName;
        }
        if (Strings.isNullOrBlank((String)this.taigaProjectSlug)) {
            this.taigaProjectSlug = this.taigaProjectName;
        }
    }

    protected String getChatRoomLink(LetsChatClient letschat) {
        if (letschat != null) {
            try {
                String roomId;
                RoomDTO room;
                String url = letschat.getAddress();
                String slug = this.evaluateRoomExpression(this.letschatRoomExpression);
                if (Strings.isNotBlank((String)url) && Strings.isNotBlank((String)slug) && (room = letschat.getOrCreateRoom(slug)) != null && Strings.isNotBlank((String)(roomId = room.getId()))) {
                    return URLUtils.pathJoin((String[])new String[]{url, "/#!/room/" + roomId});
                }
            }
            catch (Exception e) {
                this.getLog().error("Failed to get the link to the chat room: " + e, (Throwable)e);
            }
        }
        return null;
    }

    protected String evaluateRoomExpression(String roomExpresion) {
        if (Strings.isNotBlank((String)roomExpresion)) {
            String namespace = KubernetesHelper.defaultNamespace();
            String answer = roomExpresion;
            answer = this.replaceExpression(answer, "namespace", namespace);
            answer = this.replaceExpression(answer, "repoName", this.repoName);
            answer = this.replaceExpression(answer, "username", this.username);
            return answer;
        }
        return null;
    }

    protected String replaceExpression(String text, String key, String value) {
        if (Strings.isNotBlank((String)key) && Strings.isNotBlank((String)value)) {
            String replace = "${" + key + "}";
            return text.replace(replace, value);
        }
        return text;
    }

    protected LetsChatClient createLetsChat() {
        if (!this.letschatEnabled) {
            return null;
        }
        KubernetesClient kubernetes = this.getKubernetes();
        LetsChatClient letsChat = LetsChatKubernetes.createLetsChat((KubernetesClient)kubernetes);
        if (letsChat == null) {
            this.getLog().warn("No letschat service availble n kubernetes " + this.namespace + " on address: " + kubernetes.getMasterUrl());
            return null;
        }
        if (!letsChat.isValid()) {
            this.getLog().warn("No $LETSCHAT_HUBOT_TOKEN environment variable defined so LetsChat support is disabled");
            return null;
        }
        return letsChat;
    }

    protected TaigaClient createTaiga() {
        if (!this.taigaEnabled) {
            return null;
        }
        TaigaClient taiga = TaigaKubernetes.createTaiga((KubernetesClient)this.getKubernetes(), (String)this.namespace);
        if (taiga != null) {
            taiga.setAutoCreateProjects(this.taigaAutoCreate);
        }
        return taiga;
    }

    protected String getProjectPageLink(TaigaClient taiga, ProjectDTO taigaProject, String projectRelativePage) {
        if (taiga != null && taigaProject != null) {
            try {
                String url = taiga.getAddress();
                String slug = taigaProject.getSlug();
                if (Strings.isNullOrBlank((String)slug)) {
                    slug = this.taigaProjectSlug;
                }
                String userName = taiga.getUsername();
                if (Strings.isNullOrBlank((String)slug)) {
                    slug = userName + "-" + this.taigaProjectName;
                }
                if (Strings.isNotBlank((String)url) && Strings.isNotBlank((String)slug) && Strings.isNotBlank((String)projectRelativePage)) {
                    return URLUtils.pathJoin((String[])new String[]{url, "/project/", slug + "/", projectRelativePage});
                }
            }
            catch (Exception e) {
                this.getLog().error("Failed to get project page link for " + projectRelativePage + " : " + e, (Throwable)e);
            }
        }
        return null;
    }

    protected void createJenkinsJob(String buildName, String jenkinsJobUrl) {
        if (this.projectConfig != null) {
            String template;
            String flow = this.projectConfig.getFlow();
            String flowGitUrlValue = null;
            boolean localFlow = false;
            if (Strings.isNotBlank((String)flow)) {
                flowGitUrlValue = this.flowGitUrl;
            } else if (this.projectConfig.isUseLocalFlow()) {
                flow = "flow.groovy";
                flowGitUrlValue = this.gitUrl;
                localFlow = true;
            }
            if (Strings.isNotBlank((String)flow) && Strings.isNotBlank((String)this.gitUrl) && Strings.isNotBlank((String)flowGitUrlValue) && Strings.isNotBlank((String)(template = DevOpsConnector.loadJenkinsBuildTemplate(this.getLog())))) {
                template = template.replace("${FLOW_PATH}", flow);
                template = template.replace("${FLOW_GIT_URL}", flowGitUrlValue);
                template = template.replace("${GIT_URL}", this.gitUrl);
                if (localFlow) {
                    template = DevOpsConnector.removeBuildParameter(this.getLog(), template, "GIT_URL");
                }
                this.postJenkinsBuild(buildName, template);
            }
        }
    }

    public static String loadJenkinsBuildTemplate(Logger log) {
        String template = null;
        String templateName = "jenkinsBuildConfig.xml";
        URL url = DevOpsConnector.class.getResource(templateName);
        if (url == null) {
            log.error("Could not load " + templateName + " on the classpath!");
        } else {
            try {
                template = IOHelpers.loadFully((URL)url);
            }
            catch (IOException e) {
                log.error("Failed to load template " + templateName + " from " + url + ". " + e, (Throwable)e);
            }
        }
        return template;
    }

    public static String removeBuildParameter(Logger log, String template, String parameterName) {
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = documentBuilder.parse(new InputSource(new StringReader(template)));
            Element rootElement = doc.getDocumentElement();
            NodeList stringDefs = rootElement.getElementsByTagName("hudson.model.StringParameterDefinition");
            if (stringDefs != null) {
                int size = stringDefs.getLength();
                for (int i = 0; i < size; ++i) {
                    String textContent;
                    Element element;
                    Element name;
                    Node item = stringDefs.item(i);
                    if (!(item instanceof Element) || (name = DomHelper.firstChild((Element)(element = (Element)item), (String)"name")) == null || (textContent = name.getTextContent()) == null || !parameterName.equals(textContent.trim())) continue;
                    Node parameterDefinitions = item.getParentNode();
                    Node parametersDefinitionProperty = parameterDefinitions != null ? parameterDefinitions.getParentNode() : null;
                    DomHelper.detach((Node)item);
                    if (DomHelper.firstChildElement((Node)parameterDefinitions) == null) {
                        DomHelper.detach((Node)parameterDefinitions);
                    }
                    if (DomHelper.firstChildElement((Node)parametersDefinitionProperty) == null) {
                        DomHelper.detach((Node)parametersDefinitionProperty);
                    }
                    return DomHelper.toXml((Document)doc);
                }
            }
        }
        catch (Exception e) {
            log.error("Failed to remove the build parameter from the Jenkins XML. " + e, (Throwable)e);
        }
        return template;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void postJenkinsBuild(String jobName, String xml) {
        String address = this.getServiceUrl("jenkins", false, this.namespace, this.jenkinsNamespace);
        if (Strings.isNotBlank((String)address)) {
            String jobUrl = URLUtils.pathJoin((String[])new String[]{address, "/createItem"}) + "?name=" + jobName;
            this.getLog().info("POSTING the jenkins job to: " + jobUrl);
            this.getLog().debug("Jenkins XML: " + xml);
            String json = "{}";
            HttpURLConnection connection = null;
            try {
                URL url = new URL(jobUrl);
                connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("POST");
                connection.setRequestProperty("Content-Type", "text/xml");
                connection.setDoOutput(true);
                OutputStreamWriter out = new OutputStreamWriter(connection.getOutputStream());
                out.write(xml);
                out.close();
                int status = connection.getResponseCode();
                String message = connection.getResponseMessage();
                this.getLog().info("Got response code from Jenkins: " + status + " message: " + message);
                if (status != 200) {
                    this.getLog().error("Failed to trigger job " + jobName + " on " + jobUrl + ". Status: " + status + " message: " + message);
                }
            }
            catch (Exception e) {
                this.getLog().error("Failed to trigger jenkins on " + jobUrl + ". " + e, (Throwable)e);
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
        }
    }

    protected void createJenkinsWebhook(String jenkinsJobUrl) {
        if (Strings.isNotBlank((String)jenkinsJobUrl)) {
            String jenkinsWebHook = URLUtils.pathJoin((String[])new String[]{jenkinsJobUrl, "/build"});
            Map<String, String> buildParameters = this.getBuildParameters();
            if (!buildParameters.isEmpty()) {
                String postfix = "";
                for (Map.Entry<String, String> entry : buildParameters.entrySet()) {
                    if (postfix.length() > 0) {
                        postfix = postfix + "&";
                    }
                    postfix = postfix + entry.getKey() + "=" + entry.getValue();
                }
                jenkinsWebHook = jenkinsWebHook + "WithParameters?" + postfix;
            }
            this.createWebhook(jenkinsWebHook, this.secret);
            if (this.triggerJenkinsJob) {
                this.triggerJenkinsWebHook(jenkinsWebHook, this.secret);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void triggerJenkinsWebHook(String jobUrl, String secret) {
        this.getLog().info("Triggering Jenkins webhook: " + jobUrl);
        String json = "{}";
        HttpURLConnection connection = null;
        try {
            URL url = new URL(jobUrl);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setDoOutput(true);
            OutputStreamWriter out = new OutputStreamWriter(connection.getOutputStream());
            out.write(json);
            out.close();
            int status = connection.getResponseCode();
            String message = connection.getResponseMessage();
            this.getLog().info("Got response code from Jenkins: " + status + " message: " + message);
            if (status != 200) {
                this.getLog().error("Failed to trigger job " + jobUrl + ". Status: " + status + " message: " + message);
            }
        }
        catch (Exception e) {
            this.getLog().error("Failed to trigger jenkins on " + jobUrl + ". " + e, (Throwable)e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    protected Map<String, String> getBuildParameters() {
        HashMap<String, String> answer = new HashMap<String, String>();
        if (this.projectConfig != null) {
            Map environments;
            Map parameters;
            String flow = this.projectConfig.getFlow();
            if (flow != null && Strings.isNotBlank((String)this.gitUrl)) {
                answer.put("GIT_URL", this.gitUrl);
            }
            if ((parameters = this.projectConfig.getBuildParameters()) != null) {
                answer.putAll(parameters);
            }
            if ((environments = this.projectConfig.getEnvironments()) != null) {
                Set entries = environments.entrySet();
                for (Map.Entry entry : entries) {
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    String paramName = key.toUpperCase() + "_NAMESPACE";
                    answer.put(paramName, value);
                }
            }
            if (!answer.containsKey("VERSION_PREFIX")) {
                answer.put("VERSION_PREFIX", "1.0");
            }
        }
        return answer;
    }

    protected ProjectDTO createTaigaProject(TaigaClient taiga) {
        if (taiga != null) {
            if (Strings.isNullOrBlank((String)this.taigaProjectName)) {
                this.getLog().info("Not creating Taiga project as no `fabric8.tagiaProjectName` property specified");
                return null;
            }
            if (Strings.isNullOrBlank((String)this.taigaProjectSlug)) {
                this.getLog().info("Not creating Taiga project as no `fabric8.taigaProjectSlug` property specified");
                return null;
            }
            this.getLog().info("About to create Taiga project " + this.taigaProjectName + " with slug: " + this.taigaProjectSlug);
            return taiga.getOrCreateProject(this.taigaProjectName, this.taigaProjectSlug);
        }
        return null;
    }

    protected void createTaigaWebhook(TaigaClient taiga, ProjectDTO project) {
        if (taiga != null && project != null) {
            Long projectId = project.getId();
            ModuleDTO module = taiga.moduleForProject(projectId, TaigaModule.GOGS);
            if (module != null) {
                String webhookSecret = module.getSecret();
                String webhook = taiga.getPublicWebhookUrl(module);
                if (Strings.isNotBlank((String)webhookSecret) && Strings.isNotBlank((String)webhook)) {
                    this.createWebhook(webhook, webhookSecret);
                } else {
                    this.getLog().warn("Could not create webhook for Taiga. Missing module data for url: " + webhook + " secret: " + webhookSecret);
                }
            } else {
                this.getLog().warn("No module for gogs so cannot create Taiga webhook");
            }
        }
    }

    protected void createWebhook(String url, String webhookSecret) {
        try {
            GitRepoClient gitRepoClient = this.getGitRepoClient();
            WebHooks.createGogsWebhook(gitRepoClient, this.getLog(), this.username, this.repoName, url, webhookSecret);
        }
        catch (Exception e) {
            this.getLog().error("Failed to create webhook " + url + " on repository " + this.repoName + ". Reason: " + e, (Throwable)e);
        }
    }
}

