/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.arquillian.kubernetes.await;

import io.fabric8.arquillian.kubernetes.Configuration;
import io.fabric8.arquillian.kubernetes.Session;
import io.fabric8.kubernetes.api.KubernetesClient;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.EndpointAddress;
import io.fabric8.kubernetes.api.model.EndpointSubset;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServiceSpec;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;

public class SessionServicesAreReady
implements Callable<Boolean> {
    private final Session session;
    private final KubernetesClient kubernetesClient;
    private final Configuration configuration;

    public SessionServicesAreReady(KubernetesClient kubernetesClient, Session session, Configuration configuration) {
        this.session = session;
        this.kubernetesClient = kubernetesClient;
        this.configuration = configuration;
    }

    @Override
    public Boolean call() throws Exception {
        boolean result = true;
        List services = this.kubernetesClient.getServices(this.session.getNamespace()).getItems();
        if (services.isEmpty()) {
            result = false;
            this.session.getLogger().warn("No services are available yet, waiting...");
        } else if (this.configuration.isWaitForServiceConnection()) {
            for (Service s : this.filterServices(services, this.configuration.getWaitForServices())) {
                if (this.isEndpointAvailable(s)) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean isEndpointAvailable(Service s) {
        boolean result;
        block21: {
            List subsets;
            String serviceStatus = null;
            result = false;
            String sid = KubernetesHelper.getName((HasMetadata)s);
            String namespace = this.kubernetesClient.getNamespace();
            Endpoints endpoints = this.kubernetesClient.endpointsForService(sid, namespace);
            ServiceSpec spec = s.getSpec();
            if (endpoints == null || spec == null || (subsets = endpoints.getSubsets()) == null) break block21;
            for (EndpointSubset subset : subsets) {
                List addresses = subset.getAddresses();
                if (addresses == null) continue;
                for (EndpointAddress address : addresses) {
                    String ip;
                    String addr = ip = address.getIp();
                    List ports = spec.getPorts();
                    for (ServicePort port : ports) {
                        block22: {
                            boolean bl;
                            Throwable throwable;
                            Socket socket;
                            block19: {
                                block20: {
                                    Integer portNumber = port.getPort();
                                    if (portNumber == null || portNumber <= 0) continue;
                                    if (!this.configuration.isConnectToServices()) break block22;
                                    socket = new Socket();
                                    throwable = null;
                                    socket.connect(new InetSocketAddress(ip, (int)portNumber), this.configuration.getServiceConnectionTimeout());
                                    serviceStatus = "Service: " + sid + " is ready. Provider:" + addr + ".";
                                    bl = true;
                                    if (socket == null) break block19;
                                    if (throwable == null) break block20;
                                    try {
                                        socket.close();
                                    }
                                    catch (Throwable x2) {
                                        throwable.addSuppressed(x2);
                                    }
                                    break block19;
                                }
                                socket.close();
                            }
                            this.session.getLogger().warn(serviceStatus);
                            return bl;
                            catch (Throwable throwable2) {
                                try {
                                    try {
                                        try {
                                            throwable = throwable2;
                                            throw throwable2;
                                        }
                                        catch (Throwable throwable3) {
                                            if (socket != null) {
                                                if (throwable != null) {
                                                    try {
                                                        socket.close();
                                                    }
                                                    catch (Throwable x2) {
                                                        throwable.addSuppressed(x2);
                                                    }
                                                } else {
                                                    socket.close();
                                                }
                                            }
                                            throw throwable3;
                                        }
                                    }
                                    catch (Exception e) {
                                        serviceStatus = "Service: " + sid + " is not ready! in namespace " + namespace + ". Error: " + e.getMessage();
                                        this.session.getLogger().warn(serviceStatus);
                                        continue;
                                    }
                                }
                                catch (Throwable throwable4) {
                                    this.session.getLogger().warn(serviceStatus);
                                    throw throwable4;
                                }
                            }
                        }
                        serviceStatus = "Service: " + sid + " is ready. Not testing connecting to it!. Provider:" + addr + ".";
                        this.session.getLogger().warn(serviceStatus);
                        return true;
                    }
                }
            }
        }
        return result;
    }

    private List<Service> filterServices(List<Service> services, List<String> selectedIds) {
        if (selectedIds != null && !selectedIds.isEmpty()) {
            ArrayList<Service> result = new ArrayList<Service>();
            for (Service s : services) {
                String sid = KubernetesHelper.getName((HasMetadata)s);
                if (!selectedIds.contains(sid)) continue;
                result.add(s);
            }
            return result;
        }
        return services;
    }
}

