/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.arquillian.kubernetes;

import io.fabric8.arquillian.kubernetes.Configuration;
import io.fabric8.arquillian.kubernetes.Session;
import io.fabric8.arquillian.kubernetes.ShutdownHook;
import io.fabric8.arquillian.kubernetes.await.CompositeCondition;
import io.fabric8.arquillian.kubernetes.await.SessionPodsAreReady;
import io.fabric8.arquillian.kubernetes.await.SessionServicesAreReady;
import io.fabric8.arquillian.kubernetes.await.WaitStrategy;
import io.fabric8.arquillian.kubernetes.event.Start;
import io.fabric8.arquillian.kubernetes.event.Stop;
import io.fabric8.arquillian.kubernetes.log.Logger;
import io.fabric8.arquillian.utils.Util;
import io.fabric8.kubernetes.api.Controller;
import io.fabric8.kubernetes.api.KubernetesClient;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.extensions.Templates;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.openshift.api.model.Template;
import io.fabric8.utils.MultiException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import org.jboss.arquillian.core.api.annotation.Observes;

public class SessionListener {
    private ShutdownHook shutdownHook;

    public void start(@Observes Start event, KubernetesClient client, Controller controller, Configuration configuration) throws Exception {
        Session session = event.getSession();
        Logger log = session.getLogger();
        String namespace = session.getNamespace();
        System.setProperty("KUBERNETES_NAMESPACE", namespace);
        log.status("Creating kubernetes resources inside namespace: " + namespace);
        log.info("if you use OpenShift then type this switch namespaces:     osc namespace " + namespace);
        log.info("if you use kubernetes then type this to switch namespaces: kubectl namespace " + namespace);
        client.setNamespace(namespace);
        controller.setNamespace(namespace);
        controller.setThrowExceptionOnError(true);
        controller.setRecreateMode(true);
        controller.setIgnoreRunningOAuthClients(true);
        Namespace namespaceDetails = session.getNamespaceDetails();
        controller.applyNamespace(namespaceDetails);
        this.shutdownHook = new ShutdownHook(client, session);
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        try {
            URL configUrl = configuration.getConfigUrl();
            List<String> dependencies = !configuration.getDependencies().isEmpty() ? configuration.getDependencies() : Util.getMavenDependencies(session);
            LinkedList<KubernetesList> kubeConfigs = new LinkedList<KubernetesList>();
            for (String dependency : dependencies) {
                log.info("Found dependency: " + dependency);
                this.loadDependency(log, kubeConfigs, dependency);
            }
            if (configUrl != null) {
                log.status("Applying kubernetes configuration from: " + configUrl);
                Object dto = KubernetesHelper.loadJson((String)Util.readAsString(configUrl));
                if (dto instanceof Template) {
                    Template template = (Template)dto;
                    KubernetesHelper.setNamespace((HasMetadata)template, (String)namespace);
                    String parameterNamePrefix = "";
                    Templates.overrideTemplateParameters((Template)template, configuration.getProperties(), (String)parameterNamePrefix);
                    log.status("Applying template in namespace " + namespace);
                    dto = controller.processTemplate(template, configUrl.toString());
                    if (dto == null) {
                        throw new IllegalArgumentException("Failed to process Template!");
                    }
                }
                KubernetesList kubeList = KubernetesHelper.asKubernetesList((Object)dto);
                List items = kubeList.getItems();
                kubeConfigs.add(kubeList);
            }
            if (!this.applyConfiguration(client, controller, configuration, session, kubeConfigs)) {
                throw new IllegalStateException("Failed to apply kubernetes configuration.");
            }
            Util.displaySessionStatus(client, session);
        }
        catch (Exception e) {
            try {
                Util.cleanupSession(client, session);
            }
            catch (MultiException me) {
                throw e;
            }
            finally {
                if (this.shutdownHook != null) {
                    Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
                }
            }
            throw new RuntimeException(e);
        }
    }

    protected static void addConfig(List<KubernetesList> kubeConfigs, Object kubeCfg) {
        if (kubeCfg instanceof KubernetesList) {
            kubeConfigs.add((KubernetesList)kubeCfg);
        }
    }

    public void loadDependency(Logger log, List<KubernetesList> kubeConfigs, String dependency) throws IOException {
        String baseDir = System.getProperty("basedir", ".");
        String path = baseDir + "/" + dependency;
        File file = new File(path);
        if (file.exists()) {
            this.loadDependency(log, kubeConfigs, file);
        } else {
            SessionListener.addConfig(kubeConfigs, KubernetesHelper.loadJson((String)Util.readAsString(new URL(dependency))));
        }
    }

    protected void loadDependency(Logger log, List<KubernetesList> kubeConfigs, File file) throws IOException {
        if (file.isFile()) {
            log.info("Loading file " + file);
            SessionListener.addConfig(kubeConfigs, KubernetesHelper.loadJson((File)file));
        } else {
            File[] children = file.listFiles();
            if (children != null) {
                for (File child : children) {
                    String name = child.getName().toLowerCase();
                    if (!name.endsWith(".json") && !name.endsWith(".yaml")) continue;
                    this.loadDependency(log, kubeConfigs, child);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(@Observes Stop event, KubernetesClient client) throws Exception {
        try {
            Util.cleanupSession(client, event.getSession());
        }
        finally {
            if (this.shutdownHook != null) {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
        }
    }

    private boolean applyConfiguration(KubernetesClient client, Controller controller, Configuration configuration, Session session, List<KubernetesList> kubeConfigs) throws Exception {
        Logger log = session.getLogger();
        TreeMap<Integer, Callable<Boolean>> conditions = new TreeMap<Integer, Callable<Boolean>>();
        SessionPodsAreReady sessionPodsReady = new SessionPodsAreReady(client, session);
        SessionServicesAreReady servicesReady = new SessionServicesAreReady(client, session, configuration);
        ArrayList entities = new ArrayList();
        for (KubernetesList c : kubeConfigs) {
            entities.addAll(c.getItems());
        }
        Collections.sort(entities, new Comparator<Object>(){

            @Override
            public int compare(Object left, Object right) {
                if (left instanceof Service) {
                    return -1;
                }
                if (right instanceof Service) {
                    return 1;
                }
                return 0;
            }
        });
        for (Object entity : entities) {
            if (entity instanceof Pod) {
                Pod pod = (Pod)entity;
                log.status("Applying pod:" + KubernetesHelper.getName((HasMetadata)pod));
                controller.applyPod(pod, session.getId());
                conditions.put(1, sessionPodsReady);
                continue;
            }
            if (entity instanceof Service) {
                Service service = (Service)entity;
                log.status("Applying service:" + KubernetesHelper.getName((HasMetadata)service));
                controller.applyService(service, session.getId());
                conditions.put(2, servicesReady);
                continue;
            }
            if (entity instanceof ReplicationController) {
                ReplicationController replicationController = (ReplicationController)entity;
                log.status("Applying replication controller:" + KubernetesHelper.getName((HasMetadata)replicationController));
                controller.applyReplicationController(replicationController, session.getId());
                conditions.put(1, sessionPodsReady);
                continue;
            }
            if (entity == null) continue;
            log.status("Applying " + entity.getClass().getSimpleName() + ":");
            controller.apply(entity, session.getId());
        }
        if (!conditions.isEmpty()) {
            CompositeCondition compositeCondition = new CompositeCondition(conditions.values());
            WaitStrategy waitStrategy = new WaitStrategy(compositeCondition, configuration.getTimeout(), configuration.getPollInterval());
            if (!waitStrategy.await()) {
                log.error("Timed out waiting for pods/services!");
                return false;
            }
            log.status("All pods/services are currently 'running'!");
        } else {
            log.warn("No pods/services/replication controllers defined in the configuration!");
        }
        return true;
    }
}

