/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.arquillian.kubernetes;

import io.fabric8.arquillian.kubernetes.log.Logger;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.utils.Systems;

public class Session {
    private final String id;
    private final Logger logger;
    private String namespacePrefix = "itest-";
    private String namespace;
    private Namespace namespaceDetails;

    public Session(String id, Logger logger) {
        this.id = id;
        this.logger = logger;
        this.namespacePrefix = Systems.getEnvVarOrSystemProperty((String)"FABRIC8_NAMESPACE_PREFIX", (String)"itest-");
        this.namespace = this.namespacePrefix + id;
        this.namespaceDetails = new Namespace();
        KubernetesHelper.getOrCreateMetadata((HasMetadata)this.namespaceDetails).setName(this.namespace);
    }

    void init() {
        this.logger.status("Initializing Session:" + this.id);
    }

    void destroy() {
        this.logger.status("Destroying Session:" + this.id);
        System.out.flush();
    }

    public String getId() {
        return this.id;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Namespace getNamespaceDetails() {
        return this.namespaceDetails;
    }
}

