/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.arquillian.kubernetes.enricher;

import io.fabric8.arquillian.kubernetes.Session;
import io.fabric8.arquillian.kubernetes.enricher.EnricherUtils;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ClientPodResource;
import java.lang.annotation.Annotation;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.arquillian.test.spi.enricher.resource.ResourceProvider;

public class PodResourceProvider
implements ResourceProvider {
    @Inject
    private Instance<KubernetesClient> clientInstance;
    @Inject
    private Instance<Session> sessionInstance;

    public boolean canProvide(Class<?> type) {
        return Pod.class.isAssignableFrom(type);
    }

    public Object lookup(ArquillianResource resource, Annotation ... qualifiers) {
        KubernetesClient client = (KubernetesClient)this.clientInstance.get();
        Session session = (Session)this.sessionInstance.get();
        String name = EnricherUtils.getPodName(qualifiers);
        return ((ClientPodResource)((ClientNonNamespaceOperation)client.pods().inNamespace(session.getNamespace())).withName(name)).get();
    }
}

