/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.arquillian.utils;

import io.fabric8.arquillian.kubernetes.Configuration;
import io.fabric8.arquillian.kubernetes.Session;
import io.fabric8.arquillian.utils.Util;
import io.fabric8.kubernetes.api.model.DoneableNamespace;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.NamespaceFluent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import io.fabric8.utils.PropertiesHelper;
import io.fabric8.utils.Strings;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class Namespaces {
    public static Namespace createNamespace(KubernetesClient client, Session session) {
        return ((DoneableNamespace)((NamespaceFluent.MetadataNested)((NamespaceFluent.MetadataNested)((NamespaceFluent.MetadataNested)((NamespaceFluent.MetadataNested)((NamespaceFluent.MetadataNested)((DoneableNamespace)client.namespaces().createNew()).withNewMetadata().withName(session.getNamespace())).addToLabels("provider", "fabric8")).addToLabels("component", "integrationTest")).addToLabels("framework", "arquillian")).withAnnotations(Namespaces.createNamespaceAnnotations(session, "RUNNING"))).endMetadata()).done();
    }

    public static Namespace checkNamespace(KubernetesClient client, Session session, Configuration configuration) {
        Namespace result = (Namespace)((ClientResource)client.namespaces().withName(session.getNamespace())).get();
        if (result != null) {
            return result;
        }
        if (configuration.isNamespaceLazyCreateEnabled()) {
            return Namespaces.createNamespace(client, session);
        }
        throw new IllegalStateException("Namespace " + session.getNamespace() + "doesn't exists");
    }

    public static synchronized Namespace updateNamespaceStatus(KubernetesClient client, Session session, String status) {
        return ((DoneableNamespace)((NamespaceFluent.MetadataNested)((DoneableNamespace)((ClientResource)client.namespaces().withName(session.getNamespace())).edit()).editMetadata().addToAnnotations(Namespaces.createNamespaceAnnotations(session, status))).endMetadata()).done();
    }

    public static synchronized Namespace updateNamespaceTestStatus(KubernetesClient client, Session session, String test, String status) {
        return ((DoneableNamespace)((NamespaceFluent.MetadataNested)((DoneableNamespace)((ClientResource)client.namespaces().withName(session.getNamespace())).edit()).editMetadata().addToAnnotations("fabric8.io/test-status-" + test, status)).endMetadata()).done();
    }

    private static Map<String, String> createNamespaceAnnotations(Session session, String status) {
        File pomProperties;
        HashMap<String, String> annotations = new HashMap<String, String>();
        File dir = Util.getProjectBaseDir(session);
        String gitUrl = Util.findGitUrl(session, dir);
        annotations.put("fabric8.io/test-session-id", session.getId());
        annotations.put("fabric8.io/test-session-status", status);
        if (Strings.isNotBlank((String)gitUrl)) {
            annotations.put("fabric8.io/git-url", gitUrl);
        }
        if ((pomProperties = new File(dir, "target/maven-archiver/pom.properties")).isFile()) {
            try {
                Properties properties = new Properties();
                properties.load(new FileInputStream(pomProperties));
                Map map = PropertiesHelper.toMap((Properties)properties);
                for (Map.Entry entry : map.entrySet()) {
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    if (!Strings.isNotBlank((String)key) || !Strings.isNotBlank((String)value)) continue;
                    annotations.put("fabric8.io/project-" + key, value);
                }
            }
            catch (IOException e) {
                session.getLogger().warn("Failed to load " + pomProperties + " file to annotate the namespace: " + e);
            }
        }
        return annotations;
    }
}

