/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.arquillian.kubernetes;

import io.fabric8.arquillian.kubernetes.log.Logger;
import io.fabric8.utils.Systems;
import java.util.concurrent.atomic.AtomicInteger;

public class Session {
    private final String id;
    private final Logger logger;
    private final String namespace;
    private final AtomicInteger passed = new AtomicInteger();
    private final AtomicInteger failed = new AtomicInteger();
    private final AtomicInteger skiped = new AtomicInteger();
    private static final String NAMESPACE_PREFIX = Systems.getEnvVarOrSystemProperty((String)"FABRIC8_NAMESPACE_PREFIX", (String)"itest-");

    public Session(String id, Logger logger) {
        this(id, NAMESPACE_PREFIX + id, logger);
    }

    public Session(String id, String namesapce, Logger logger) {
        this.id = id;
        this.logger = logger;
        this.namespace = namesapce;
    }

    void init() {
        this.logger.status("Initializing Session:" + this.id);
    }

    void destroy() {
        this.logger.status("Destroying Session:" + this.id);
        System.out.flush();
    }

    public String getId() {
        return this.id;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public AtomicInteger getPassed() {
        return this.passed;
    }

    public AtomicInteger getFailed() {
        return this.failed;
    }

    public AtomicInteger getSkiped() {
        return this.skiped;
    }
}

