/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.arquillian.kubernetes;

import io.fabric8.arquillian.kubernetes.Session;
import io.fabric8.utils.Zips;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.jboss.shrinkwrap.resolver.api.maven.Maven;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStage;
import org.jboss.shrinkwrap.resolver.api.maven.PomEquippedResolveStage;

public class DependencyResolver {
    public static final String DEFAULT_PATH_TO_POM = "pom.xml";
    private final String pathToPomFile;
    private final boolean rethrowExcpetions;

    public DependencyResolver() {
        this(DEFAULT_PATH_TO_POM, false);
    }

    public DependencyResolver(String pathToPomFile, boolean rethrowExcpetions) {
        this.pathToPomFile = pathToPomFile;
        this.rethrowExcpetions = rethrowExcpetions;
    }

    public List<String> resolve(Session session) throws IOException {
        ArrayList<String> dependencies = new ArrayList<String>();
        try {
            File[] files;
            for (File f : files = ((MavenFormatStage)((MavenStrategyStage)((PomEquippedResolveStage)((PomEquippedResolveStage)Maven.resolver().loadPomFromFile(this.pathToPomFile)).importTestDependencies()).resolve()).withoutTransitivity()).asFile()) {
                if (f.getName().endsWith("jar") && this.hasKubernetesJson(f)) {
                    Path dir = Files.createTempDirectory(session.getId(), new FileAttribute[0]);
                    try (FileInputStream fis = new FileInputStream(f);
                         JarInputStream jis = new JarInputStream(fis);){
                        Zips.unzip((InputStream)new FileInputStream(f), (File)dir.toFile());
                        File jsonPath = dir.resolve("kubernetes.json").toFile();
                        if (!jsonPath.exists()) continue;
                        dependencies.add(jsonPath.toURI().toString());
                        continue;
                    }
                }
                if (!f.getName().endsWith(".json")) continue;
                dependencies.add(f.toURI().toString());
            }
        }
        catch (Exception e) {
            if (this.rethrowExcpetions) {
                throw e;
            }
            session.getLogger().warn("Skipping maven project dependencies. Caused by:" + e.getMessage());
        }
        return dependencies;
    }

    private boolean hasKubernetesJson(File f) throws IOException {
        try (FileInputStream fis = new FileInputStream(f);
             JarInputStream jis = new JarInputStream(fis);){
            JarEntry entry = jis.getNextJarEntry();
            while (true) {
                if (entry != null) {
                    if (entry.getName().equals("kubernetes.json")) {
                        boolean bl = true;
                        return bl;
                    }
                    entry = jis.getNextJarEntry();
                    continue;
                }
                break;
            }
        }
        return false;
    }
}

