/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.arquillian.kubernetes;

import io.fabric8.arquillian.kubernetes.Configuration;
import io.fabric8.arquillian.kubernetes.Session;
import io.fabric8.arquillian.kubernetes.ShutdownHook;
import io.fabric8.arquillian.kubernetes.await.CompositeCondition;
import io.fabric8.arquillian.kubernetes.await.SessionPodsAreReady;
import io.fabric8.arquillian.kubernetes.await.SessionServicesAreReady;
import io.fabric8.arquillian.kubernetes.await.WaitStrategy;
import io.fabric8.arquillian.kubernetes.event.Start;
import io.fabric8.arquillian.kubernetes.event.Stop;
import io.fabric8.arquillian.kubernetes.log.Logger;
import io.fabric8.arquillian.utils.Commands;
import io.fabric8.arquillian.utils.Routes;
import io.fabric8.arquillian.utils.SecretKeys;
import io.fabric8.arquillian.utils.Secrets;
import io.fabric8.arquillian.utils.Util;
import io.fabric8.kubernetes.api.Controller;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.extensions.Templates;
import io.fabric8.kubernetes.api.model.DoneableNamespace;
import io.fabric8.kubernetes.api.model.DoneableSecret;
import io.fabric8.kubernetes.api.model.DoneableSecurityContextConstraints;
import io.fabric8.kubernetes.api.model.DoneableServiceAccount;
import io.fabric8.kubernetes.api.model.EditableObjectReference;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.NamespaceFluent;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretFluent;
import io.fabric8.kubernetes.api.model.SecurityContextConstraints;
import io.fabric8.kubernetes.api.model.SecurityContextConstraintsFluent;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceAccount;
import io.fabric8.kubernetes.api.model.ServiceAccountBuilder;
import io.fabric8.kubernetes.api.model.ServiceAccountFluent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import io.fabric8.openshift.api.model.OAuthClient;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.api.model.Template;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.utils.MultiException;
import io.fabric8.utils.Strings;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import org.jboss.arquillian.core.api.annotation.Observes;

public class SessionListener {
    private ShutdownHook shutdownHook;

    public void start(@Observes Start event, KubernetesClient client, Controller controller, Configuration configuration) throws Exception {
        Session session = event.getSession();
        Logger log = session.getLogger();
        String namespace = session.getNamespace();
        System.setProperty("kubernetes.namespace", namespace);
        log.status("Using Kubernetes at: " + client.getMasterUrl());
        log.status("Creating kubernetes resources inside namespace: " + namespace);
        log.info("if you use OpenShift then type this switch namespaces:     oc project " + namespace);
        log.info("if you use kubernetes then type this to switch namespaces: kubectl namespace " + namespace);
        controller.setNamespace(namespace);
        controller.setThrowExceptionOnError(true);
        controller.setRecreateMode(true);
        controller.setIgnoreRunningOAuthClients(true);
        if (Strings.isNullOrBlank((String)configuration.getNamespaceToUse())) {
            this.createNamespace(client, session);
        } else {
            this.assertNamespaceExists(client, session, configuration);
        }
        this.shutdownHook = new ShutdownHook(client, configuration, session);
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        try {
            URL configUrl = configuration.getEnvironmentConfigUrl();
            List<String> dependencies = !configuration.getEnvironmentDependencies().isEmpty() ? configuration.getEnvironmentDependencies() : Util.getMavenDependencies(session);
            LinkedList<KubernetesList> kubeConfigs = new LinkedList<KubernetesList>();
            if (configuration.isEnvironmentInitEnabled()) {
                for (String dependency : dependencies) {
                    log.info("Found dependency: " + dependency);
                    this.loadDependency(log, kubeConfigs, dependency, controller, configuration, namespace);
                }
                if (configUrl != null) {
                    log.status("Applying kubernetes configuration from: " + configUrl);
                    Object dto = KubernetesHelper.loadJson((String)Util.readAsString(configUrl));
                    dto = this.expandTemplate(controller, configuration, log, namespace, configUrl.toString(), dto);
                    KubernetesList kubeList = KubernetesHelper.asKubernetesList((Object)dto);
                    List items = kubeList.getItems();
                    kubeConfigs.add(kubeList);
                }
            }
            if (configuration.isEnvironmentInitEnabled() && !this.applyConfiguration(client, controller, configuration, session, kubeConfigs)) {
                throw new IllegalStateException("Failed to apply kubernetes configuration.");
            }
            Util.displaySessionStatus(client, session);
        }
        catch (Exception e) {
            try {
                Util.cleanupSession(client, configuration, session);
            }
            catch (MultiException me) {
                throw e;
            }
            finally {
                if (this.shutdownHook != null) {
                    Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
                }
            }
            throw new RuntimeException(e);
        }
    }

    protected Object expandTemplate(Controller controller, Configuration configuration, Logger log, String namespace, String sourceName, Object dto) {
        if (dto instanceof Template) {
            Template template = (Template)dto;
            KubernetesHelper.setNamespace((HasMetadata)template, (String)namespace);
            String parameterNamePrefix = "";
            Templates.overrideTemplateParameters((Template)template, configuration.getProperties(), (String)parameterNamePrefix);
            log.status("Applying template in namespace " + namespace);
            controller.installTemplate(template, sourceName);
            dto = controller.processTemplate(template, sourceName);
            if (dto == null) {
                throw new IllegalArgumentException("Failed to process Template!");
            }
        }
        return dto;
    }

    protected void addConfig(List<KubernetesList> kubeConfigs, Object dto, Controller controller, Configuration configuration, Logger log, String namespace, String sourceName) {
        if ((dto = this.expandTemplate(controller, configuration, log, namespace, sourceName, dto)) instanceof KubernetesList) {
            kubeConfigs.add((KubernetesList)dto);
        }
    }

    public void loadDependency(Logger log, List<KubernetesList> kubeConfigs, String dependency, Controller controller, Configuration configuration, String namespace) throws IOException {
        String baseDir = System.getProperty("basedir", ".");
        String path = baseDir + "/" + dependency;
        File file = new File(path);
        if (file.exists()) {
            this.loadDependency(log, kubeConfigs, file, controller, configuration, log, namespace);
        } else {
            this.addConfig(kubeConfigs, KubernetesHelper.loadJson((String)Util.readAsString(new URL(dependency))), controller, configuration, log, namespace, dependency);
        }
    }

    protected void loadDependency(Logger log, List<KubernetesList> kubeConfigs, File file, Controller controller, Configuration configuration, Logger logger, String namespace) throws IOException {
        if (file.isFile()) {
            log.info("Loading file " + file);
            this.addConfig(kubeConfigs, KubernetesHelper.loadJson((File)file), controller, configuration, log, namespace, file.getPath());
        } else {
            File[] children = file.listFiles();
            if (children != null) {
                for (File child : children) {
                    String name = child.getName().toLowerCase();
                    if (!name.endsWith(".json") && !name.endsWith(".yaml")) continue;
                    this.loadDependency(log, kubeConfigs, child, controller, configuration, log, namespace);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(@Observes Stop event, KubernetesClient client, Configuration configuration) throws Exception {
        try {
            Util.cleanupSession(client, configuration, event.getSession());
        }
        finally {
            if (this.shutdownHook != null) {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
        }
    }

    private void createNamespace(KubernetesClient client, Session session) {
        ((DoneableNamespace)((NamespaceFluent.MetadataNested)((NamespaceFluent.MetadataNested)((NamespaceFluent.MetadataNested)((NamespaceFluent.MetadataNested)((NamespaceFluent.MetadataNested)((DoneableNamespace)client.namespaces().createNew()).withNewMetadata().withName(session.getNamespace())).addToLabels("provider", "fabric8")).addToLabels("component", "integrationTest")).addToLabels("framework", "arquillian")).withAnnotations(Util.createNamespaceAnnotations(session))).endMetadata()).done();
    }

    private void assertNamespaceExists(KubernetesClient client, Session session, Configuration configuration) {
        String namespace = session.getNamespace();
        if (((ClientResource)client.namespaces().withName(namespace)).get() == null) {
            if (configuration.isNamespaceLazyCreateEnabled()) {
                Controller controller = new Controller(client);
                controller.applyNamespace(namespace);
            } else {
                throw new IllegalStateException("Namespace " + namespace + "doesn't exists");
            }
        }
    }

    private boolean applyConfiguration(KubernetesClient client, Controller controller, Configuration configuration, Session session, List<KubernetesList> kubeConfigs) throws Exception {
        Logger log = session.getLogger();
        TreeMap<Integer, Callable<Boolean>> conditions = new TreeMap<Integer, Callable<Boolean>>();
        SessionPodsAreReady sessionPodsReady = new SessionPodsAreReady(client, session);
        SessionServicesAreReady servicesReady = new SessionServicesAreReady(client, session, configuration);
        ArrayList entities = new ArrayList();
        for (KubernetesList c : kubeConfigs) {
            entities.addAll(c.getItems());
        }
        Collections.sort(entities, new Comparator<Object>(){

            @Override
            public int compare(Object left, Object right) {
                if (left instanceof Service) {
                    return -1;
                }
                if (right instanceof Service) {
                    return 1;
                }
                return 0;
            }
        });
        String namespace = session.getNamespace();
        String routePrefix = namespace + "." + configuration.getKubernetesDomain();
        this.preprocessEnvironment(client, controller, configuration, session);
        ArrayList<Route> extraEntities = new ArrayList<Route>();
        for (Object entity : entities) {
            String serviceAccountName;
            Set<Secret> secrets;
            if (entity instanceof Pod) {
                Pod pod = (Pod)entity;
                log.status("Applying pod:" + KubernetesHelper.getName((HasMetadata)pod));
                secrets = this.generateSecrets(client, session, pod.getMetadata());
                serviceAccountName = pod.getSpec().getServiceAccountName();
                if (Strings.isNotBlank((String)serviceAccountName)) {
                    this.generateServiceAccount(client, session, secrets, serviceAccountName);
                }
                controller.applyPod(pod, session.getId());
                conditions.put(1, sessionPodsReady);
                continue;
            }
            if (entity instanceof Service) {
                Service service = (Service)entity;
                String serviceName = KubernetesHelper.getName((HasMetadata)service);
                log.status("Applying service:" + serviceName);
                controller.applyService(service, session.getId());
                conditions.put(2, servicesReady);
                Route route = Routes.createRouteForService(routePrefix, namespace, service, log);
                if (route == null) continue;
                log.status("Applying route for:" + serviceName);
                controller.applyRoute(route, "route for " + serviceName);
                extraEntities.add(route);
                continue;
            }
            if (entity instanceof ReplicationController) {
                ReplicationController replicationController = (ReplicationController)entity;
                log.status("Applying replication controller:" + KubernetesHelper.getName((HasMetadata)replicationController));
                secrets = this.generateSecrets(client, session, replicationController.getSpec().getTemplate().getMetadata());
                serviceAccountName = replicationController.getSpec().getTemplate().getSpec().getServiceAccountName();
                if (Strings.isNotBlank((String)serviceAccountName)) {
                    this.generateServiceAccount(client, session, secrets, serviceAccountName);
                }
                controller.applyReplicationController(replicationController, session.getId());
                conditions.put(1, sessionPodsReady);
                continue;
            }
            if (entity instanceof OAuthClient) {
                String redirectUri;
                OAuthClient oc = (OAuthClient)entity;
                ObjectMeta metadata = KubernetesHelper.getOrCreateMetadata((HasMetadata)oc);
                String name = metadata.getName();
                OpenShiftClient openShiftClient = (OpenShiftClient)client.adapt(OpenShiftClient.class);
                OAuthClient current = (OAuthClient)((ClientResource)openShiftClient.oAuthClients().withName(name)).get();
                boolean create = false;
                if (current == null) {
                    current = oc;
                    create = true;
                }
                boolean updated = false;
                List redirectURIs = current.getRedirectURIs();
                if (!redirectURIs.contains(redirectUri = "http://" + name + "." + routePrefix)) {
                    redirectURIs.add(redirectUri);
                    updated = true;
                }
                current.setRedirectURIs(redirectURIs);
                log.status("Applying OAuthClient:" + name);
                controller.setSupportOAuthClients(true);
                if (create) {
                    openShiftClient.oAuthClients().create((Object[])new OAuthClient[]{current});
                    continue;
                }
                if (!updated) continue;
                ((ClientResource)openShiftClient.oAuthClients().withName(name)).delete();
                current.getMetadata().setResourceVersion(null);
                openShiftClient.oAuthClients().create((Object[])new OAuthClient[]{current});
                continue;
            }
            if (entity instanceof HasMetadata) {
                log.status("Applying " + entity.getClass().getSimpleName() + ":" + KubernetesHelper.getName((HasMetadata)((HasMetadata)entity)));
                controller.apply(entity, session.getId());
                continue;
            }
            if (entity == null) continue;
            log.status("Applying " + entity.getClass().getSimpleName() + ".");
            controller.apply(entity, session.getId());
        }
        entities.addAll(extraEntities);
        if (!conditions.isEmpty()) {
            CompositeCondition compositeCondition = new CompositeCondition(conditions.values());
            WaitStrategy waitStrategy = new WaitStrategy(compositeCondition, configuration.getWaitTimeout(), configuration.getWaitPollInterval());
            if (!waitStrategy.await()) {
                log.error("Timed out waiting for pods/services!");
                return false;
            }
            log.status("All pods/services are currently 'running'!");
        } else {
            log.warn("No pods/services/replication controllers defined in the configuration!");
        }
        return true;
    }

    protected void preprocessEnvironment(KubernetesClient client, Controller controller, Configuration configuration, Session session) {
        if (configuration.isUseGoFabric8()) {
            Logger logger = session.getLogger();
            Commands.assertCommand(logger, "oc", "project", session.getNamespace());
            Commands.assertCommand(logger, "gofabric8", "deploy", "-y", "--console=false", "--templates=false");
            Commands.assertCommand(logger, "gofabric8", "secrets", "-y");
        }
    }

    private void generateServiceAccount(KubernetesClient client, Session session, Set<Secret> secrets, String serviceAccountName) {
        ServiceAccount serviceAccount;
        ArrayList<EditableObjectReference> secretRefs = new ArrayList<EditableObjectReference>();
        for (Secret secret : secrets) {
            secretRefs.add(((ObjectReferenceBuilder)((ObjectReferenceBuilder)new ObjectReferenceBuilder().withNamespace(session.getNamespace())).withName(KubernetesHelper.getName((HasMetadata)secret))).build());
        }
        SecurityContextConstraints securityContextConstraints = (SecurityContextConstraints)((ClientResource)client.securityContextConstraints().withName(session.getNamespace())).get();
        if (securityContextConstraints == null) {
            ((DoneableSecurityContextConstraints)((DoneableSecurityContextConstraints)((SecurityContextConstraintsFluent.SeLinuxContextNested)((DoneableSecurityContextConstraints)((SecurityContextConstraintsFluent.RunAsUserNested)((DoneableSecurityContextConstraints)((DoneableSecurityContextConstraints)((DoneableSecurityContextConstraints)((SecurityContextConstraintsFluent.MetadataNested)((DoneableSecurityContextConstraints)client.securityContextConstraints().createNew()).withNewMetadata().withName(session.getNamespace())).endMetadata()).withAllowHostDirVolumePlugin(Boolean.valueOf(true))).withAllowPrivilegedContainer(Boolean.valueOf(true))).withNewRunAsUser().withType("RunAsAny")).endRunAsUser()).withNewSeLinuxContext().withType("RunAsAny")).endSeLinuxContext()).withUsers(new String[]{"system:serviceaccount:" + session.getNamespace() + ":" + serviceAccountName})).done();
        }
        if ((serviceAccount = (ServiceAccount)((ClientResource)((ClientNonNamespaceOperation)client.serviceAccounts().inNamespace(session.getNamespace())).withName(serviceAccountName)).get()) == null) {
            ((DoneableServiceAccount)((DoneableServiceAccount)((ServiceAccountFluent.MetadataNested)((DoneableServiceAccount)((ClientNonNamespaceOperation)client.serviceAccounts().inNamespace(session.getNamespace())).createNew()).withNewMetadata().withName(serviceAccountName)).endMetadata()).withSecrets(secretRefs)).done();
        } else {
            ((ClientResource)((ClientNonNamespaceOperation)client.serviceAccounts().inNamespace(session.getNamespace())).withName(serviceAccountName)).replace((Object)((ServiceAccountBuilder)((ServiceAccountBuilder)((ServiceAccountFluent.MetadataNested)new ServiceAccountBuilder(serviceAccount).withNewMetadata().withName(serviceAccountName)).endMetadata()).addToSecrets(secretRefs.toArray(new ObjectReference[secretRefs.size()]))).build());
        }
    }

    private Set<Secret> generateSecrets(KubernetesClient client, Session session, ObjectMeta meta) {
        HashSet<Secret> secrets = new HashSet<Secret>();
        Map annotations = meta.getAnnotations();
        if (annotations != null && !annotations.isEmpty()) {
            for (Map.Entry entry : annotations.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (!SecretKeys.isSecretKey(key)) continue;
                SecretKeys keyType = SecretKeys.fromValue(key);
                for (String name : Secrets.getNames(value)) {
                    HashMap<String, String> data = new HashMap<String, String>();
                    Secret secret = null;
                    try {
                        secret = (Secret)((ClientResource)((ClientNonNamespaceOperation)client.secrets().inNamespace(session.getNamespace())).withName(name)).get();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (secret != null) continue;
                    for (String c : Secrets.getContents(value, name)) {
                        data.put(c, keyType.generate());
                    }
                    secret = ((DoneableSecret)((DoneableSecret)((SecretFluent.MetadataNested)((DoneableSecret)((ClientNonNamespaceOperation)client.secrets().inNamespace(session.getNamespace())).createNew()).withNewMetadata().withName(name)).endMetadata()).withData(data)).done();
                    secrets.add(secret);
                }
            }
        }
        return secrets;
    }
}

