/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.arquillian.kubernetes;

import io.fabric8.arquillian.kubernetes.Constants;
import io.fabric8.kubernetes.client.internal.Utils;
import io.fabric8.utils.Strings;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Configuration {
    private String masterUrl;
    private List<String> environmentDependencies = new ArrayList<String>();
    private URL environmentConfigUrl;
    private String namespaceToUse;
    private boolean namespaceLazyCreateEnabled = Constants.DEFAULT_NAMESPACE_LAZY_CREATE_ENABLED;
    private boolean namespaceCleanupEnabled = Constants.DEFAULT_NAMESPACE_CLEANUP_ENABLED;
    private long namespaceCleanupTimeout = 10000L;
    private boolean namespaceCleanupConfirmationEnabled = false;
    private long waitTimeout = Constants.DEFAULT_WAIT_TIMEOUT;
    private long waitPollInterval = Constants.DEFAULT_WAIT_POLL_INTERVAL;
    private boolean waitForServiceConnectionEnabled = Constants.DEFAULT_WAIT_FOR_SERVICE_CONNECTION_ENABLED;
    private List<String> waitForServiceList = new ArrayList<String>();
    private long waitForServiceConnectionTimeout = Constants.DEFAULT_WAIT_FOR_SERVICE_CONNECTION_TIMEOUT;
    private boolean ansiLoggerEnabled = true;
    private boolean environmentInitEnabled = true;
    private String kubernetesDomain;
    private Boolean gofabric8Enabled;
    private Map<String, String> properties;

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Boolean getGofabric8Enabled() {
        return this.gofabric8Enabled;
    }

    public String getKubernetesDomain() {
        return this.kubernetesDomain;
    }

    public boolean isEnvironmentInitEnabled() {
        return this.environmentInitEnabled;
    }

    public boolean isAnsiLoggerEnabled() {
        return this.ansiLoggerEnabled;
    }

    public long getWaitForServiceConnectionTimeout() {
        return this.waitForServiceConnectionTimeout;
    }

    public List<String> getWaitForServiceList() {
        return this.waitForServiceList;
    }

    public boolean isWaitForServiceConnectionEnabled() {
        return this.waitForServiceConnectionEnabled;
    }

    public long getWaitPollInterval() {
        return this.waitPollInterval;
    }

    public long getWaitTimeout() {
        return this.waitTimeout;
    }

    public boolean isNamespaceCleanupConfirmationEnabled() {
        return this.namespaceCleanupConfirmationEnabled;
    }

    public long getNamespaceCleanupTimeout() {
        return this.namespaceCleanupTimeout;
    }

    public boolean isNamespaceCleanupEnabled() {
        return this.namespaceCleanupEnabled;
    }

    public boolean isNamespaceLazyCreateEnabled() {
        return this.namespaceLazyCreateEnabled;
    }

    public String getNamespaceToUse() {
        return this.namespaceToUse;
    }

    public URL getEnvironmentConfigUrl() {
        return this.environmentConfigUrl;
    }

    public List<String> getEnvironmentDependencies() {
        return this.environmentDependencies;
    }

    public String getMasterUrl() {
        return this.masterUrl;
    }

    public boolean isUseGoFabric8() {
        return this.gofabric8Enabled != null && this.gofabric8Enabled != false;
    }

    public static Configuration fromMap(Map<String, String> map) {
        Configuration configuration = new Configuration();
        try {
            configuration.masterUrl = Configuration.getStringProperty("kubernetes.master", map, "https://kubernetes.default.svc");
            configuration.environmentInitEnabled = Configuration.getBooleanProperty("env.init.enabled", map, true);
            configuration.environmentConfigUrl = Configuration.getKubernetesConfigurationUrl(map);
            configuration.environmentDependencies = Strings.splitAndTrimAsList((String)Configuration.getStringProperty("env.dependencies", map, ""), (String)" ");
            configuration.namespaceLazyCreateEnabled = Configuration.getBooleanProperty("namespace.lazy.enabled", map, Constants.DEFAULT_NAMESPACE_LAZY_CREATE_ENABLED);
            configuration.namespaceToUse = Configuration.getStringProperty("namespace.use.existing", map, null);
            configuration.namespaceCleanupEnabled = Configuration.getBooleanProperty("namespace.cleanup.enabled", map, Strings.isNullOrBlank((String)configuration.namespaceToUse));
            configuration.namespaceCleanupConfirmationEnabled = Configuration.getBooleanProperty("namespace.cleanup.confirm.enabled", map, false);
            configuration.namespaceCleanupTimeout = Configuration.getLongProperty("namespace.cleanup.timeout", map, Constants.DEFAULT_NAMESPACE_CLEANUP_TIMEOUT);
            configuration.waitTimeout = Configuration.getLongProperty("wait.timeout", map, Constants.DEFAULT_WAIT_TIMEOUT);
            configuration.waitPollInterval = Configuration.getLongProperty("wait.poll.interval", map, Constants.DEFAULT_WAIT_POLL_INTERVAL);
            configuration.waitForServiceList = Strings.splitAndTrimAsList((String)Configuration.getStringProperty("wait.for.service.list", map, ""), (String)" ");
            configuration.waitForServiceConnectionEnabled = Configuration.getBooleanProperty("wait.for.service.connection.enabled", map, Constants.DEFAULT_WAIT_FOR_SERVICE_CONNECTION_ENABLED);
            configuration.waitForServiceConnectionTimeout = Configuration.getLongProperty("wait.for.service.connection.timeout", map, Constants.DEFAULT_NAMESPACE_CLEANUP_TIMEOUT);
            configuration.ansiLoggerEnabled = Configuration.getBooleanProperty("ansi.logger.enabled", map, true);
            configuration.kubernetesDomain = Configuration.getStringProperty("kubernetes.domain", map, "vagrant.f8");
            configuration.gofabric8Enabled = Configuration.getBooleanProperty("gofabric8.enabled", map, false);
            configuration.properties = map;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        return configuration;
    }

    private static URL getKubernetesConfigurationUrl(Map<String, String> map) throws MalformedURLException {
        if (map.containsKey("env.config.url")) {
            return new URL(map.get("env.config.url"));
        }
        if (map.containsKey("env.config.resource.name")) {
            String resourceName = map.get("env.config.resource.name");
            return resourceName.startsWith("/") ? Configuration.class.getResource(resourceName) : Configuration.class.getResource("/" + resourceName);
        }
        if (Strings.isNotBlank((String)Utils.getSystemPropertyOrEnvVar((String)"env.config.url", (String)""))) {
            return new URL(Utils.getSystemPropertyOrEnvVar((String)"env.config.url", (String)""));
        }
        String resourceName = Utils.getSystemPropertyOrEnvVar((String)"env.config.resource.name", (String)"/kubernetes.json");
        return resourceName.startsWith("/") ? Configuration.class.getResource(resourceName) : Configuration.class.getResource("/" + resourceName);
    }

    private static String getStringProperty(String name, Map<String, String> map, String defaultValue) {
        if (map.containsKey(name)) {
            return map.get(name);
        }
        return Utils.getSystemPropertyOrEnvVar((String)name, (String)defaultValue);
    }

    private static Boolean getBooleanProperty(String name, Map<String, String> map, Boolean defaultValue) {
        if (map.containsKey(name)) {
            return Boolean.parseBoolean(map.get(name));
        }
        return Utils.getSystemPropertyOrEnvVar((String)name, (Boolean)defaultValue);
    }

    private static Long getLongProperty(String name, Map<String, String> map, Long defaultValue) {
        if (map.containsKey(name)) {
            return Long.parseLong(map.get(name));
        }
        return Long.parseLong(Utils.getSystemPropertyOrEnvVar((String)name, (String)String.valueOf(defaultValue)));
    }
}

